/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.samtools.util.Lazy;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.JEXLMap;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;

public class VariantContextUtils {
    private static Set<String> MISSING_KEYS_WARNED_ABOUT = new HashSet<String>();
    public static final Lazy<JexlEngine> engine = new Lazy<JexlEngine>(new Lazy.LazyInitializer<JexlEngine>(){

        @Override
        public JexlEngine make() {
            JexlEngine jexlEngine = new JexlEngine();
            jexlEngine.setSilent(false);
            jexlEngine.setLenient(false);
            jexlEngine.setDebug(false);
            return jexlEngine;
        }
    });
    private static final boolean ASSUME_MISSING_FIELDS_ARE_STRINGS = false;

    public static double calculateAltAlleleFrequency(VariantContext variantContext) {
        double d;
        if (!variantContext.hasAttribute("AN") || !variantContext.hasAttribute("AC")) {
            throw new AssertionError((Object)String.format("Cannot compute the provided variant's alt allele frequency because it does not have both %s and %s annotations: %s", "AN", "AC", variantContext));
        }
        double d2 = variantContext.getAttributeAsInt("AC", 0);
        double d3 = d2 / (d = (double)variantContext.getAttributeAsInt("AN", 0));
        if (d3 > 1.0 || d3 < 0.0) {
            throw new AssertionError((Object)String.format("Expected a minor allele frequency in the range [0, 1], but got %s. vc=%s", d3, variantContext));
        }
        return d3;
    }

    public static Map<String, Object> calculateChromosomeCounts(VariantContext variantContext, Map<String, Object> map, boolean bl) {
        return VariantContextUtils.calculateChromosomeCounts(variantContext, map, bl, new HashSet<String>(0));
    }

    public static Map<String, Object> calculateChromosomeCounts(VariantContext variantContext, Map<String, Object> map, boolean bl, Set<String> set) {
        int n = variantContext.getCalledChrCount();
        if (n == 0 && bl) {
            if (map.containsKey("AC")) {
                map.remove("AC");
            }
            if (map.containsKey("AF")) {
                map.remove("AF");
            }
            if (map.containsKey("AN")) {
                map.remove("AN");
            }
            return map;
        }
        if (variantContext.hasGenotypes()) {
            map.put("AN", n);
            if (variantContext.getAlternateAlleles().size() > 0) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                double d = variantContext.getCalledChrCount(set);
                for (Allele allele : variantContext.getAlternateAlleles()) {
                    int n2 = variantContext.getCalledChrCount(allele, set);
                    arrayList2.add(variantContext.getCalledChrCount(allele));
                    arrayList3.add(n2);
                    if (n == 0) {
                        arrayList.add(0.0);
                        continue;
                    }
                    Double d2 = (double)n2 / d;
                    arrayList.add(d2);
                }
                map.put("AC", arrayList2.size() == 1 ? (Serializable)arrayList2.get(0) : arrayList2);
                map.put("AF", arrayList.size() == 1 ? (Serializable)arrayList.get(0) : arrayList);
            } else {
                map.remove("AC");
                map.remove("AF");
            }
        }
        return map;
    }

    public static void calculateChromosomeCounts(VariantContextBuilder variantContextBuilder, boolean bl) {
        VariantContext variantContext = variantContextBuilder.make();
        variantContextBuilder.attributes(VariantContextUtils.calculateChromosomeCounts(variantContext, new HashMap<String, Object>(variantContext.getAttributes()), bl, new HashSet<String>(0)));
    }

    public static void calculateChromosomeCounts(VariantContextBuilder variantContextBuilder, boolean bl, Set<String> set) {
        VariantContext variantContext = variantContextBuilder.make();
        variantContextBuilder.attributes(VariantContextUtils.calculateChromosomeCounts(variantContext, new HashMap<String, Object>(variantContext.getAttributes()), bl, set));
    }

    public static final VCFCompoundHeaderLine getMetaDataForField(VCFHeader vCFHeader, String string) {
        VCFCompoundHeaderLine vCFCompoundHeaderLine = vCFHeader.getFormatHeaderLine(string);
        if (vCFCompoundHeaderLine == null) {
            vCFCompoundHeaderLine = vCFHeader.getInfoHeaderLine(string);
        }
        if (vCFCompoundHeaderLine == null) {
            throw new TribbleException("Fully decoding VariantContext requires header line for all fields, but none was found for " + string);
        }
        return vCFCompoundHeaderLine;
    }

    public static List<JexlVCMatchExp> initializeMatchExps(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("BUG: neither names nor exps can be null: names " + Arrays.toString(stringArray) + " exps=" + Arrays.toString(stringArray2));
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Inconsistent number of provided filter names and expressions: names=" + Arrays.toString(stringArray) + " exps=" + Arrays.toString(stringArray2));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], stringArray2[i]);
        }
        return VariantContextUtils.initializeMatchExps(hashMap);
    }

    public static List<JexlVCMatchExp> initializeMatchExps(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        String[] stringArray = new String[arrayList.size()];
        String[] stringArray2 = new String[arrayList2.size()];
        return VariantContextUtils.initializeMatchExps(arrayList.toArray(stringArray), arrayList2.toArray(stringArray2));
    }

    public static List<JexlVCMatchExp> initializeMatchExps(Map<String, String> map) {
        ArrayList<JexlVCMatchExp> arrayList = new ArrayList<JexlVCMatchExp>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string == null || string2 == null) {
                throw new IllegalArgumentException("Cannot create null expressions : " + string + " " + string2);
            }
            try {
                Expression expression = engine.get().createExpression(string2);
                arrayList.add(new JexlVCMatchExp(string, expression));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Argument " + string + "has a bad value. Invalid expression used (" + string2 + "). Please see the JEXL docs for correct syntax.");
            }
        }
        return arrayList;
    }

    public static boolean match(VariantContext variantContext, JexlVCMatchExp jexlVCMatchExp) {
        return VariantContextUtils.match(variantContext, Arrays.asList(jexlVCMatchExp)).get(jexlVCMatchExp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext variantContext, Collection<JexlVCMatchExp> collection) {
        return new JEXLMap(collection, variantContext);
    }

    public static boolean match(VariantContext variantContext, Genotype genotype, JexlVCMatchExp jexlVCMatchExp) {
        return VariantContextUtils.match(variantContext, genotype, Arrays.asList(jexlVCMatchExp)).get(jexlVCMatchExp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext variantContext, Genotype genotype, Collection<JexlVCMatchExp> collection) {
        return new JEXLMap(collection, variantContext, genotype);
    }

    public static VariantContext sitesOnlyVariantContext(VariantContext variantContext) {
        return new VariantContextBuilder(variantContext).noGenotypes().make();
    }

    public static Collection<VariantContext> sitesOnlyVariantContexts(Collection<VariantContext> collection) {
        ArrayList<VariantContext> arrayList = new ArrayList<VariantContext>();
        for (VariantContext variantContext : collection) {
            arrayList.add(VariantContextUtils.sitesOnlyVariantContext(variantContext));
        }
        return arrayList;
    }

    public static int getSize(VariantContext variantContext) {
        return variantContext.getEnd() - variantContext.getStart() + 1;
    }

    public static Set<String> genotypeNames(Collection<Genotype> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (Genotype genotype : collection) {
            hashSet.add(genotype.getSampleName());
        }
        return hashSet;
    }

    public static int computeEndFromAlleles(List<Allele> list, int n, int n2) {
        Allele allele = list.get(0);
        if (allele.isNonReference()) {
            throw new IllegalStateException("computeEndFromAlleles requires first allele to be reference");
        }
        if (VariantContext.hasSymbolicAlleles(list)) {
            if (n2 == -1) {
                throw new IllegalStateException("computeEndFromAlleles found a symbolic allele but endForSymbolicAlleles was provided");
            }
            return n2;
        }
        return n + Math.max(allele.length() - 1, 0);
    }

    public static class JexlVCMatchExp {
        public String name;
        public Expression exp;

        public JexlVCMatchExp(String string, Expression expression) {
            this.name = string;
            this.exp = expression;
        }
    }
}

