/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.util.Comparator;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.PriorityBlockingQueue;

abstract class SortingVariantContextWriterBase
implements VariantContextWriter {
    private final VariantContextWriter innerWriter;
    private final Queue<VCFRecord> queue;
    protected Integer mostUpstreamWritableLoc;
    protected static final int BEFORE_MOST_UPSTREAM_LOC = 0;
    private final Set<String> finishedChromosomes;
    private final boolean takeOwnershipOfInner;

    public SortingVariantContextWriterBase(VariantContextWriter variantContextWriter, boolean bl) {
        this.innerWriter = variantContextWriter;
        this.finishedChromosomes = new TreeSet<String>();
        this.takeOwnershipOfInner = bl;
        this.queue = new PriorityBlockingQueue<VCFRecord>(50, new VariantContextComparator());
        this.mostUpstreamWritableLoc = 0;
    }

    public SortingVariantContextWriterBase(VariantContextWriter variantContextWriter) {
        this(variantContextWriter, false);
    }

    @Override
    public void writeHeader(VCFHeader vCFHeader) {
        this.innerWriter.writeHeader(vCFHeader);
    }

    @Override
    public void close() {
        this.stopWaitingToSort();
        if (this.takeOwnershipOfInner) {
            this.innerWriter.close();
        }
    }

    @Override
    public synchronized void add(VariantContext variantContext) {
        VCFRecord vCFRecord = this.queue.peek();
        if (vCFRecord != null && !variantContext.getChr().equals(vCFRecord.vc.getChr())) {
            if (this.finishedChromosomes.contains(variantContext.getChr())) {
                throw new IllegalArgumentException("Added a record at " + variantContext.getChr() + ":" + variantContext.getStart() + ", but already finished with chromosome" + variantContext.getChr());
            }
            this.finishedChromosomes.add(vCFRecord.vc.getChr());
            this.stopWaitingToSort();
        }
        this.noteCurrentRecord(variantContext);
        this.queue.add(new VCFRecord(variantContext));
        this.emitSafeRecords();
    }

    public String toString() {
        return this.getClass().getName();
    }

    private synchronized void stopWaitingToSort() {
        this.emitRecords(true);
        this.mostUpstreamWritableLoc = 0;
    }

    protected synchronized void emitSafeRecords() {
        this.emitRecords(false);
    }

    protected void noteCurrentRecord(VariantContext variantContext) {
        if (this.mostUpstreamWritableLoc != null && variantContext.getStart() < this.mostUpstreamWritableLoc) {
            throw new IllegalArgumentException("Permitted to write any record upstream of position " + this.mostUpstreamWritableLoc + ", but a record at " + variantContext.getChr() + ":" + variantContext.getStart() + " was just added.");
        }
    }

    private synchronized void emitRecords(boolean bl) {
        while (!this.queue.isEmpty()) {
            VCFRecord vCFRecord = this.queue.peek();
            if (!bl && this.mostUpstreamWritableLoc != null && vCFRecord.vc.getStart() > this.mostUpstreamWritableLoc) break;
            this.queue.poll();
            this.innerWriter.add(vCFRecord.vc);
        }
    }

    private static class VCFRecord {
        public VariantContext vc;

        public VCFRecord(VariantContext variantContext) {
            this.vc = variantContext;
        }
    }

    private static class VariantContextComparator
    implements Comparator<VCFRecord> {
        private VariantContextComparator() {
        }

        @Override
        public int compare(VCFRecord vCFRecord, VCFRecord vCFRecord2) {
            return vCFRecord.vc.getStart() - vCFRecord2.vc.getStart();
        }
    }
}

