/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import java.util.LinkedHashMap;
import java.util.Map;

public class VCFContigHeaderLine
extends VCFSimpleHeaderLine {
    final Integer contigIndex;

    public VCFContigHeaderLine(String string, VCFHeaderVersion vCFHeaderVersion, String string2, int n) {
        super(string, vCFHeaderVersion, string2, null);
        if (n < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = n;
    }

    public VCFContigHeaderLine(Map<String, String> map, int n) {
        super("contig", map);
        if (n < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = n;
    }

    VCFContigHeaderLine(final SAMSequenceRecord sAMSequenceRecord, final String string) {
        super("contig", (Map<String, String>)new LinkedHashMap<String, String>(){
            {
                this.put("ID", sAMSequenceRecord.getSequenceName());
                this.put("length", Integer.toString(sAMSequenceRecord.getSequenceLength()));
                if (string != null) {
                    this.put("assembly", string);
                }
            }
        });
        this.contigIndex = sAMSequenceRecord.getSequenceIndex();
    }

    public Integer getContigIndex() {
        return this.contigIndex;
    }

    public SAMSequenceRecord getSAMSequenceRecord() {
        String string = this.getGenericFieldValue("length");
        if (string == null) {
            throw new TribbleException("Contig " + this.getID() + " does not have a length field.");
        }
        SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(this.getID(), Integer.valueOf(string));
        sAMSequenceRecord.setAssembly(this.getGenericFieldValue("assembly"));
        sAMSequenceRecord.setSequenceIndex(this.contigIndex);
        return sAMSequenceRecord;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof VCFContigHeaderLine) {
            return this.contigIndex.compareTo(((VCFContigHeaderLine)object).contigIndex);
        }
        return super.compareTo(object);
    }
}

