/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class VCFUtils {
    public static Set<VCFHeaderLine> smartMergeHeaders(Collection<VCFHeader> collection, boolean bl) throws IllegalStateException {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        HeaderConflictWarner headerConflictWarner = new HeaderConflictWarner(bl);
        for (VCFHeader vCFHeader : collection) {
            for (VCFHeaderLine vCFHeaderLine : vCFHeader.getMetaDataInSortedOrder()) {
                String string = vCFHeaderLine.getKey();
                if (vCFHeaderLine instanceof VCFIDHeaderLine) {
                    string = string + "-" + ((VCFIDHeaderLine)((Object)vCFHeaderLine)).getID();
                }
                if (treeMap.containsKey(string)) {
                    Object object;
                    Object object2;
                    VCFHeaderLine vCFHeaderLine2 = (VCFHeaderLine)treeMap.get(string);
                    if (vCFHeaderLine.equals(vCFHeaderLine2)) continue;
                    if (!vCFHeaderLine.getClass().equals(vCFHeaderLine2.getClass())) {
                        throw new IllegalStateException("Incompatible header types: " + vCFHeaderLine + " " + vCFHeaderLine2);
                    }
                    if (vCFHeaderLine instanceof VCFFilterHeaderLine) {
                        object2 = ((VCFFilterHeaderLine)vCFHeaderLine).getID();
                        if (((String)object2).equals(object = ((VCFFilterHeaderLine)vCFHeaderLine2).getID())) continue;
                        throw new IllegalStateException("Incompatible header types: " + vCFHeaderLine + " " + vCFHeaderLine2);
                    }
                    if (vCFHeaderLine instanceof VCFCompoundHeaderLine) {
                        object2 = (VCFCompoundHeaderLine)vCFHeaderLine;
                        object = (VCFCompoundHeaderLine)vCFHeaderLine2;
                        if (!((VCFCompoundHeaderLine)object2).equalsExcludingDescription((VCFCompoundHeaderLine)object)) {
                            if (((VCFCompoundHeaderLine)object2).getType().equals((Object)((VCFCompoundHeaderLine)object).getType())) {
                                headerConflictWarner.warn(vCFHeaderLine, "Promoting header field Number to . due to number differences in header lines: " + vCFHeaderLine + " " + vCFHeaderLine2);
                                ((VCFCompoundHeaderLine)object).setNumberToUnbounded();
                            } else if (((VCFCompoundHeaderLine)object2).getType() == VCFHeaderLineType.Integer && ((VCFCompoundHeaderLine)object).getType() == VCFHeaderLineType.Float) {
                                headerConflictWarner.warn(vCFHeaderLine, "Promoting Integer to Float in header: " + object);
                                treeMap.put(string, object);
                            } else if (((VCFCompoundHeaderLine)object2).getType() == VCFHeaderLineType.Float && ((VCFCompoundHeaderLine)object).getType() == VCFHeaderLineType.Integer) {
                                headerConflictWarner.warn(vCFHeaderLine, "Promoting Integer to Float in header: " + object);
                            } else {
                                throw new IllegalStateException("Incompatible header types, collision between these two types: " + vCFHeaderLine + " " + vCFHeaderLine2);
                            }
                        }
                        if (((VCFCompoundHeaderLine)object2).getDescription().equals(((VCFCompoundHeaderLine)object).getDescription())) continue;
                        headerConflictWarner.warn(vCFHeaderLine, "Allowing unequal description fields through: keeping " + object + " excluding " + object2);
                        continue;
                    }
                    headerConflictWarner.warn(vCFHeaderLine, "Ignoring header line already in map: this header line = " + vCFHeaderLine + " already present header = " + vCFHeaderLine2);
                    continue;
                }
                treeMap.put(string, vCFHeaderLine);
            }
        }
        return new LinkedHashSet<VCFHeaderLine>(treeMap.values());
    }

    public static VCFHeader withUpdatedContigs(VCFHeader vCFHeader, File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return new VCFHeader(VCFUtils.withUpdatedContigsAsLines(vCFHeader.getMetaDataInInputOrder(), file, sAMSequenceDictionary), vCFHeader.getGenotypeSamples());
    }

    public static Set<VCFHeaderLine> withUpdatedContigsAsLines(Set<VCFHeaderLine> set, File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return VCFUtils.withUpdatedContigsAsLines(set, file, sAMSequenceDictionary, false);
    }

    public static Set<VCFHeaderLine> withUpdatedContigsAsLines(Set<VCFHeaderLine> set, File file, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        LinkedHashSet<VCFHeaderLine> linkedHashSet = new LinkedHashSet<VCFHeaderLine>(set.size());
        for (VCFHeaderLine vCFHeaderLine : set) {
            if (vCFHeaderLine instanceof VCFContigHeaderLine || vCFHeaderLine.getKey().equals("reference")) continue;
            linkedHashSet.add(vCFHeaderLine);
        }
        for (VCFContigHeaderLine vCFContigHeaderLine : VCFUtils.makeContigHeaderLines(sAMSequenceDictionary, file)) {
            linkedHashSet.add(vCFContigHeaderLine);
        }
        if (file != null) {
            int n;
            String string = bl ? ((n = file.getName().lastIndexOf(".")) == -1 ? file.getName() : file.getName().substring(0, n)) : "file://" + file.getAbsolutePath();
            linkedHashSet.add(new VCFHeaderLine("reference", string));
        }
        return linkedHashSet;
    }

    public static List<VCFContigHeaderLine> makeContigHeaderLines(SAMSequenceDictionary sAMSequenceDictionary, File file) {
        ArrayList<VCFContigHeaderLine> arrayList = new ArrayList<VCFContigHeaderLine>();
        String string = file != null ? VCFUtils.getReferenceAssembly(file.getName()) : null;
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            arrayList.add(VCFUtils.makeContigHeaderLine(sAMSequenceRecord, string));
        }
        return arrayList;
    }

    private static VCFContigHeaderLine makeContigHeaderLine(SAMSequenceRecord sAMSequenceRecord, String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(3);
        linkedHashMap.put("ID", sAMSequenceRecord.getSequenceName());
        linkedHashMap.put("length", String.valueOf(sAMSequenceRecord.getSequenceLength()));
        if (string != null) {
            linkedHashMap.put("assembly", string);
        }
        return new VCFContigHeaderLine(linkedHashMap, sAMSequenceRecord.getSequenceIndex());
    }

    private static String getReferenceAssembly(String string) {
        String string2 = null;
        if (string.contains("b37") || string.contains("v37")) {
            string2 = "b37";
        } else if (string.contains("b36")) {
            string2 = "b36";
        } else if (string.contains("hg18")) {
            string2 = "hg18";
        } else if (string.contains("hg19")) {
            string2 = "hg19";
        }
        return string2;
    }

    private static final class HeaderConflictWarner {
        boolean emitWarnings;
        Set<String> alreadyIssued = new HashSet<String>();

        private HeaderConflictWarner(boolean bl) {
            this.emitWarnings = bl;
        }

        public void warn(VCFHeaderLine vCFHeaderLine, String string) {
        }
    }
}

