/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class FileVirtualSplit
extends InputSplit
implements Writable {
    private Path file;
    private long vStart;
    private long vEnd;
    private final String[] locations;
    private static final String[] NO_LOCATIONS = new String[0];

    public FileVirtualSplit() {
        this.locations = NO_LOCATIONS;
    }

    public FileVirtualSplit(Path f, long vs, long ve, String[] locs) {
        this.file = f;
        this.vStart = vs;
        this.vEnd = ve;
        this.locations = locs;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public long getLength() {
        long veHi = this.vEnd & 0xFFFFFFFFFFFF0000L;
        long vsHi = this.vStart & 0xFFFFFFFFFFFF0000L;
        long hiDiff = veHi - vsHi;
        return hiDiff == 0L ? (this.vEnd & 0xFFFFL) - (this.vStart & 0xFFFFL) : hiDiff;
    }

    public Path getPath() {
        return this.file;
    }

    public long getStartVirtualOffset() {
        return this.vStart;
    }

    public long getEndVirtualOffset() {
        return this.vEnd;
    }

    public void setStartVirtualOffset(long vo) {
        this.vStart = vo;
    }

    public void setEndVirtualOffset(long vo) {
        this.vEnd = vo;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.file.toString());
        out.writeLong(this.vStart);
        out.writeLong(this.vEnd);
    }

    public void readFields(DataInput in) throws IOException {
        this.file = new Path(Text.readString((DataInput)in));
        this.vStart = in.readLong();
        this.vEnd = in.readLong();
    }
}

