/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.WorkaroundingStream;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public class SAMRecordReader
extends RecordReader<LongWritable, SAMRecordWritable> {
    private LongWritable key = new LongWritable();
    private SAMRecordWritable record = new SAMRecordWritable();
    private FSDataInputStream input;
    private SAMRecordIterator iterator;
    private long start;
    private long end;
    private boolean isInitialized = false;
    private WorkaroundingStream waInput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        block11: {
            if (this.isInitialized) {
                this.close();
            }
            this.isInitialized = true;
            FileSplit split = (FileSplit)spl;
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            Configuration conf = ContextUtil.getConfiguration((JobContext)ctx);
            ValidationStringency stringency = SAMHeaderReader.getValidationStringency(conf);
            Path file = split.getPath();
            FileSystem fs = file.getFileSystem(conf);
            this.input = fs.open(file);
            ValidationStringency origStringency = null;
            try {
                boolean firstSplit;
                if (stringency != null) {
                    origStringency = SAMFileReader.getDefaultValidationStringency();
                    SAMFileReader.setDefaultValidationStringency((ValidationStringency)stringency);
                }
                SAMFileHeader header = new SAMFileReader((InputStream)this.input, false).getFileHeader();
                this.waInput = new WorkaroundingStream((InputStream)this.input, header);
                boolean bl = firstSplit = this.start == 0L;
                if (firstSplit) {
                    int headerLength = this.waInput.getRemainingHeaderLength();
                    this.input.seek((long)headerLength);
                    this.start += (long)headerLength;
                } else {
                    this.input.seek(--this.start);
                }
                this.waInput.setLength(this.end - this.start);
                this.iterator = new SAMFileReader((InputStream)this.waInput, false).iterator();
                if (firstSplit) break block11;
                try {
                    if (this.iterator.hasNext()) {
                        this.iterator.next();
                    }
                }
                catch (SAMFormatException e) {
                    // empty catch block
                }
            }
            finally {
                if (origStringency != null) {
                    SAMFileReader.setDefaultValidationStringency((ValidationStringency)origStringency);
                }
            }
        }
    }

    public void close() throws IOException {
        this.iterator.close();
    }

    public float getProgress() throws IOException {
        long pos = this.input.getPos();
        if (pos >= this.end) {
            return 1.0f;
        }
        return (float)(pos - this.start) / (float)(this.end - this.start);
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public SAMRecordWritable getCurrentValue() {
        return this.record;
    }

    public boolean nextKeyValue() {
        if (!this.iterator.hasNext()) {
            return false;
        }
        SAMRecord r = (SAMRecord)this.iterator.next();
        this.key.set(BAMRecordReader.getKey(r));
        this.record.set(r);
        return true;
    }
}

