/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFEncoder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seqdoop.hadoop_bam.LazyBCFGenotypesContext;
import org.seqdoop.hadoop_bam.LazyVCFGenotypesContext;
import org.seqdoop.hadoop_bam.VariantContextWithHeader;

public final class VariantContextCodec {
    public static void write(DataOutput out, VariantContext vc) throws IOException {
        int numGenotypes;
        Object genotypesData;
        if (vc.getGenotypes().isLazyWithData()) {
            LazyGenotypesContext gc = (LazyGenotypesContext)vc.getGenotypes();
            genotypesData = gc.getUnparsedGenotypeData();
            numGenotypes = gc.size();
        } else if (vc instanceof VariantContextWithHeader) {
            VCFHeader header = ((VariantContextWithHeader)vc).getHeader();
            if (header == null) {
                throw new IllegalStateException("Header not set inside VariantContextWithHeader");
            }
            List genotypeAttributeKeys = vc.calcVCFGenotypeKeys(header);
            StringBuilder builder = new StringBuilder();
            if (!genotypeAttributeKeys.isEmpty()) {
                String genotypeFormatString = ParsingUtils.join((String)":", (Collection)genotypeAttributeKeys);
                builder.append("\t");
                builder.append(genotypeFormatString);
                VCFEncoder encoder = new VCFEncoder(header, true);
                Map map = encoder.buildAlleleStrings(vc);
                encoder.addGenotypeData(vc, map, genotypeAttributeKeys, builder);
            }
            genotypesData = builder.toString();
            numGenotypes = vc.getGenotypes().size();
        } else {
            throw new IllegalStateException("Cannot write fully decoded VariantContext: need lazy genotypes or VCF Header");
        }
        if (!(genotypesData instanceof String) && !(genotypesData instanceof BCF2Codec.LazyData)) {
            throw new IllegalStateException("Unrecognized unparsed genotype data, expected String or BCF2Codec.LazyData: " + genotypesData.getClass());
        }
        byte[] chrom = vc.getChr().getBytes("UTF-8");
        out.writeInt(chrom.length);
        out.write(chrom);
        out.writeInt(vc.getStart());
        out.writeInt(vc.getEnd());
        byte[] id = vc.getID().getBytes("UTF-8");
        out.writeInt(id.length);
        out.write(id);
        List alleles = vc.getAlleles();
        out.writeInt(alleles.size());
        for (Allele allele : alleles) {
            byte[] byArray = allele.getDisplayBases();
            out.writeInt(byArray.length);
            out.write(byArray);
        }
        if (vc.hasLog10PError()) {
            out.writeFloat((float)vc.getLog10PError());
        } else {
            out.writeInt(2139095041);
        }
        if (vc.isFiltered()) {
            Set filters = vc.getFilters();
            out.writeInt(filters.size());
            for (String string : filters) {
                byte[] b = string.getBytes("UTF-8");
                out.writeInt(b.length);
                out.write(b);
            }
        } else {
            out.writeInt(vc.filtersWereApplied() ? -1 : -2);
        }
        Map attrs = vc.getAttributes();
        out.writeInt(attrs.size());
        for (Map.Entry entry : attrs.entrySet()) {
            byte[] k = ((String)entry.getKey()).getBytes("UTF-8");
            out.writeInt(k.length);
            out.write(k);
            VariantContextCodec.encodeAttrVal(out, entry.getValue());
        }
        out.writeInt(numGenotypes);
        if (genotypesData instanceof String) {
            out.writeByte(0);
            byte[] genob = ((String)genotypesData).getBytes("UTF-8");
            out.writeInt(genob.length);
            out.write(genob);
        } else {
            assert (genotypesData instanceof BCF2Codec.LazyData);
            BCF2Codec.LazyData data = (BCF2Codec.LazyData)genotypesData;
            out.writeByte(1);
            out.writeInt(data.bytes.length);
            out.write(data.bytes);
            out.writeInt(data.nGenotypeFields);
        }
    }

    public static VariantContext read(DataInput in) throws IOException {
        VariantContextBuilder builder = new VariantContextBuilder();
        int len = in.readInt();
        byte[] b = new byte[len];
        in.readFully(b);
        String chrom = new String(b, "UTF-8");
        builder.chr(chrom);
        int start = in.readInt();
        builder.start((long)start);
        builder.stop((long)in.readInt());
        len = in.readInt();
        if (len == 0) {
            builder.noID();
        } else {
            if (len > b.length) {
                b = new byte[len];
            }
            in.readFully(b, 0, len);
            builder.id(new String(b, 0, len, "UTF-8"));
        }
        int count = in.readInt();
        ArrayList<Allele> alleles = new ArrayList<Allele>(count);
        for (int i = 0; i < count; ++i) {
            len = in.readInt();
            if (len > b.length) {
                b = new byte[len];
            }
            in.readFully(b, 0, len);
            alleles.add(Allele.create((byte[])Arrays.copyOf(b, len), (i == 0 ? 1 : 0) != 0));
        }
        builder.alleles(alleles);
        int qualInt = in.readInt();
        builder.log10PError(qualInt == 2139095041 ? 1.0 : (double)Float.intBitsToFloat(qualInt));
        count = in.readInt();
        switch (count) {
            case -2: {
                builder.unfiltered();
                break;
            }
            case -1: {
                builder.passFilters();
                break;
            }
            default: {
                while (count-- > 0) {
                    len = in.readInt();
                    if (len > b.length) {
                        b = new byte[len];
                    }
                    in.readFully(b, 0, len);
                    builder.filter(new String(b, 0, len, "UTF-8"));
                }
                break block0;
            }
        }
        count = in.readInt();
        HashMap<String, Object> attrs = new HashMap<String, Object>(count, 1.0f);
        while (count-- > 0) {
            len = in.readInt();
            if (len > b.length) {
                b = new byte[len];
            }
            in.readFully(b, 0, len);
            attrs.put(new String(b, 0, len, "UTF-8"), VariantContextCodec.decodeAttrVal(in));
        }
        builder.attributes(attrs);
        count = in.readInt();
        byte genoType = in.readByte();
        len = in.readInt();
        b = new byte[len];
        in.readFully(b);
        switch (genoType) {
            case 0: {
                builder.genotypesNoValidation((GenotypesContext)new LazyVCFGenotypesContext(alleles, chrom, start, b, count));
                break;
            }
            case 1: {
                builder.genotypesNoValidation((GenotypesContext)new LazyBCFGenotypesContext(alleles, in.readInt(), b, count));
                break;
            }
            default: {
                throw new IOException("Invalid genotypes type identifier: cannot decode");
            }
        }
        return builder.make();
    }

    private static void encodeAttrVal(DataOutput out, Object v) throws IOException {
        if (v instanceof Integer) {
            out.writeByte(AttrType.INT.toByte());
            out.writeInt((Integer)v);
        } else if (v instanceof Float) {
            out.writeByte(AttrType.FLOAT.toByte());
            out.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            out.writeByte(AttrType.DOUBLE.toByte());
            out.writeDouble((Double)v);
        } else if (v instanceof Boolean) {
            out.writeByte(AttrType.BOOL.toByte());
            out.writeBoolean((Boolean)v);
        } else if (v instanceof Character) {
            out.writeByte(AttrType.CHAR.toByte());
            out.writeChar(((Character)v).charValue());
        } else if (v instanceof List) {
            VariantContextCodec.encodeAttrVal(out, ((List)v).toArray());
        } else if (v.getClass().isArray()) {
            out.writeByte(AttrType.ARRAY.toByte());
            int length = Array.getLength(v);
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                VariantContextCodec.encodeAttrVal(out, Array.get(v, i));
            }
        } else {
            out.writeByte(AttrType.STRING.toByte());
            if (v == null) {
                out.writeInt(0);
            } else {
                byte[] b = v.toString().getBytes("UTF-8");
                out.writeInt(b.length);
                out.write(b);
            }
        }
    }

    private static Object decodeAttrVal(DataInput in) throws IOException {
        switch (AttrType.fromByte(in.readByte())) {
            case INT: {
                return in.readInt();
            }
            case FLOAT: {
                return Float.valueOf(in.readFloat());
            }
            case DOUBLE: {
                return in.readDouble();
            }
            case BOOL: {
                return in.readBoolean();
            }
            case CHAR: {
                return Character.valueOf(in.readChar());
            }
            case ARRAY: {
                int len = in.readInt();
                ArrayList<Object> os = new ArrayList<Object>(len);
                while (len-- > 0) {
                    os.add(VariantContextCodec.decodeAttrVal(in));
                }
                return os;
            }
            case STRING: {
                int len = in.readInt();
                if (len == 0) {
                    return null;
                }
                byte[] b = new byte[len];
                in.readFully(b);
                return new String(b, "UTF-8");
            }
        }
        assert (false);
        throw new IOException("Invalid type identifier: cannot decode");
    }

    private static enum AttrType {
        INT,
        FLOAT,
        BOOL,
        CHAR,
        STRING,
        ARRAY,
        DOUBLE;

        private static final AttrType[] values;

        public byte toByte() {
            return (byte)this.ordinal();
        }

        public static AttrType fromByte(byte b) {
            return values[b];
        }

        static {
            values = AttrType.values();
        }
    }
}

