/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.cli.Utils;

final class FixMateReducer
extends Reducer<Text, SAMRecordWritable, Text, SAMRecordWritable> {
    private final SAMRecordWritable wrec = new SAMRecordWritable();

    FixMateReducer() {
    }

    protected void reduce(Text key, Iterable<SAMRecordWritable> records, Reducer.Context ctx) throws IOException, InterruptedException {
        SAMFileHeader header = Utils.getSAMHeaderMerger(ContextUtil.getConfiguration((JobContext)ctx)).getMergedHeader();
        Iterator<SAMRecordWritable> it = records.iterator();
        while (it.hasNext()) {
            SAMRecordWritable a = it.next();
            if (a.get().getNotPrimaryAlignmentFlag()) {
                ctx.write((Object)key, (Object)a);
                continue;
            }
            this.wrec.set(a.get());
            a = this.wrec;
            SAMRecordWritable b = null;
            while (it.hasNext() && (b = it.next()).get().getNotPrimaryAlignmentFlag()) {
                ctx.write((Object)key, (Object)b);
            }
            if (b == null) {
                ctx.write((Object)key, (Object)a);
                break;
            }
            a.get().setHeader(header);
            b.get().setHeader(header);
            SamPairUtil.setMateInfo((SAMRecord)a.get(), (SAMRecord)b.get(), (SAMFileHeader)header);
            ctx.write((Object)key, (Object)a);
            ctx.write((Object)key, (Object)b);
        }
    }
}

