/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins.chipster;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.Range;

final class SummarizeRecordReader
extends RecordReader<LongWritable, Range> {
    private final RecordReader<LongWritable, SAMRecordWritable> baseRR;
    private final LongWritable key = new LongWritable();
    private final List<Range> ranges = new ArrayList<Range>();
    private int rangeIdx = 0;

    public SummarizeRecordReader(RecordReader<LongWritable, SAMRecordWritable> rr) {
        this.baseRR = rr;
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) {
    }

    public void close() throws IOException {
        this.baseRR.close();
    }

    public float getProgress() throws InterruptedException, IOException {
        return this.baseRR.getProgress();
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public Range getCurrentValue() {
        return this.ranges.get(this.rangeIdx);
    }

    public boolean nextKeyValue() throws InterruptedException, IOException {
        SAMRecord rec;
        if (this.rangeIdx + 1 < this.ranges.size()) {
            ++this.rangeIdx;
            this.key.set(this.key.get() >>> 32 << 32 | (long)this.getCurrentValue().getCentreOfMass());
            return true;
        }
        do {
            if (this.baseRR.nextKeyValue()) continue;
            return false;
        } while ((rec = ((SAMRecordWritable)this.baseRR.getCurrentValue()).get()).getReadUnmappedFlag() || rec.getReferenceIndex() < 0 || rec.getAlignmentStart() < 0);
        this.parseCIGAR(rec, rec.getReadNegativeStrandFlag());
        this.rangeIdx = 0;
        this.key.set(BAMRecordReader.getKey0(rec.getReferenceIndex(), this.getCurrentValue().getCentreOfMass()));
        return true;
    }

    void parseCIGAR(SAMRecord rec, boolean reverseStrand) {
        int begPos;
        this.ranges.clear();
        Cigar cigar = rec.getCigar();
        int endPos = begPos = rec.getAlignmentStart();
        block3: for (int i = 0; i < rec.getCigarLength(); ++i) {
            CigarElement element = cigar.getCigarElement(i);
            CigarOperator op = element.getOperator();
            switch (op) {
                case M: 
                case EQ: 
                case X: {
                    endPos += element.getLength();
                    continue block3;
                }
                default: {
                    if (begPos != endPos) {
                        this.ranges.add(new Range(begPos, endPos - 1, reverseStrand));
                        begPos = endPos;
                    }
                    if (!op.consumesReferenceBases()) continue block3;
                    endPos = begPos += element.getLength();
                }
            }
        }
        if (begPos != endPos) {
            this.ranges.add(new Range(begPos, endPos - 1, reverseStrand));
        }
    }
}

