/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class BGZFBlockIndex {
    private final NavigableSet<Long> offsets = new TreeSet<Long>();

    public BGZFBlockIndex() {
    }

    public BGZFBlockIndex(File path) throws IOException {
        this(new BufferedInputStream(new FileInputStream(path)));
    }

    public BGZFBlockIndex(InputStream in) throws IOException {
        this.readIndex(in);
    }

    public void readIndex(InputStream in) throws IOException {
        this.offsets.clear();
        ByteBuffer bb = ByteBuffer.allocate(8);
        long prev = -1L;
        while (in.read(bb.array(), 2, 6) == 6) {
            long cur = bb.getLong(0);
            if (prev > cur) {
                throw new IOException(String.format("Invalid BGZF block index; offsets not in order: %#x > %#x", prev, cur));
            }
            prev = cur;
            this.offsets.add(prev);
        }
        in.close();
        if (this.offsets.size() < 1) {
            throw new IOException("Invalid BGZF block index: should contain at least the file size");
        }
        this.offsets.add(0L);
    }

    public Long prevBlock(long filePos) {
        return this.offsets.floor(filePos);
    }

    public Long nextBlock(long filePos) {
        return this.offsets.higher(filePos);
    }

    public int size() {
        return this.offsets.size();
    }

    private long secondBlock() {
        return this.nextBlock(0L);
    }

    private long lastBlock() {
        return this.prevBlock(this.fileSize() - 1L);
    }

    private long fileSize() {
        return (Long)this.offsets.last();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: BGZFBlockIndex [BGZF block indices...]\n\nWrites a few statistics about each BGZF block index.");
            return;
        }
        for (String arg : args) {
            File f = new File(arg);
            if (f.isFile() && f.canRead()) {
                try {
                    System.err.printf("%s:\n", f);
                    BGZFBlockIndex bi = new BGZFBlockIndex(f);
                    long second = bi.secondBlock();
                    long last = bi.lastBlock();
                    System.err.printf("\t%d blocks\n\tfirst after 0 is at %#014x\n\tlast          is at %#014x\n\tassociated BGZF file size %d\n", bi.size() - 1, bi.secondBlock(), bi.lastBlock(), bi.fileSize());
                }
                catch (IOException e) {
                    System.err.printf("Failed to read %s!\n", f);
                    e.printStackTrace();
                }
                continue;
            }
            System.err.printf("%s does not look like a readable file!\n", f);
        }
    }
}

