/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;

public final class BGZFBlockIndexer {
    private final ByteBuffer byteBuffer;
    private final int granularity;
    private int pos = 0;
    private static final int PRINT_EVERY = 524288000;

    public static void main(String[] args) {
        int granularity;
        if (args.length <= 0) {
            System.out.println("Usage: BGZFBlockIndexer GRANULARITY [BGZF files...]\n\nWrites, for each GRANULARITY gzip blocks in a BGZF file, its virtual file offset\nas a big-endian 48-bit integer into [filename].bgzfi. The file is terminated by\nthe BGZF file's length, in the same format.");
            return;
        }
        try {
            granularity = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            granularity = 0;
        }
        if (granularity <= 0) {
            System.err.printf("Granularity must be a positive integer, not '%s'!\n", args[0]);
            return;
        }
        BGZFBlockIndexer indexer = new BGZFBlockIndexer(granularity);
        for (String arg : Arrays.asList(args).subList(1, args.length)) {
            File f = new File(arg);
            if (f.isFile() && f.canRead()) {
                System.out.printf("Indexing %s...", f);
                try {
                    indexer.index(f);
                    System.out.println(" done.");
                }
                catch (IOException e) {
                    System.out.println(" FAILED!");
                    e.printStackTrace();
                }
                continue;
            }
            System.err.printf("%s does not look like a file, won't index!\n", f);
        }
    }

    public BGZFBlockIndexer(int g) {
        this.granularity = g;
        this.byteBuffer = ByteBuffer.allocate(8);
    }

    private void index(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file.getPath() + ".bgzfi"));
        LongBuffer lb = this.byteBuffer.order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        long prevPrint = 0L;
        this.pos = 0;
        int i = 0;
        while (this.skipBlock(in)) {
            if (++i != this.granularity) continue;
            i = 0;
            lb.put(0, this.pos);
            ((OutputStream)out).write(this.byteBuffer.array(), 2, 6);
            if ((long)this.pos - prevPrint < 524288000L) continue;
            System.out.print("-");
            prevPrint = this.pos;
        }
        lb.put(0, file.length());
        ((OutputStream)out).write(this.byteBuffer.array(), 2, 6);
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    private boolean skipBlock(InputStream in) throws IOException {
        int slen;
        int magic;
        int read = this.readBytes(in, 4);
        if (read != 4) {
            if (read == 0) {
                return false;
            }
            this.ioError("Invalid gzip header: too short, no ID/CM/FLG", new Object[0]);
        }
        if ((magic = this.byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt(0)) != 529205252) {
            this.ioError("Invalid gzip header: bad ID/CM/FLG %#x != 0x1f8b0804", magic);
        }
        if (!this.readExactlyBytes(in, 8)) {
            this.ioError("Invalid gzip header: too short, no XLEN", new Object[0]);
        }
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int xlen = this.getUshort(6);
        for (int offset = 0; offset < xlen; offset += slen) {
            if (!this.readExactlyBytes(in, 4)) {
                this.ioError("Invalid subfields: EOF after %d subfield bytes", offset);
            }
            offset += 4;
            this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
            int siAndSlen = this.byteBuffer.getInt(0);
            this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if ((siAndSlen & 0xFFFFFF00) == 1111687680) {
                if (!this.readExactlyBytes(in, 2)) {
                    this.ioError("Invalid BGZF subfield: missing BSIZE", new Object[0]);
                }
                int bsize = this.getUshort(0);
                this.fullySkip(in, xlen - (offset += 2) + (bsize - xlen - 19) + 8);
                this.pos += bsize + 1;
                return true;
            }
            slen = this.getUshort(2);
            this.fullySkip(in, slen);
        }
        throw new IOException("Invalid BGZF file: block without BGZF subfield");
    }

    private int getUshort(int idx) {
        return this.byteBuffer.getShort(idx) & 0xFFFF;
    }

    private void fullySkip(InputStream in, int skip) throws IOException {
        int s = skip;
        while (s > 0) {
            long skipped = in.skip(s);
            if (skipped == 0L) {
                throw new IOException("Skip failed");
            }
            s = (int)((long)s - skipped);
        }
    }

    private int readBytes(InputStream in, int n) throws IOException {
        int read;
        int readNow;
        assert (n <= this.byteBuffer.capacity());
        for (read = 0; read < n && (readNow = in.read(this.byteBuffer.array(), read, n - read)) > 0; read += readNow) {
        }
        return read;
    }

    private boolean readExactlyBytes(InputStream in, int n) throws IOException {
        return this.readBytes(in, n) == n;
    }

    private void ioError(String s, Object ... va) throws IOException {
        throw new IOException(String.format(s, va));
    }
}

