/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.ValidationStringency;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.InstrumentedOrderedRDDFunctions;
import org.apache.spark.rdd.MetricsContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromReads;
import org.bdgenomics.adam.converters.AlignmentRecordConverter;
import org.bdgenomics.adam.converters.AlignmentRecordConverter$;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.RecordGroup;
import org.bdgenomics.adam.models.RecordGroup$;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.SAMFileHeaderWritable;
import org.bdgenomics.adam.models.SAMFileHeaderWritable$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.SingleReadBucket;
import org.bdgenomics.adam.models.SingleReadBucket$;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.ADAMSequenceDictionaryRDDAggregator;
import org.bdgenomics.adam.rdd.read.ADAMBAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.ADAMSAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDDFunctions$;
import org.bdgenomics.adam.rdd.read.FlagStat$;
import org.bdgenomics.adam.rdd.read.FlagStatMetrics;
import org.bdgenomics.adam.rdd.read.InstrumentedADAMBAMOutputFormat;
import org.bdgenomics.adam.rdd.read.InstrumentedADAMSAMOutputFormat;
import org.bdgenomics.adam.rdd.read.MarkDuplicates$;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndels$;
import org.bdgenomics.adam.rdd.read.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.MapTools$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.utils.cli.SaveArgs;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0001\u0003\u00015\u00111$\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a*E\t\u001a+hn\u0019;j_:\u001c(BA\u0002\u0005\u0003\u0011\u0011X-\u00193\u000b\u0005\u00151\u0011a\u0001:eI*\u0011q\u0001C\u0001\u0005C\u0012\fWN\u0003\u0002\n\u0015\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0012B\t\u0006k5+Z9vK:\u001cW\rR5di&|g.\u0019:z%\u0012#\u0015iZ4sK\u001e\fGo\u001c:\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B1we>T!a\u0006\u0005\u0002\u000f\u0019|'/\\1ug&\u0011\u0011\u0004\u0006\u0002\u0010\u00032LwM\\7f]R\u0014VmY8sI\"AQ\u0001\u0001B\u0001B\u0003%1\u0004E\u0002\u001dEIi\u0011!\b\u0006\u0003\u000byQ!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005R\u0011AB1qC\u000eDW-\u0003\u0002$;\t\u0019!\u000b\u0012#\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u0006I\u0001\u00071\u0004C\u0003,\u0001\u0011\u0005A&A\rgS2$XM\u001d\"z\u001fZ,'\u000f\\1qa&twMU3hS>tGCA\u000e.\u0011\u0015q#\u00061\u00010\u0003\u0015\tX/\u001a:z!\t\u00014'D\u00012\u0015\t\u0011d!\u0001\u0004n_\u0012,Gn]\u0005\u0003iE\u0012qBU3gKJ,gnY3SK\u001eLwN\u001c\u0005\u0006m\u0001!\taN\u0001\r[\u0006L(-Z*bm\u0016\u0014\u0015-\u001c\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012qAQ8pY\u0016\fg\u000eC\u0003@k\u0001\u0007\u0001)\u0001\u0003be\u001e\u001c\bCA!G\u001b\u0005\u0011%BA\"E\u0003\r\u0019G.\u001b\u0006\u0003\u000b\"\tQ!\u001e;jYNL!a\u0012\"\u0003\u0011M\u000bg/Z!sONDQ!\u0013\u0001\u0005\u0002)\u000ba\"\\1zE\u0016\u001c\u0016M^3GCN$\u0018\u000f\u0006\u00029\u0017\")q\b\u0013a\u0001\u0019B\u0011q\"T\u0005\u0003\u001d\u0012\u0011q\"\u0011#B\u001bN\u000bg/Z!os\u0006\u0013xm\u001d\u0005\u0006!\u0002!\t!U\u0001\u0016C\u0012\fW.\u00117jO:,GMU3d_J$7+\u0019<f)\tA$\u000bC\u0003@\u001f\u0002\u0007\u0001\tC\u0003U\u0001\u0011\u0005Q+\u0001\u0005bI\u0006l7+\u0019<f)\tAd\u000bC\u0003@'\u0002\u0007A\nC\u0003Y\u0001\u0011\u0005\u0011,A\u0007bI\u0006l7+Q'TiJLgnZ\u000b\u00025B\u00111L\u0018\b\u0003sqK!!\u0018\u001e\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;jBQA\u0019\u0001\u0005\u0002\r\f1\"\u00193b[N\u000bUjU1wKR\u0019AmZ5\u0011\u0005e*\u0017B\u00014;\u0005\u0011)f.\u001b;\t\u000b!\f\u0007\u0019\u0001.\u0002\u0011\u0019LG.\u001a)bi\"DqA[1\u0011\u0002\u0003\u0007\u0001(A\u0003bgN\u000bW\u000eC\u0003m\u0001\u0011\u0005Q.A\u000fhKR\u001cV-];f]\u000e,'+Z2pe\u0012\u001chI]8n\u000b2,W.\u001a8u)\tqw\u000fE\u0002peRl\u0011\u0001\u001d\u0006\u0003cj\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0019\bOA\u0002TKR\u0004\"\u0001M;\n\u0005Y\f$AD*fcV,gnY3SK\u000e|'\u000f\u001a\u0005\u0006q.\u0004\rAE\u0001\u0005K2,W\u000eC\u0003{\u0001\u0011\u000510\u0001\u000ebI\u0006lw)\u001a;SK\u0006$wI]8va\u0012K7\r^5p]\u0006\u0014\u0018\u0010F\u0001}!\t\u0001T0\u0003\u0002\u007fc\t)\"+Z2pe\u0012<%o\\;q\t&\u001cG/[8oCJL\bbBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0011C\u0012\fWnQ8om\u0016\u0014H\u000fV8T\u00036#\"!!\u0002\u0011\u000fe\n9!a\u0003\u0002\u001e%\u0019\u0011\u0011\u0002\u001e\u0003\rQ+\b\u000f\\33!\u0011a\"%!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005Q\u0001.\u00193p_B|&-Y7\u000b\u0007\u0005]!\"A\u0004tKF$wn\u001c9\n\t\u0005m\u0011\u0011\u0003\u0002\u0012'\u0006k%+Z2pe\u0012<&/\u001b;bE2,\u0007\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\tg\u0006lGo\\8mg*\u0011\u0011qE\u0001\u0007QR\u001c(\u000eZ6\n\t\u0005-\u0012\u0011\u0005\u0002\u000e'\u0006ke)\u001b7f\u0011\u0016\fG-\u001a:\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005q\u0011\rZ1n\u0007>,h\u000e^&nKJ\u001cH\u0003BA\u001a\u0003{\u0001B\u0001\b\u0012\u00026A1\u0011(a\u0002[\u0003o\u00012!OA\u001d\u0013\r\tYD\u000f\u0002\u0005\u0019>tw\r\u0003\u0005\u0002@\u00055\u0002\u0019AA!\u0003)YW.\u001a:MK:<G\u000f\u001b\t\u0004s\u0005\r\u0013bAA#u\t\u0019\u0011J\u001c;\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u0005\u0001\u0013\rZ1n'>\u0014HOU3bIN\u0014\u0015PU3gKJ,gnY3Q_NLG/[8o)\u0005Y\u0002bBA(\u0001\u0011\u0005\u00111J\u0001\u0013C\u0012\fW.T1sW\u0012+\b\u000f\\5dCR,7\u000fC\u0004\u0002T\u0001!\t!!\u0016\u0002\u0011\u0005$\u0017-\u001c\"R'J#RaGA,\u0003[B\u0001\"!\u0017\u0002R\u0001\u0007\u00111L\u0001\nW:|wO\\*oaN\u0004b!!\u0018\u0002d\u0005\u001dTBAA0\u0015\r\t\tGH\u0001\nEJ|\u0017\rZ2bgRLA!!\u001a\u0002`\tI!I]8bI\u000e\f7\u000f\u001e\t\u0004a\u0005%\u0014bAA6c\tA1K\u001c9UC\ndW\r\u0003\u0006\u0002p\u0005E\u0003\u0013!a\u0001\u0003c\n1c\u001c2tKJ4\u0018\r^5p]\u0012+X\u000e\u001d$jY\u0016\u0004B!OA:5&\u0019\u0011Q\u000f\u001e\u0003\r=\u0003H/[8o\u0011\u001d\tI\b\u0001C\u0001\u0003w\n\u0011#\u00193b[J+\u0017\r\\5h]&sG-\u001a7t)5Y\u0012QPAI\u0003+\u000bI*!(\u0002(\"Q\u0011qPA<!\u0003\u0005\r!!!\u0002\u001d\r|gn]3ogV\u001cXj\u001c3fYB!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!C2p]N,gn];t\u0015\r\tYIB\u0001\u000bC2<wN]5uQ6\u001c\u0018\u0002BAH\u0003\u000b\u0013!cQ8og\u0016t7/^:HK:,'/\u0019;pe\"I\u00111SA<!\u0003\u0005\r\u0001O\u0001\tSN\u001cvN\u001d;fI\"Q\u0011qSA<!\u0003\u0005\r!!\u0011\u0002\u00195\f\u00070\u00138eK2\u001c\u0016N_3\t\u0015\u0005m\u0015q\u000fI\u0001\u0002\u0004\t\t%\u0001\nnCb\u001cuN\\:f]N,8OT;nE\u0016\u0014\bBCAP\u0003o\u0002\n\u00111\u0001\u0002\"\u0006aAn\u001c3UQJ,7\u000f[8mIB\u0019\u0011(a)\n\u0007\u0005\u0015&H\u0001\u0004E_V\u0014G.\u001a\u0005\u000b\u0003S\u000b9\b%AA\u0002\u0005\u0005\u0013!D7bqR\u000b'oZ3u'&TX\rC\u0004\u0002.\u0002!\t!a,\u0002\u0019\u0005$\u0017-\u001c$mC\u001e\u001cF/\u0019;\u0015\u0005\u0005E\u0006cB\u001d\u0002\b\u0005M\u00161\u0017\t\u0004Q\u0005U\u0016bAA\\\u0005\tya\t\\1h'R\fG/T3ue&\u001c7\u000fC\u0004\u0002<\u0002!\t!!0\u0002+\u0005$\u0017-\\*j]\u001edWMU3bI\n+8m[3ugR\u0011\u0011q\u0018\t\u00059\t\n\t\rE\u00021\u0003\u0007L1!!22\u0005A\u0019\u0016N\\4mKJ+\u0017\r\u001a\"vG.,G\u000fC\u0004\u0002J\u0002!\t!a3\u0002)\u0005$\u0017-\\\"iCJ\f7\r^3sSj,G+Y4t)\t\t\u0019\u0004C\u0004\u0002P\u0002!\t!!5\u00023\u0005$\u0017-\\\"iCJ\f7\r^3sSj,G+Y4WC2,Xm\u001d\u000b\u0005\u0003'\fy\u000eE\u0004\\\u0003+\fI.a\u000e\n\u0007\u0005]\u0007MA\u0002NCB\u00042!OAn\u0013\r\tiN\u000f\u0002\u0004\u0003:L\bbBAq\u0003\u001b\u0004\rAW\u0001\u0004i\u0006<\u0007bBAs\u0001\u0011\u0005\u0011q]\u0001\u0019C\u0012\fWNR5mi\u0016\u0014(+Z2pe\u0012\u001cx+\u001b;i)\u0006<GcA\u000e\u0002j\"9\u00111^Ar\u0001\u0004Q\u0016a\u0002;bO:\u000bW.\u001a\u0005\b\u0003_\u0004A\u0011AAy\u0003U\tG-Y7TCZ,\u0017i\u001d)bSJ,GMR1tiF$\u0012\u0002ZAz\u0003o\fYP!\u0002\t\u000f\u0005U\u0018Q\u001ea\u00015\u0006Ia-\u001b7f\u001d\u0006lW-\r\u0005\b\u0003s\fi\u000f1\u0001[\u0003%1\u0017\u000e\\3OC6,'\u0007\u0003\u0006\u0002~\u00065\b\u0013!a\u0001\u0003\u007f\fAC^1mS\u0012\fG/[8o'R\u0014\u0018N\\4f]\u000eL\b\u0003BA\u0010\u0005\u0003IAAa\u0001\u0002\"\t!b+\u00197jI\u0006$\u0018n\u001c8TiJLgnZ3oGfD!Ba\u0002\u0002nB\u0005\t\u0019\u0001B\u0005\u00031\u0001XM]:jgRdUM^3m!\u0015I\u00141\u000fB\u0006!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\t=\u000591\u000f^8sC\u001e,\u0017\u0002\u0002B\u000b\u0005\u001f\u0011Ab\u0015;pe\u0006<W\rT3wK2DqA!\u0007\u0001\t\u0003\u0011Y\"A\bbI\u0006l7+\u0019<f\u0003N4\u0015m\u001d;r)-!'Q\u0004B\u0011\u0005K\u0011ICa\u000b\t\u000f\t}!q\u0003a\u00015\u0006Aa-\u001b7f\u001d\u0006lW\r\u0003\u0006\u0003$\t]\u0001\u0013!a\u0001\u0003c\nABZ5mK:\u000bW.\u001a\u001aPaRD\u0011Ba\n\u0003\u0018A\u0005\t\u0019\u0001\u001d\u0002\tM|'\u000f\u001e\u0005\u000b\u0003{\u00149\u0002%AA\u0002\u0005}\bB\u0003B\u0004\u0005/\u0001\n\u00111\u0001\u0003\n!9!q\u0006\u0001\u0005\u0002\tE\u0012aD1eC6\u0014V\rU1jeJ+\u0017\rZ:\u0015\u000bm\u0011\u0019Da\u000e\t\u000f\tU\"Q\u0006a\u00017\u0005i1/Z2p]\u0012\u0004\u0016-\u001b:SI\u0012D!\"!@\u0003.A\u0005\t\u0019AA\u0000\u0011%\u0011Y\u0004AI\u0001\n\u0003\u0011i$A\u000bbI\u0006l7+Q'TCZ,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}\"f\u0001\u001d\u0003B-\u0012!1\t\t\u0005\u0005\u000b\u0012y%\u0004\u0002\u0003H)!!\u0011\nB&\u0003%)hn\u00195fG.,GMC\u0002\u0003Ni\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tFa\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003V\u0001\t\n\u0011\"\u0001\u0003X\u0005I\u0012\rZ1n'\u00064X-Q:GCN$\u0018\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IF\u000b\u0003\u0002r\t\u0005\u0003\"\u0003B/\u0001E\u0005I\u0011\u0001B\u001f\u0003e\tG-Y7TCZ,\u0017i\u001d$bgR\fH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\t\u0005\u0004!%A\u0005\u0002\t\r\u0014!G1eC6\u001c\u0016M^3Bg\u001a\u000b7\u000f^9%I\u00164\u0017-\u001e7uIQ*\"A!\u001a+\t\u0005}(\u0011\t\u0005\n\u0005S\u0002\u0011\u0013!C\u0001\u0005W\n\u0011$\u00193b[N\u000bg/Z!t\r\u0006\u001cH/\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u000e\u0016\u0005\u0005\u0013\u0011\t\u0005C\u0005\u0003r\u0001\t\n\u0011\"\u0001\u0003X\u0005\u0011\u0012\rZ1n\u0005F\u001b&\u000b\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0011)\bAI\u0001\n\u0003\u00119(A\u000ebI\u0006l'+Z1mS\u001et\u0017J\u001c3fYN$C-\u001a4bk2$H%M\u000b\u0003\u0005sRC!!!\u0003B!I!Q\u0010\u0001\u0012\u0002\u0013\u0005!QH\u0001\u001cC\u0012\fWNU3bY&<g.\u00138eK2\u001cH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\t\u0005\u0005!%A\u0005\u0002\t\r\u0015aG1eC6\u0014V-\u00197jO:Le\u000eZ3mg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0006*\"\u0011\u0011\tB!\u0011%\u0011I\tAI\u0001\n\u0003\u0011\u0019)A\u000ebI\u0006l'+Z1mS\u001et\u0017J\u001c3fYN$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0005\u001b\u0003\u0011\u0013!C\u0001\u0005\u001f\u000b1$\u00193b[J+\u0017\r\\5h]&sG-\u001a7tI\u0011,g-Y;mi\u0012*TC\u0001BIU\u0011\t\tK!\u0011\t\u0013\tU\u0005!%A\u0005\u0002\t\r\u0015aG1eC6\u0014V-\u00197jO:Le\u000eZ3mg\u0012\"WMZ1vYR$c\u0007C\u0005\u0003\u001a\u0002\t\n\u0011\"\u0001\u0003d\u0005y\u0012\rZ1n'\u00064X-Q:QC&\u0014X\r\u001a$bgR\fH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\tu\u0005!%A\u0005\u0002\t-\u0014aH1eC6\u001c\u0016M^3BgB\u000b\u0017N]3e\r\u0006\u001cH/\u001d\u0013eK\u001a\fW\u000f\u001c;%i!I!\u0011\u0015\u0001\u0012\u0002\u0013\u0005!1M\u0001\u001aC\u0012\fWNU3QC&\u0014(+Z1eg\u0012\"WMZ1vYR$#\u0007")
public class AlignmentRecordRDDFunctions
extends ADAMSequenceDictionaryRDDAggregator<AlignmentRecord> {
    public final RDD<AlignmentRecord> org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd;

    public RDD<AlignmentRecord> filterByOverlappingRegion(ReferenceRegion query) {
        return this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.filter((Function1)new Serializable(this, query){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final ReferenceRegion query$1;

            public final boolean apply(AlignmentRecord rec) {
                return this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$overlapsQuery$1(rec, this.query$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
    }

    public boolean maybeSaveBam(SaveArgs args) {
        boolean bl;
        if (args.outputPath().endsWith(".sam")) {
            this.log().info("Saving data in SAM format");
            AlignmentRecordRDDFunctions qual$1 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
            String x$28 = args.outputPath();
            boolean x$29 = qual$1.adamSAMSave$default$2();
            qual$1.adamSAMSave(x$28, x$29);
            bl = true;
        } else if (args.outputPath().endsWith(".bam")) {
            this.log().info("Saving data in BAM format");
            ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamSAMSave(args.outputPath(), false);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean maybeSaveFastq(ADAMSaveAnyArgs args) {
        boolean bl;
        if (args.outputPath().endsWith(".fq") || args.outputPath().endsWith(".fastq") || args.outputPath().endsWith(".ifq")) {
            AlignmentRecordRDDFunctions qual$2 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
            String x$30 = args.outputPath();
            boolean x$31 = args.sortFastqOutput();
            Option<String> x$32 = qual$2.adamSaveAsFastq$default$2();
            ValidationStringency x$33 = qual$2.adamSaveAsFastq$default$4();
            Option<StorageLevel> x$34 = qual$2.adamSaveAsFastq$default$5();
            qual$2.adamSaveAsFastq(x$30, x$32, x$31, x$33, x$34);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean adamAlignedRecordSave(SaveArgs args) {
        if (this.maybeSaveBam(args)) return true;
        ADAMContext$.MODULE$.rddToADAMRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, Predef$.MODULE$.$conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).adamParquetSave(args);
        if (!true) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean adamSave(ADAMSaveAnyArgs args) {
        if (this.maybeSaveBam(args)) return true;
        if (this.maybeSaveFastq(args)) return true;
        ADAMContext$.MODULE$.rddToADAMRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, Predef$.MODULE$.$conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).adamParquetSave(args);
        if (!true) return false;
        return true;
    }

    public String adamSAMString() {
        Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamConvertToSAM();
        if (tuple2 != null) {
            RDD convertRecords = (RDD)tuple2._1();
            SAMFileHeader header2 = (SAMFileHeader)tuple2._2();
            if (convertRecords != null) {
                RDD rDD = convertRecords;
                if (header2 != null) {
                    Tuple2 tuple22;
                    SAMFileHeader sAMFileHeader = header2;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)rDD, (Object)sAMFileHeader);
                    RDD convertRecords2 = (RDD)tuple23._1();
                    SAMFileHeader header3 = (SAMFileHeader)tuple23._2();
                    int x$35 = 1;
                    boolean x$36 = true;
                    Ordering x$37 = convertRecords2.coalesce$default$3(x$35, x$36);
                    SAMRecordWritable[] records = (SAMRecordWritable[])convertRecords2.coalesce(x$35, x$36, x$37).collect();
                    SAMTextHeaderCodec samHeaderCodec = new SAMTextHeaderCodec();
                    samHeaderCodec.setValidationStringency(ValidationStringency.SILENT);
                    StringWriter samStringWriter = new StringWriter();
                    samHeaderCodec.encode((Writer)samStringWriter, header3);
                    SAMTextWriter samWriter = new SAMTextWriter((Writer)samStringWriter);
                    Predef$.MODULE$.refArrayOps((Object[])records).foreach((Function1)new Serializable(this, samWriter){
                        private final SAMTextWriter samWriter$1;

                        public final void apply(SAMRecordWritable record) {
                            this.samWriter$1.writeAlignment(record.get());
                        }
                        {
                            this.samWriter$1 = samWriter$1;
                        }
                    });
                    return samStringWriter.toString();
                }
            }
        }
        throw new MatchError(tuple2);
    }

    public void adamSAMSave(String filePath, boolean asSam) {
        Timers$.MODULE$.SAMSave().time((Function0)new Serializable(this, filePath, asSam){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final String filePath$1;
            public final boolean asSam$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2;
                block4: {
                    boolean bl;
                    block7: {
                        boolean bl2;
                        block10: {
                            block9: {
                                Configuration conf;
                                RDD withKey;
                                block8: {
                                    block6: {
                                        SAMFileHeader header2;
                                        block5: {
                                            Tuple2 tuple22;
                                            tuple2 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamConvertToSAM();
                                            if (tuple2 == null) break block4;
                                            RDD convertRecords = (RDD)tuple2._1();
                                            SAMFileHeader header3 = (SAMFileHeader)tuple2._2();
                                            if (convertRecords == null) break block4;
                                            RDD rDD = convertRecords;
                                            if (header3 == null) break block4;
                                            SAMFileHeader sAMFileHeader = header3;
                                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rDD, (Object)sAMFileHeader);
                                            RDD convertRecords2 = (RDD)tuple23._1();
                                            header2 = (SAMFileHeader)tuple23._2();
                                            withKey = convertRecords2.keyBy((Function1)new Serializable(this){

                                                public final LongWritable apply(SAMRecordWritable v) {
                                                    return new LongWritable((long)v.get().getAlignmentStart());
                                                }
                                            });
                                            Broadcast bcastHeader = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.context().broadcast((Object)header2, ClassTag$.MODULE$.apply(SAMFileHeader.class));
                                            long mp = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.mapPartitionsWithIndex((Function2)new Serializable(this, bcastHeader){
                                                private final /* synthetic */ $anonfun$adamSAMSave$1 $outer;
                                                private final Broadcast bcastHeader$1;

                                                public final Iterator<Object> apply(int idx, Iterator<AlignmentRecord> iter) {
                                                    this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer().log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting ", " header for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.asSam$1 ? "SAM" : "BAM", BoxesRunTime.boxToInteger((int)idx)})));
                                                    SAMFileHeader header2 = (SAMFileHeader)this.bcastHeader$1.value();
                                                    AlignmentRecordRDDFunctions alignmentRecordRDDFunctions = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer();
                                                    synchronized (alignmentRecordRDDFunctions) {
                                                        boolean bl;
                                                        block6: {
                                                            bl = this.$outer.asSam$1;
                                                            if (bl) {
                                                                ADAMSAMOutputFormat$.MODULE$.clearHeader();
                                                                ADAMSAMOutputFormat$.MODULE$.addHeader(header2);
                                                                this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer().log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set SAM header for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx)})));
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                if (bl) break block6;
                                                                ADAMBAMOutputFormat$.MODULE$.clearHeader();
                                                                ADAMBAMOutputFormat$.MODULE$.addHeader(header2);
                                                                this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer().log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set BAM header for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx)})));
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            }
                                                            return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                                                        }
                                                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                                                    }
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.bcastHeader$1 = bcastHeader$1;
                                                }
                                            }, this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).count();
                                            if (mp != 0L) {
                                                this.$outer.log().warn("Had more than 0 elements after map partitions call to set VCF header across cluster.");
                                            }
                                            if (!(bl = this.asSam$1)) break block5;
                                            ADAMSAMOutputFormat$.MODULE$.clearHeader();
                                            ADAMSAMOutputFormat$.MODULE$.addHeader(header2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block6;
                                        }
                                        if (bl) break block7;
                                        ADAMBAMOutputFormat$.MODULE$.clearHeader();
                                        ADAMBAMOutputFormat$.MODULE$.addHeader(header2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    conf = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.context().hadoopConfiguration();
                                    bl2 = this.asSam$1;
                                    if (!bl2) break block8;
                                    MetricsContext$.MODULE$.rddToInstrumentedPairRDD(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(this.filePath$1, LongWritable.class, SAMRecordWritable.class, InstrumentedADAMSAMOutputFormat.class, conf);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block9;
                                }
                                if (bl2) break block10;
                                MetricsContext$.MODULE$.rddToInstrumentedPairRDD(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(this.filePath$1, LongWritable.class, SAMRecordWritable.class, InstrumentedADAMBAMOutputFormat.class, conf);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ AlignmentRecordRDDFunctions org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.filePath$1 = filePath$1;
                this.asSam$1 = asSam$1;
            }
        });
    }

    public boolean adamSAMSave$default$2() {
        return true;
    }

    @Override
    public Set<SequenceRecord> getSequenceRecordsFromElement(AlignmentRecord elem) {
        return SequenceRecord$.MODULE$.fromADAMRecord(elem);
    }

    public RecordGroupDictionary adamGetReadGroupDictionary() {
        Seq rgNames = Predef$.MODULE$.refArrayOps((Object[])this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.flatMap((Function1)new Serializable(this){

            public final Iterable<RecordGroup> apply(AlignmentRecord x$3) {
                return Option$.MODULE$.option2Iterable(RecordGroup$.MODULE$.apply(x$3));
            }
        }, ClassTag$.MODULE$.apply(RecordGroup.class)).distinct().collect()).toSeq();
        return new RecordGroupDictionary((Seq<RecordGroup>)rgNames);
    }

    public Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> adamConvertToSAM() {
        return (Tuple2)Timers$.MODULE$.ConvertToSAM().time((Function0)new Serializable(this){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;

            public final Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> apply() {
                SequenceDictionary sd = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamGetSequenceDictionary();
                RecordGroupDictionary rgd = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamGetReadGroupDictionary();
                AlignmentRecordConverter adamRecordConverter = new AlignmentRecordConverter();
                SAMFileHeader header2 = adamRecordConverter.createSAMHeader(sd, rgd);
                Broadcast hdrBcast = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.context().broadcast((Object)SAMFileHeaderWritable$.MODULE$.apply(header2), ClassTag$.MODULE$.apply(SAMFileHeaderWritable.class));
                RDD convertedRDD = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.map((Function1)new Serializable(this, adamRecordConverter, hdrBcast){
                    private final AlignmentRecordConverter adamRecordConverter$1;
                    private final Broadcast hdrBcast$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final SAMRecordWritable apply(AlignmentRecord r) {
                        void var2_2;
                        SAMRecordWritable srw = new SAMRecordWritable();
                        srw.set(this.adamRecordConverter$1.convert(r, (SAMFileHeaderWritable)this.hdrBcast$1.value()));
                        return var2_2;
                    }
                    {
                        this.adamRecordConverter$1 = adamRecordConverter$1;
                        this.hdrBcast$1 = hdrBcast$1;
                    }
                }, ClassTag$.MODULE$.apply(SAMRecordWritable.class));
                return new Tuple2((Object)convertedRDD, (Object)header2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public RDD<Tuple2<String, Object>> adamCountKmers(int kmerLength) {
        return MetricsContext$.MODULE$.rddToInstrumentedPairRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.flatMap((Function1)new Serializable(this, kmerLength){
            private final int kmerLength$1;

            public final Iterator<Tuple2<String, Object>> apply(AlignmentRecord r) {
                return new StringOps(Predef$.MODULE$.augmentString(r.getSequence().toString())).sliding(this.kmerLength$1).map((Function1)new Serializable(this){

                    public final Tuple2<String, Object> apply(String k) {
                        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                });
            }
            {
                this.kmerLength$1 = kmerLength$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){

            public final long apply(long k1, long k2) {
                return this.apply$mcJJJ$sp(k1, k2);
            }

            public long apply$mcJJJ$sp(long k1, long k2) {
                return k1 + k2;
            }
        });
    }

    public RDD<AlignmentRecord> adamSortReadsByReferencePosition() {
        return (RDD)Timers$.MODULE$.SortReads().time((Function0)new Serializable(this){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;

            public final RDD<AlignmentRecord> apply() {
                this.$outer.log().info("Sorting reads by reference position");
                InstrumentedOrderedRDDFunctions qual$3 = MetricsContext$.MODULE$.rddToInstrumentedOrderedRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.keyBy((Function1)new Serializable(this){

                    public final ReferencePosition apply(AlignmentRecord r) {
                        return Predef$.MODULE$.Boolean2boolean(r.getReadMapped()) ? ReferencePosition$.MODULE$.apply(r) : ReferencePosition$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("ZZZ%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r.getReadName()})), 0L);
                    }
                }), (Ordering)ReferencePosition$.MODULE$.orderingForPositions(), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
                boolean x$38 = qual$3.sortByKey$default$1();
                int x$39 = qual$3.sortByKey$default$2();
                return qual$3.sortByKey(x$38, x$39).map((Function1)new Serializable(this){

                    public final AlignmentRecord apply(Tuple2<ReferencePosition, AlignmentRecord> p) {
                        return (AlignmentRecord)p._2();
                    }
                }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public RDD<AlignmentRecord> adamMarkDuplicates() {
        return (RDD)Timers$.MODULE$.MarkDuplicatesInDriver().time((Function0)new Serializable(this){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;

            public final RDD<AlignmentRecord> apply() {
                return MarkDuplicates$.MODULE$.apply(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public RDD<AlignmentRecord> adamBQSR(Broadcast<SnpTable> knownSnps, Option<String> observationDumpFile) {
        return (RDD)Timers$.MODULE$.BQSRInDriver().time((Function0)new Serializable(this, knownSnps, observationDumpFile){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final Broadcast knownSnps$1;
            private final Option observationDumpFile$1;

            public final RDD<AlignmentRecord> apply() {
                return BaseQualityRecalibration$.MODULE$.apply(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, (Broadcast<SnpTable>)this.knownSnps$1, (Option<String>)this.observationDumpFile$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.knownSnps$1 = knownSnps$1;
                this.observationDumpFile$1 = observationDumpFile$1;
            }
        });
    }

    public Option<String> adamBQSR$default$2() {
        return None$.MODULE$;
    }

    public RDD<AlignmentRecord> adamRealignIndels(ConsensusGenerator consensusModel, boolean isSorted, int maxIndelSize, int maxConsensusNumber, double lodThreshold, int maxTargetSize) {
        return (RDD)Timers$.MODULE$.RealignIndelsInDriver().time((Function0)new Serializable(this, consensusModel, isSorted, maxIndelSize, maxConsensusNumber, lodThreshold){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final ConsensusGenerator consensusModel$1;
            private final boolean isSorted$1;
            private final int maxIndelSize$1;
            private final int maxConsensusNumber$1;
            private final double lodThreshold$1;

            public final RDD<AlignmentRecord> apply() {
                return RealignIndels$.MODULE$.apply(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, this.consensusModel$1, this.isSorted$1, this.maxIndelSize$1, this.maxConsensusNumber$1, this.lodThreshold$1, RealignIndels$.MODULE$.apply$default$7());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consensusModel$1 = consensusModel$1;
                this.isSorted$1 = isSorted$1;
                this.maxIndelSize$1 = maxIndelSize$1;
                this.maxConsensusNumber$1 = maxConsensusNumber$1;
                this.lodThreshold$1 = lodThreshold$1;
            }
        });
    }

    public ConsensusGenerator adamRealignIndels$default$1() {
        return new ConsensusGeneratorFromReads();
    }

    public boolean adamRealignIndels$default$2() {
        return false;
    }

    public int adamRealignIndels$default$3() {
        return 500;
    }

    public int adamRealignIndels$default$4() {
        return 30;
    }

    public double adamRealignIndels$default$5() {
        return 5.0;
    }

    public int adamRealignIndels$default$6() {
        return 3000;
    }

    public Tuple2<FlagStatMetrics, FlagStatMetrics> adamFlagStat() {
        return FlagStat$.MODULE$.apply(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
    }

    public RDD<SingleReadBucket> adamSingleReadBuckets() {
        return SingleReadBucket$.MODULE$.apply(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
    }

    public RDD<Tuple2<String, Object>> adamCharacterizeTags() {
        return MetricsContext$.MODULE$.rddToInstrumentedPairRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.flatMap((Function1)new Serializable(this){

            public final Seq<Tuple2<String, Object>> apply(AlignmentRecord x$4) {
                return (Seq)RichAlignmentRecord$.MODULE$.apply(x$4).tags().map((Function1)new Serializable(this){

                    public final Tuple2<String, Object> apply(Attribute attr) {
                        return new Tuple2((Object)attr.tag(), (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){

            public final long apply(long x$5, long x$6) {
                return this.apply$mcJJJ$sp(x$5, x$6);
            }

            public long apply$mcJJJ$sp(long x$5, long x$6) {
                return x$5 + x$6;
            }
        });
    }

    public scala.collection.immutable.Map<Object, Object> adamCharacterizeTagValues(String tag) {
        return (scala.collection.immutable.Map)this.adamFilterRecordsWithTag(tag).flatMap((Function1)new Serializable(this, tag){
            public final String tag$1;

            public final Iterable<Attribute> apply(AlignmentRecord x$7) {
                return Option$.MODULE$.option2Iterable(RichAlignmentRecord$.MODULE$.apply(x$7).tags().find((Function1)new Serializable(this){
                    private final /* synthetic */ $anonfun$adamCharacterizeTagValues$1 $outer;

                    public final boolean apply(Attribute x$8) {
                        String string = x$8.tag();
                        String string2 = this.$outer.tag$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(Attribute.class)).map((Function1)new Serializable(this){

            public final scala.collection.immutable.Map<Object, Object> apply(Attribute attr) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(attr.value()), (Object)BoxesRunTime.boxToLong((long)1L))}));
            }
        }, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class)).reduce((Function2)new Serializable(this){

            public final scala.collection.immutable.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> map1, scala.collection.immutable.Map<Object, Object> map2) {
                return MapTools$.MODULE$.add(map1, map2, Numeric.LongIsIntegral$.MODULE$);
            }
        });
    }

    public RDD<AlignmentRecord> adamFilterRecordsWithTag(String tagName) {
        Predef$.MODULE$.assert(tagName.length() == 2, (Function0)new Serializable(this, tagName){
            private final String tagName$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("withAttribute takes a tagName argument of length 2; tagName=\"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tagName$1}));
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
        return this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.filter((Function1)new Serializable(this, tagName){
            public final String tagName$1;

            public final boolean apply(AlignmentRecord x$9) {
                return RichAlignmentRecord$.MODULE$.apply(x$9).tags().exists((Function1)new Serializable(this){
                    private final /* synthetic */ $anonfun$adamFilterRecordsWithTag$2 $outer;

                    public final boolean apply(Attribute x$10) {
                        String string = x$10.tag();
                        String string2 = this.$outer.tagName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
    }

    public void adamSaveAsPairedFastq(String fileName1, String fileName2, ValidationStringency validationStringency, Option<StorageLevel> persistLevel) {
        this.maybePersist$1(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, persistLevel);
        long numRecords = this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.count();
        RDD readsByID = this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.groupBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord record) {
                return AlignmentRecordConverter$.MODULE$.readNameHasPairedSuffix(record) ? (String)new StringOps(Predef$.MODULE$.augmentString(record.getReadName().toString())).dropRight(2) : record.getReadName().toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        ValidationStringency validationStringency2 = validationStringency;
        ValidationStringency validationStringency3 = ValidationStringency.STRICT;
        if (!(validationStringency2 != null ? !validationStringency2.equals(validationStringency3) : validationStringency3 != null)) {
            RDD readIDsWithCounts = MetricsContext$.MODULE$.rddToInstrumentedPairRDD(readsByID, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)new Serializable(this){

                public final int apply(Iterable<AlignmentRecord> x$13) {
                    return x$13.size();
                }
            });
            RDD unpairedReadIDsWithCounts = readIDsWithCounts.filter((Function1)new Serializable(this){

                public final boolean apply(Tuple2<String, Object> x$14) {
                    return x$14._2$mcI$sp() != 2;
                }
            });
            this.maybePersist$1(unpairedReadIDsWithCounts, persistLevel);
            long numUnpairedReadIDsWithCounts = unpairedReadIDsWithCounts.count();
            if (numUnpairedReadIDsWithCounts != 0L) {
                Map readNameOccurrencesMap = unpairedReadIDsWithCounts.map((Function1)new Serializable(this){

                    public final int apply(Tuple2<String, Object> x$15) {
                        return x$15._2$mcI$sp();
                    }
                }, ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
                throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Found %d read names that don't occur exactly twice:\n%s\n\nSamples:\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numUnpairedReadIDsWithCounts), ((TraversableOnce)readNameOccurrencesMap.map((Function1)new Serializable(this){

                    public final String apply(Tuple2<Object, Object> p) {
                        return new StringOps(Predef$.MODULE$.augmentString("%dx:\t%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)p._1$mcI$sp()), BoxesRunTime.boxToLong((long)p._2$mcJ$sp())}));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", ""), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])unpairedReadIDsWithCounts.take(100)).map((Function1)new Serializable(this){

                    public final String apply(Tuple2<String, Object> x$16) {
                        return (String)x$16._1();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\t", "\n\t", "")})));
            }
        }
        RDD pairedRecords = readsByID.filter((Function1)new Serializable(this){

            public final boolean apply(Tuple2<String, Iterable<AlignmentRecord>> x$17) {
                return ((TraversableOnce)x$17._2()).size() == 2;
            }
        }).map((Function1)new Serializable(this){

            public final Iterable<AlignmentRecord> apply(Tuple2<String, Iterable<AlignmentRecord>> x$18) {
                return (Iterable)x$18._2();
            }
        }, ClassTag$.MODULE$.apply(Iterable.class)).flatMap((Function1)new Serializable(this){

            public final Iterable<AlignmentRecord> apply(Iterable<AlignmentRecord> x) {
                return x;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        this.maybePersist$1(pairedRecords, persistLevel);
        long numPairedRecords = pairedRecords.count();
        this.maybeUnpersist$1(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.unpersist(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.unpersist$default$1()), persistLevel);
        RDD firstInPairRecords = pairedRecords.filter((Function1)new Serializable(this){

            public final boolean apply(AlignmentRecord x$19) {
                return Predef$.MODULE$.Boolean2boolean(x$19.getFirstOfPair());
            }
        });
        this.maybePersist$1(firstInPairRecords, persistLevel);
        long numFirstInPairRecords = firstInPairRecords.count();
        RDD secondInPairRecords = pairedRecords.filter((Function1)new Serializable(this){

            public final boolean apply(AlignmentRecord x$20) {
                return Predef$.MODULE$.Boolean2boolean(x$20.getSecondOfPair());
            }
        });
        this.maybePersist$1(secondInPairRecords, persistLevel);
        long numSecondInPairRecords = secondInPairRecords.count();
        this.maybeUnpersist$1(pairedRecords, persistLevel);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("%d/%d records are properly paired: %d firsts, %d seconds")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numPairedRecords), BoxesRunTime.boxToLong((long)numRecords), BoxesRunTime.boxToLong((long)numFirstInPairRecords), BoxesRunTime.boxToLong((long)numSecondInPairRecords)})));
        ValidationStringency validationStringency4 = validationStringency;
        ValidationStringency validationStringency5 = ValidationStringency.STRICT;
        if (!(validationStringency4 != null ? !validationStringency4.equals(validationStringency5) : validationStringency5 != null)) {
            firstInPairRecords.foreach((Function1)new Serializable(this){

                public final void apply(AlignmentRecord read) {
                    if (Predef$.MODULE$.Boolean2boolean(read.getSecondOfPair())) {
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Read %s found with first- and second-of-pair set")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{read.getReadName()})));
                    }
                }
            });
            secondInPairRecords.foreach((Function1)new Serializable(this){

                public final void apply(AlignmentRecord read) {
                    if (Predef$.MODULE$.Boolean2boolean(read.getFirstOfPair())) {
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Read %s found with first- and second-of-pair set")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{read.getReadName()})));
                    }
                }
            });
        }
        Predef$.MODULE$.assert(numFirstInPairRecords == numSecondInPairRecords, (Function0)new Serializable(this, numFirstInPairRecords, numSecondInPairRecords){
            private final long numFirstInPairRecords$1;
            private final long numSecondInPairRecords$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Different numbers of first- and second-reads: %d vs. %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numFirstInPairRecords$1), BoxesRunTime.boxToLong((long)this.numSecondInPairRecords$1)}));
            }
            {
                this.numFirstInPairRecords$1 = numFirstInPairRecords$1;
                this.numSecondInPairRecords$1 = numSecondInPairRecords$1;
            }
        });
        AlignmentRecordConverter arc = new AlignmentRecordConverter();
        firstInPairRecords.sortBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$21) {
                return x$21.getReadName().toString();
            }
        }, firstInPairRecords.sortBy$default$2(), firstInPairRecords.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this, arc){
            private final AlignmentRecordConverter arc$1;

            public final String apply(AlignmentRecord record) {
                return this.arc$1.convertToFastq(record, true);
            }
            {
                this.arc$1 = arc$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName1);
        secondInPairRecords.sortBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$22) {
                return x$22.getReadName().toString();
            }
        }, secondInPairRecords.sortBy$default$2(), secondInPairRecords.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this, arc){
            private final AlignmentRecordConverter arc$1;

            public final String apply(AlignmentRecord record) {
                return this.arc$1.convertToFastq(record, true);
            }
            {
                this.arc$1 = arc$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName2);
        this.maybeUnpersist$1(firstInPairRecords, persistLevel);
        this.maybeUnpersist$1(secondInPairRecords, persistLevel);
    }

    public ValidationStringency adamSaveAsPairedFastq$default$3() {
        return ValidationStringency.LENIENT;
    }

    public Option<StorageLevel> adamSaveAsPairedFastq$default$4() {
        return None$.MODULE$;
    }

    public void adamSaveAsFastq(String fileName, Option<String> fileName2Opt, boolean sort, ValidationStringency validationStringency, Option<StorageLevel> persistLevel) {
        this.log().info("Saving data in FASTQ format.");
        Option<String> option = fileName2Opt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String fileName2 = (String)some.x();
            this.adamSaveAsPairedFastq(fileName, fileName2, validationStringency, persistLevel);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AlignmentRecordConverter arc = new AlignmentRecordConverter();
            RDD outputRdd = sort || fileName2Opt.isDefined() ? this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.sortBy((Function1)new Serializable(this){

                public final String apply(AlignmentRecord x$23) {
                    return x$23.getReadName().toString();
                }
            }, this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.sortBy$default$2(), this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)) : this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd;
            outputRdd.map((Function1)new Serializable(this, arc){
                private final AlignmentRecordConverter arc$2;

                public final String apply(AlignmentRecord record) {
                    return this.arc$2.convertToFastq(record, this.arc$2.convertToFastq$default$2());
                }
                {
                    this.arc$2 = arc$2;
                }
            }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<String> adamSaveAsFastq$default$2() {
        return None$.MODULE$;
    }

    public boolean adamSaveAsFastq$default$3() {
        return false;
    }

    public ValidationStringency adamSaveAsFastq$default$4() {
        return ValidationStringency.LENIENT;
    }

    public Option<StorageLevel> adamSaveAsFastq$default$5() {
        return None$.MODULE$;
    }

    public RDD<AlignmentRecord> adamRePairReads(RDD<AlignmentRecord> secondPairRdd, ValidationStringency validationStringency) {
        RDD firstPairRdd = this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.cache();
        secondPairRdd.cache();
        RDD firstRDDKeyedByReadName = firstPairRdd.keyBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$24) {
                return (String)new StringOps(Predef$.MODULE$.augmentString(x$24.getReadName().toString())).dropRight(2);
            }
        });
        RDD secondRDDKeyedByReadName = secondPairRdd.keyBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$25) {
                return (String)new StringOps(Predef$.MODULE$.augmentString(x$25.getReadName().toString())).dropRight(2);
            }
        });
        ValidationStringency validationStringency2 = validationStringency;
        ValidationStringency validationStringency3 = ValidationStringency.STRICT;
        RDD joinedRDD = !(validationStringency2 != null ? !validationStringency2.equals(validationStringency3) : validationStringency3 != null) ? MetricsContext$.MODULE$.rddToInstrumentedPairRDD(firstRDDKeyedByReadName, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), (Ordering)Ordering.String$.MODULE$).cogroup(secondRDDKeyedByReadName).map((Function1)new Serializable(this){

            public final Tuple2<String, Tuple2<AlignmentRecord, AlignmentRecord>> apply(Tuple2<String, Tuple2<Iterable<AlignmentRecord>, Iterable<AlignmentRecord>>> x0$1) {
                Tuple2<String, Tuple2<Iterable<AlignmentRecord>, Iterable<AlignmentRecord>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String readName = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Iterable firstReads = (Iterable)tuple22._1();
                        Iterable secondReads = (Iterable)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)firstReads.toList(), (Object)secondReads.toList());
                        if (tuple23 != null) {
                            List list = (List)tuple23._1();
                            List list2 = (List)tuple23._2();
                            if (list instanceof .colon.colon) {
                                .colon.colon colon2 = (.colon.colon)list;
                                AlignmentRecord firstRead = (AlignmentRecord)colon2.head();
                                List list3 = colon2.tl$1();
                                if (Nil$.MODULE$.equals(list3) && list2 instanceof .colon.colon) {
                                    .colon.colon colon3 = (.colon.colon)list2;
                                    AlignmentRecord secondRead = (AlignmentRecord)colon3.head();
                                    List list4 = colon3.tl$1();
                                    if (Nil$.MODULE$.equals(list4)) {
                                        Tuple2 tuple24;
                                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)readName, (Object)new Tuple2((Object)firstRead, (Object)secondRead));
                                        return tuple25;
                                    }
                                }
                            }
                        }
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Expected %d first reads and %d second reads for name %s; expected exactly one of each:\n%s\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstReads.size()), BoxesRunTime.boxToInteger((int)secondReads.size()), readName, ((TraversableOnce)firstReads.map((Function1)new Serializable(this){

                            public final String apply(AlignmentRecord x$26) {
                                return x$26.getReadName().toString();
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", ""), ((TraversableOnce)secondReads.map((Function1)new Serializable(this){

                            public final String apply(AlignmentRecord x$27) {
                                return x$27.getReadName().toString();
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", "")})));
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)) : MetricsContext$.MODULE$.rddToInstrumentedPairRDD(firstRDDKeyedByReadName, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), (Ordering)Ordering.String$.MODULE$).join(secondRDDKeyedByReadName);
        RDD finalRdd = joinedRDD.flatMap((Function1)new Serializable(this){

            public final Seq<AlignmentRecord> apply(Tuple2<String, Tuple2<AlignmentRecord, AlignmentRecord>> kv) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{AlignmentRecord.newBuilder((AlignmentRecord)((AlignmentRecord)((Tuple2)kv._2())._1())).setReadPaired(Predef$.MODULE$.boolean2Boolean(true)).setProperPair(Predef$.MODULE$.boolean2Boolean(true)).setFirstOfPair(Predef$.MODULE$.boolean2Boolean(true)).setSecondOfPair(Predef$.MODULE$.boolean2Boolean(false)).build(), AlignmentRecord.newBuilder((AlignmentRecord)((AlignmentRecord)((Tuple2)kv._2())._2())).setReadPaired(Predef$.MODULE$.boolean2Boolean(true)).setProperPair(Predef$.MODULE$.boolean2Boolean(true)).setFirstOfPair(Predef$.MODULE$.boolean2Boolean(false)).setSecondOfPair(Predef$.MODULE$.boolean2Boolean(true)).build()}));
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        firstPairRdd.unpersist(firstPairRdd.unpersist$default$1());
        secondPairRdd.unpersist(secondPairRdd.unpersist$default$1());
        return finalRdd;
    }

    public ValidationStringency adamRePairReads$default$2() {
        return ValidationStringency.LENIENT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$overlapsQuery$1(AlignmentRecord rec, ReferenceRegion query$1) {
        if (!Predef$.MODULE$.Boolean2boolean(rec.getReadMapped())) return false;
        String string = rec.getContig().getContigName().toString();
        String string2 = query$1.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (Predef$.MODULE$.Long2long(rec.getStart()) >= query$1.end()) return false;
        if (Predef$.MODULE$.Long2long(rec.getEnd()) <= query$1.start()) return false;
        return true;
    }

    private final void maybePersist$1(RDD r, Option persistLevel$1) {
        persistLevel$1.foreach((Function1)new Serializable(this, r){
            private final RDD r$1;

            public final RDD<T> apply(StorageLevel x$11) {
                return this.r$1.persist(x$11);
            }
            {
                this.r$1 = r$1;
            }
        });
    }

    private final void maybeUnpersist$1(RDD r, Option persistLevel$1) {
        persistLevel$1.foreach((Function1)new Serializable(this, r){
            private final RDD r$2;

            public final RDD<T> apply(StorageLevel x$12) {
                return this.r$2.unpersist(this.r$2.unpersist$default$1());
            }
            {
                this.r$2 = r$2;
            }
        });
    }

    public AlignmentRecordRDDFunctions(RDD<AlignmentRecord> rdd) {
        this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd = rdd;
        super(rdd);
    }
}

