/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.variation;

import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.VariantContextConverter;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.models.VariantContext$;
import org.bdgenomics.adam.rdd.ADAMSequenceDictionaryRDDAggregator;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat$;
import org.bdgenomics.adam.rich.RichVariant;
import org.bdgenomics.adam.rich.RichVariant$;
import org.bdgenomics.formats.avro.DatabaseVariantAnnotation;
import org.bdgenomics.formats.avro.Genotype;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u00015\u0011!DV1sS\u0006tGoQ8oi\u0016DHO\u0015#E\rVt7\r^5p]NT!a\u0001\u0003\u0002\u0013Y\f'/[1uS>t'BA\u0003\u0007\u0003\r\u0011H\r\u001a\u0006\u0003\u000f!\tA!\u00193b[*\u0011\u0011BC\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q\u0001\u0004E\u0002\u0010!Ii\u0011\u0001B\u0005\u0003#\u0011\u00111%\u0011#B\u001bN+\u0017/^3oG\u0016$\u0015n\u0019;j_:\f'/\u001f*E\t\u0006;wM]3hCR|'\u000f\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u00051Qn\u001c3fYNL!a\u0006\u000b\u0003\u001dY\u000b'/[1oi\u000e{g\u000e^3yiB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;)\ta!\u00199bG\",\u0017BA\u0010\u001b\u0005\u001daunZ4j]\u001eD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006I!\t\t\u0004E\u0011\u0012R\"A\u0012\u000b\u0005\u0015Q\u0012BA\u0013$\u0005\r\u0011F\t\u0012\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%Z\u0003C\u0001\u0016\u0001\u001b\u0005\u0011\u0001\"B\u0003'\u0001\u0004\t\u0003\"B\u0017\u0001\t\u0003q\u0013!H4fiN+\u0017/^3oG\u0016\u0014VmY8sIN4%o\\7FY\u0016lWM\u001c;\u0015\u0005=R\u0004c\u0001\u00196o5\t\u0011G\u0003\u00023g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003Q\nQa]2bY\u0006L!AN\u0019\u0003\u0007M+G\u000f\u0005\u0002\u0014q%\u0011\u0011\b\u0006\u0002\u000f'\u0016\fX/\u001a8dKJ+7m\u001c:e\u0011\u0015YD\u00061\u0001\u0013\u0003\u0011)G.Z7\t\u000bu\u0002A\u0011\u0001 \u0002;)|\u0017N\u001c#bi\u0006\u0014\u0017m]3WCJL\u0017M\u001c;B]:|G/\u0019;j_:$\"!I \t\u000b\u0001c\u0004\u0019A!\u0002\u0007\u0005tg\u000eE\u0002#I\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t\u00054(o\u001c\u0006\u0003\u000f\"\tqAZ8s[\u0006$8/\u0003\u0002J\t\nIB)\u0019;bE\u0006\u001cXMV1sS\u0006tG/\u00118o_R\fG/[8o\u0011\u0015Y\u0005\u0001\"\u0001M\u0003E9W\r^\"bY2\u001cX\r^*b[BdWm\u001d\u000b\u0002\u001bB\u0019aJV-\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*\r\u0003\u0019a$o\\8u}%\tA'\u0003\u0002Vg\u00059\u0001/Y2lC\u001e,\u0017BA,Y\u0005\u0011a\u0015n\u001d;\u000b\u0005U\u001b\u0004C\u0001._\u001d\tYF,D\u00014\u0013\ti6'\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/4\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003%\u0019\u0018M^3BgZ\u001bg\rF\u0003\"I\u001at7\u000fC\u0003fC\u0002\u0007\u0011,\u0001\u0005gS2,\u0007+\u0019;i\u0011\u001d9\u0017\r%AA\u0002!\fA\u0001Z5diB\u00191,[6\n\u0005)\u001c$AB(qi&|g\u000e\u0005\u0002\u0014Y&\u0011Q\u000e\u0006\u0002\u0013'\u0016\fX/\u001a8dK\u0012K7\r^5p]\u0006\u0014\u0018\u0010C\u0004pCB\u0005\t\u0019\u00019\u0002\u0015M|'\u000f^(o'\u00064X\r\u0005\u0002\\c&\u0011!o\r\u0002\b\u0005>|G.Z1o\u0011\u001d!\u0018\r%AA\u0002U\f!bY8bY\u0016\u001c8-\u001a+p!\rY\u0016N\u001e\t\u00037^L!\u0001_\u001a\u0003\u0007%sG\u000fC\u0004{\u0001E\u0005I\u0011A>\u0002'M\fg/Z!t-\u000e4G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003qT#\u0001[?,\u0003y\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011!C;oG\",7m[3e\u0015\r\t9aM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0006\u0003\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\u0001AI\u0001\n\u0003\t\t\"A\ntCZ,\u0017i\u001d,dM\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0014)\u0012\u0001/ \u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u00033\t1c]1wK\u0006\u001bhk\u00194%I\u00164\u0017-\u001e7uIQ*\"!a\u0007+\u0005Ul\b")
public class VariantContextRDDFunctions
extends ADAMSequenceDictionaryRDDAggregator<VariantContext>
implements Logging {
    private final RDD<VariantContext> rdd;

    @Override
    public Set<SequenceRecord> getSequenceRecordsFromElement(VariantContext elem) {
        return ((TraversableOnce)elem.genotypes().map((Function1)new Serializable(this){

            public final SequenceRecord apply(Genotype gt) {
                return SequenceRecord$.MODULE$.fromSpecificRecord((IndexedRecord)gt.getVariant());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public RDD<VariantContext> joinDatabaseVariantAnnotation(RDD<DatabaseVariantAnnotation> ann) {
        RDD x$5 = this.rdd.keyBy((Function1)new Serializable(this){

            public final RichVariant apply(VariantContext x$1) {
                return x$1.variant();
            }
        });
        ClassTag x$6 = ClassTag$.MODULE$.apply(RichVariant.class);
        ClassTag x$7 = ClassTag$.MODULE$.apply(VariantContext.class);
        SparkContext$.MODULE$.rddToPairRDDFunctions$default$4(x$5);
        Object x$8 = null;
        RDD x$9 = SparkContext$.MODULE$.rddToPairRDDFunctions(x$5, x$6, x$7, null).leftOuterJoin(ann.keyBy((Function1)new Serializable(this){

            public final RichVariant apply(DatabaseVariantAnnotation x$2) {
                return RichVariant$.MODULE$.variantToRichVariant(x$2.getVariant());
            }
        }));
        ClassTag x$10 = ClassTag$.MODULE$.apply(RichVariant.class);
        ClassTag x$11 = ClassTag$.MODULE$.apply(Tuple2.class);
        SparkContext$.MODULE$.rddToPairRDDFunctions$default$4(x$9);
        Object x$12 = null;
        return SparkContext$.MODULE$.rddToPairRDDFunctions(x$9, x$10, x$11, null).values().map((Function1)new Serializable(this){

            public final VariantContext apply(Tuple2<VariantContext, Option<DatabaseVariantAnnotation>> x0$1) {
                Tuple2<VariantContext, Option<DatabaseVariantAnnotation>> tuple2 = x0$1;
                if (tuple2 != null) {
                    VariantContext v = (VariantContext)tuple2._1();
                    Option a = (Option)tuple2._2();
                    if (v != null) {
                        VariantContext variantContext = v;
                        VariantContext variantContext2 = VariantContext$.MODULE$.apply(RichVariant$.MODULE$.richVariantToVariant(variantContext.variant()), variantContext.genotypes(), (Option<DatabaseVariantAnnotation>)a);
                        return variantContext2;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VariantContext.class));
    }

    public List<String> getCallsetSamples() {
        return Predef$.MODULE$.refArrayOps((Object[])this.rdd.flatMap((Function1)new Serializable(this){

            public final Seq<String> apply(VariantContext c) {
                return (Seq)((TraversableOnce)c.genotypes().map((Function1)new Serializable(this){

                    public final String apply(Genotype x$3) {
                        return x$3.getSampleId();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq().distinct();
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().map((Function1)new Serializable(this){

            public final String apply(String x$4) {
                return x$4.toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect()).toList();
    }

    public RDD<VariantContext> saveAsVcf(String filePath, Option<SequenceDictionary> dict, boolean sortOnSave, Option<Object> coalesceTo) {
        RDD rDD;
        VCFFormat vcfFormat;
        VCFFormat vCFFormat = vcfFormat = VCFFormat.inferFromFilePath((String)filePath);
        VCFFormat vCFFormat2 = VCFFormat.VCF;
        Predef$.MODULE$.assert(!(vCFFormat != null ? !vCFFormat.equals(vCFFormat2) : vCFFormat2 != null), (Function0)new Serializable(this){

            public final String apply() {
                return "BCF not yet supported";
            }
        });
        this.rdd.cache();
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Writing %s file to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vcfFormat, filePath})));
        List<String> header2 = this.getCallsetSamples();
        Broadcast bcastHeader = this.rdd.context().broadcast(header2, ClassTag$.MODULE$.apply(List.class));
        long mp = this.rdd.mapPartitionsWithIndex((Function2)new Serializable(this, bcastHeader){
            private final /* synthetic */ VariantContextRDDFunctions $outer;
            private final Broadcast bcastHeader$1;

            public final Iterator<Object> apply(int idx, Iterator<VariantContext> iter) {
                this.$outer.log().warn(new StringBuilder().append((Object)"Setting header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                VariantContextRDDFunctions variantContextRDDFunctions = this.$outer;
                synchronized (variantContextRDDFunctions) {
                    ADAMVCFOutputFormat$.MODULE$.setHeader((Seq<String>)((Seq)this.bcastHeader$1.value()));
                    this.$outer.log().warn(new StringBuilder().append((Object)"Set VCF header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bcastHeader$1 = bcastHeader$1;
            }
        }, this.rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).count();
        if (mp != 0L) {
            this.log().warn("Had more than 0 elements after map partitions call to set VCF header across cluster.");
        }
        VariantContextConverter converter = new VariantContextConverter(dict);
        RDD gatkVCs = this.rdd.map((Function1)new Serializable(this, converter){
            private final VariantContextConverter converter$1;

            /*
             * WARNING - void declaration
             */
            public final VariantContextWritable apply(VariantContext v) {
                void var2_2;
                VariantContextWritable vcw = new VariantContextWritable();
                vcw.set(this.converter$1.convert(v));
                return var2_2;
            }
            {
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContextWritable.class));
        RDD coalescedVCs = (RDD)coalesceTo.fold((Function0)new Serializable(this, gatkVCs){
            private final RDD gatkVCs$1;

            public final RDD<VariantContextWritable> apply() {
                return this.gatkVCs$1;
            }
            {
                this.gatkVCs$1 = gatkVCs$1;
            }
        }, (Function1)new Serializable(this, gatkVCs){
            private final RDD gatkVCs$1;

            public final RDD<VariantContextWritable> apply(int p) {
                int x$13 = p;
                Ordering x$14 = this.gatkVCs$1.repartition$default$2(x$13);
                return this.gatkVCs$1.repartition(x$13, x$14);
            }
            {
                this.gatkVCs$1 = gatkVCs$1;
            }
        });
        if (sortOnSave) {
            OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(coalescedVCs.keyBy((Function1)new Serializable(this){

                public final ReferencePosition apply(VariantContextWritable v) {
                    return ReferencePosition$.MODULE$.apply(v.get().getChr(), v.get().getStart());
                }
            }), (Ordering)ReferencePosition$.MODULE$.orderingForPositions(), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(VariantContextWritable.class));
            boolean x$15 = qual$1.sortByKey$default$1();
            int x$16 = qual$1.sortByKey$default$2();
            rDD = qual$1.sortByKey(x$15, x$16).map((Function1)new Serializable(this){

                public final Tuple2<LongWritable, VariantContextWritable> apply(Tuple2<ReferencePosition, VariantContextWritable> kv) {
                    return new Tuple2((Object)new LongWritable(((ReferencePosition)kv._1()).pos()), kv._2());
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            rDD = coalescedVCs.keyBy((Function1)new Serializable(this){

                public final LongWritable apply(VariantContextWritable v) {
                    return new LongWritable((long)v.get().getStart());
                }
            });
        }
        RDD withKey = rDD;
        Configuration conf = this.rdd.context().hadoopConfiguration();
        conf.set("hadoopbam.vcf.output-format", vcfFormat.toString());
        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(VariantContextWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, VariantContextWritable.class, ADAMVCFOutputFormat.class, conf);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Write %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)gatkVCs.count())})));
        return this.rdd.unpersist(this.rdd.unpersist$default$1());
    }

    public Option<SequenceDictionary> saveAsVcf$default$2() {
        return None$.MODULE$;
    }

    public boolean saveAsVcf$default$3() {
        return false;
    }

    public Option<Object> saveAsVcf$default$4() {
        return None$.MODULE$;
    }

    public VariantContextRDDFunctions(RDD<VariantContext> rdd) {
        this.rdd = rdd;
        super(rdd);
    }
}

