/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.util.ReferenceFile;
import org.bdgenomics.adam.util.TwoBitFile$;
import org.bdgenomics.adam.util.TwoBitRecord;
import org.bdgenomics.adam.util.TwoBitRecord$;
import org.bdgenomics.utils.io.ByteAccess;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]u!B\u0001\u0003\u0011\u0003Y\u0011A\u0003+x_\nKGOR5mK*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u000b)^|')\u001b;GS2,7cA\u0007\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"!E\f\n\u0005a\u0011\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000e\u000e\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001diRB1A\u0005\u0002y\tA\"T!H\u0013\u000e{f*V'C\u000bJ+\u0012a\b\t\u0003#\u0001J!!\t\n\u0003\u0007%sG\u000f\u0003\u0004$\u001b\u0001\u0006IaH\u0001\u000e\u001b\u0006;\u0015jQ0O+6\u0013UI\u0015\u0011\t\u000f\u0015j!\u0019!C\u0001=\u0005q!)Q*F'~\u0003VIU0C3R+\u0005BB\u0014\u000eA\u0003%q$A\bC\u0003N+5k\u0018)F%~\u0013\u0015\fV#!\u0011\u001dISB1A\u0005\u0002y\t\u0011BQ-U\u000b~\u001b\u0016JW#\t\r-j\u0001\u0015!\u0003 \u0003)\u0011\u0015\fV#`'&SV\t\t\u0005\b[5\u0011\r\u0011\"\u0001/\u0003\u0011i\u0015iU&\u0016\u0003=\u0002\"!\u0005\u0019\n\u0005E\u0012\"\u0001\u0002\"zi\u0016DaaM\u0007!\u0002\u0013y\u0013!B'B'.\u0003\u0003bB\u001b\u000e\u0005\u0004%\tAH\u0001\u000f-\u0016\u00136+S(O?>3eiU#U\u0011\u00199T\u0002)A\u0005?\u0005ya+\u0012*T\u0013>sul\u0014$G'\u0016#\u0006\u0005C\u0004:\u001b\t\u0007I\u0011\u0001\u0010\u0002+M+\u0015+V#O\u0007\u0016{6iT+O)~{eIR*F)\"11(\u0004Q\u0001\n}\tacU#R+\u0016s5)R0D\u001fVsEkX(G\rN+E\u000b\t\u0005\b{5\u0011\r\u0011\"\u0001\u001f\u0003YAU)\u0011#F%~\u0013ViU#S-\u0016#ul\u0014$G'\u0016#\u0006BB \u000eA\u0003%q$A\fI\u000b\u0006#UIU0S\u000bN+%KV#E?>3eiU#UA!9\u0011)\u0004b\u0001\n\u0003q\u0012!\u0005$J\u0019\u0016{\u0016J\u0014#F1~{eIR*F)\"11)\u0004Q\u0001\n}\t!CR%M\u000b~Ke\nR#Y?>3eiU#UA!9Q)\u0004b\u0001\n\u0003q\u0012A\u0004(B\u001b\u0016{6+\u0013.F?NK%,\u0012\u0005\u0007\u000f6\u0001\u000b\u0011B\u0010\u0002\u001f9\u000bU*R0T\u0013j+ulU%[\u000b\u0002Bq!S\u0007C\u0002\u0013\u0005a$A\u0006P\r\u001a\u001bV\tV0T\u0013j+\u0005BB&\u000eA\u0003%q$\u0001\u0007P\r\u001a\u001bV\tV0T\u0013j+\u0005\u0005C\u0004N\u001b\t\u0007I\u0011\u0001\u0010\u0002\u0011%sEkX*J5\u0016CaaT\u0007!\u0002\u0013y\u0012!C%O)~\u001b\u0016JW#!\u0011\u001d\tVB1A\u0005\u0002y\tQ\u0002\u0012(B?NK%,R0T\u0013j+\u0005BB*\u000eA\u0003%q$\u0001\bE\u001d\u0006{6+\u0013.F?NK%,\u0012\u0011\t\u000fUk!\u0019!C\u0001=\u0005\u0001\"\tT(D\u0017~\u001bu*\u0016(U?NK%,\u0012\u0005\u0007/6\u0001\u000b\u0011B\u0010\u0002#\tcujQ&`\u0007>+f\nV0T\u0013j+\u0005\u0005C\u0004Z\u001b\t\u0007I\u0011\u0001\u0010\u0002\u001dA+%k\u0018\"M\u001f\u000e[ulU%[\u000b\"11,\u0004Q\u0001\n}\tq\u0002U#S?\ncujQ&`'&SV\t\t\u0005\b;6\u0011\r\u0011\"\u0001\u001f\u0003a\u0019V)U0S\u000b\u000e{%\u000bR0S\u000bN+%KV#E?NK%,\u0012\u0005\u0007?6\u0001\u000b\u0011B\u0010\u00023M+\u0015k\u0018*F\u0007>\u0013Fi\u0018*F'\u0016\u0013f+\u0012#`'&SV\t\t\u0005\bC6\t\t\u0011\"\u0003c\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\t1\fgn\u001a\u0006\u0002Q\u0006!!.\u0019<b\u0013\tQWM\u0001\u0004PE*,7\r\u001e\u0004\u0005\u001d\t\u0001AnE\u0002l!5\u0004\"\u0001\u00048\n\u0005=\u0014!!\u0004*fM\u0016\u0014XM\\2f\r&dW\r\u0003\u0005rW\n\u0005\t\u0015!\u0003s\u0003)\u0011\u0017\u0010^3BG\u000e,7o\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\f!![8\u000b\u0005]4\u0011!B;uS2\u001c\u0018BA=u\u0005)\u0011\u0015\u0010^3BG\u000e,7o\u001d\u0005\u00065-$\ta\u001f\u000b\u0003yv\u0004\"\u0001D6\t\u000bET\b\u0019\u0001:\t\u0011}\\'\u0019!C\u0001\u0003\u0003\tQAY=uKN,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003h\u0003\rq\u0017n\\\u0005\u0005\u0003\u001b\t9A\u0001\u0006CsR,')\u001e4gKJD\u0001\"!\u0005lA\u0003%\u00111A\u0001\u0007Ef$Xm\u001d\u0011\t\u0011\u0005U1N1A\u0005\u0002y\taA\\;n'\u0016\f\bbBA\rW\u0002\u0006IaH\u0001\b]Vl7+Z9!\u0011!\tib\u001ba\u0001\n\u0003q\u0012\u0001E5oI\u0016D(+Z2pe\u0012\u001cF/\u0019:u\u0011%\t\tc\u001ba\u0001\n\u0003\t\u0019#\u0001\u000bj]\u0012,\u0007PU3d_J$7\u000b^1si~#S-\u001d\u000b\u0005\u0003K\tY\u0003E\u0002\u0012\u0003OI1!!\u000b\u0013\u0005\u0011)f.\u001b;\t\u0013\u00055\u0012qDA\u0001\u0002\u0004y\u0012a\u0001=%c!9\u0011\u0011G6!B\u0013y\u0012!E5oI\u0016D(+Z2pe\u0012\u001cF/\u0019:uA!I\u0011QG6C\u0002\u0013%\u0011qG\u0001\u0010g\u0016\f(+Z2pe\u0012\u001cF/\u0019:ugV\u0011\u0011\u0011\b\t\b\u0003w\t)%!\u0013 \u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013!C5n[V$\u0018M\u00197f\u0015\r\t\u0019EE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA$\u0003{\u00111!T1q!\u0011\tY%!\u0015\u000f\u0007E\ti%C\u0002\u0002PI\ta\u0001\u0015:fI\u00164\u0017\u0002BA*\u0003+\u0012aa\u0015;sS:<'bAA(%!A\u0011\u0011L6!\u0002\u0013\tI$\u0001\ttKF\u0014VmY8sIN#\u0018M\u001d;tA!I\u0011QL6C\u0002\u0013\u0005\u0011qL\u0001\u000bg\u0016\f(+Z2pe\u0012\u001cXCAA1!!\tY$!\u0012\u0002J\u0005\r\u0004c\u0001\u0007\u0002f%\u0019\u0011q\r\u0002\u0003\u0019Q;xNQ5u%\u0016\u001cwN\u001d3\t\u0011\u0005-4\u000e)A\u0005\u0003C\n1b]3r%\u0016\u001cwN\u001d3tA!9\u0011qN6\u0005\n\u0005E\u0014A\u0003:fC\u0012DU-\u00193feR\tq\u0004C\u0004\u0002v-$I!a\u001e\u0002\u001dI,\u0017\rZ%oI\u0016DXI\u001c;ssR!\u0011\u0011PA@!\u0019\t\u00121PA%?%\u0019\u0011Q\u0010\n\u0003\rQ+\b\u000f\\33\u0011\u001d\ti\"a\u001dA\u0002}Aq!a!l\t\u0003\t))A\u0004fqR\u0014\u0018m\u0019;\u0015\t\u0005%\u0013q\u0011\u0005\t\u0003\u0013\u000b\t\t1\u0001\u0002\f\u00061!/Z4j_:\u0004B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003##\u0011AB7pI\u0016d7/\u0003\u0003\u0002\u0016\u0006=%a\u0004*fM\u0016\u0014XM\\2f%\u0016<\u0017n\u001c8")
public class TwoBitFile
implements ReferenceFile {
    private final ByteBuffer bytes;
    private final int numSeq;
    private int indexRecordStart;
    private final Map<String, Object> seqRecordStarts;
    private final Map<String, TwoBitRecord> seqRecords;

    public static int SEQ_RECORD_RESERVED_SIZE() {
        return TwoBitFile$.MODULE$.SEQ_RECORD_RESERVED_SIZE();
    }

    public static int PER_BLOCK_SIZE() {
        return TwoBitFile$.MODULE$.PER_BLOCK_SIZE();
    }

    public static int BLOCK_COUNT_SIZE() {
        return TwoBitFile$.MODULE$.BLOCK_COUNT_SIZE();
    }

    public static int DNA_SIZE_SIZE() {
        return TwoBitFile$.MODULE$.DNA_SIZE_SIZE();
    }

    public static int INT_SIZE() {
        return TwoBitFile$.MODULE$.INT_SIZE();
    }

    public static int OFFSET_SIZE() {
        return TwoBitFile$.MODULE$.OFFSET_SIZE();
    }

    public static int NAME_SIZE_SIZE() {
        return TwoBitFile$.MODULE$.NAME_SIZE_SIZE();
    }

    public static int FILE_INDEX_OFFSET() {
        return TwoBitFile$.MODULE$.FILE_INDEX_OFFSET();
    }

    public static int HEADER_RESERVED_OFFSET() {
        return TwoBitFile$.MODULE$.HEADER_RESERVED_OFFSET();
    }

    public static int SEQUENCE_COUNT_OFFSET() {
        return TwoBitFile$.MODULE$.SEQUENCE_COUNT_OFFSET();
    }

    public static int VERSION_OFFSET() {
        return TwoBitFile$.MODULE$.VERSION_OFFSET();
    }

    public static byte MASK() {
        return TwoBitFile$.MODULE$.MASK();
    }

    public static int BYTE_SIZE() {
        return TwoBitFile$.MODULE$.BYTE_SIZE();
    }

    public static int BASES_PER_BYTE() {
        return TwoBitFile$.MODULE$.BASES_PER_BYTE();
    }

    public static int MAGIC_NUMBER() {
        return TwoBitFile$.MODULE$.MAGIC_NUMBER();
    }

    public ByteBuffer bytes() {
        return this.bytes;
    }

    public int numSeq() {
        return this.numSeq;
    }

    public int indexRecordStart() {
        return this.indexRecordStart;
    }

    public void indexRecordStart_$eq(int x$1) {
        this.indexRecordStart = x$1;
    }

    private Map<String, Object> seqRecordStarts() {
        return this.seqRecordStarts;
    }

    public Map<String, TwoBitRecord> seqRecords() {
        return this.seqRecords;
    }

    private int readHeader() {
        this.bytes().order(ByteOrder.LITTLE_ENDIAN);
        Object object = this.bytes().getInt(0) != TwoBitFile$.MODULE$.MAGIC_NUMBER() ? this.bytes().order(ByteOrder.BIG_ENDIAN) : BoxedUnit.UNIT;
        if (this.bytes().getInt(0) != TwoBitFile$.MODULE$.MAGIC_NUMBER()) {
            throw new IllegalStateException();
        }
        Predef$.MODULE$.assert(this.bytes().getInt(TwoBitFile$.MODULE$.VERSION_OFFSET()) == 0, (Function0)new Serializable(this){

            public final String apply() {
                return "Version must be zero";
            }
        });
        Predef$.MODULE$.assert(this.bytes().getInt(TwoBitFile$.MODULE$.HEADER_RESERVED_OFFSET()) == 0, (Function0)new Serializable(this){

            public final String apply() {
                return "Reserved field must be zero";
            }
        });
        Predef$.MODULE$.assert(this.bytes().hasArray());
        return this.bytes().getInt(TwoBitFile$.MODULE$.SEQUENCE_COUNT_OFFSET());
    }

    public Tuple2<String, Object> org$bdgenomics$adam$util$TwoBitFile$$readIndexEntry(int indexRecordStart) {
        byte nameSize = this.bytes().get(indexRecordStart);
        String name = new String(this.bytes().array(), indexRecordStart + TwoBitFile$.MODULE$.NAME_SIZE_SIZE(), (int)nameSize, "UTF-8");
        int contigOffset = this.bytes().getInt(indexRecordStart + TwoBitFile$.MODULE$.NAME_SIZE_SIZE() + nameSize);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)BoxesRunTime.boxToInteger((int)contigOffset));
    }

    @Override
    public String extract(ReferenceRegion region2) {
        TwoBitRecord record = (TwoBitRecord)this.seqRecords().apply((Object)region2.referenceName());
        int contigLength = record.dnaSize();
        Predef$.MODULE$.assert(region2.start() >= 0L);
        Predef$.MODULE$.assert(region2.end() <= (long)contigLength);
        int offset = record.dnaOffset();
        StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)region2.width()).foreach((Function1)new Serializable(this, region2, offset, sb){
            private final /* synthetic */ TwoBitFile $outer;
            private final ReferenceRegion region$1;
            private final int offset$1;
            private final StringBuilder sb$1;

            public final StringBuilder apply(int i) {
                char c;
                byte by = this.$outer.bytes().get(this.offset$1 + ((int)this.region$1.start() + i) / TwoBitFile$.MODULE$.BASES_PER_BYTE());
                long slot = (this.region$1.start() + (long)i) % (long)TwoBitFile$.MODULE$.BASES_PER_BYTE() + 1L;
                long shift = (long)TwoBitFile$.MODULE$.BYTE_SIZE() - 2L * slot;
                int n = (int)((long)by >> (int)shift) & TwoBitFile$.MODULE$.MASK();
                switch (n) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    case 3: {
                        c = 'G';
                        break;
                    }
                    case 2: {
                        c = 'A';
                        break;
                    }
                    case 1: {
                        c = 'C';
                        break;
                    }
                    case 0: {
                        c = 'T';
                    }
                }
                char nt = c;
                return this.sb$1.$plus$eq(nt);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.region$1 = region$1;
                this.offset$1 = offset$1;
                this.sb$1 = sb$1;
            }
        });
        return sb.toString();
    }

    public TwoBitFile(ByteAccess byteAccess) {
        this.bytes = ByteBuffer.wrap(byteAccess.readFully(0L, (int)byteAccess.length()));
        this.numSeq = this.readHeader();
        this.indexRecordStart = TwoBitFile$.MODULE$.FILE_INDEX_OFFSET();
        this.seqRecordStarts = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numSeq()).map((Function1)new Serializable(this){
            private final /* synthetic */ TwoBitFile $outer;

            /*
             * WARNING - void declaration
             */
            public final Tuple2<String, Object> apply(int i) {
                void var2_2;
                Tuple2<String, Object> tup = this.$outer.org$bdgenomics$adam$util$TwoBitFile$$readIndexEntry(this.$outer.indexRecordStart());
                this.$outer.indexRecordStart_$eq(this.$outer.indexRecordStart() + (TwoBitFile$.MODULE$.NAME_SIZE_SIZE() + ((String)tup._1()).length() + TwoBitFile$.MODULE$.OFFSET_SIZE()));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.seqRecords = ((Map)this.seqRecordStarts().map((Function1)new Serializable(this){
            private final /* synthetic */ TwoBitFile $outer;

            public final Tuple2<String, TwoBitRecord> apply(Tuple2<String, Object> tup) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tup._1()), (Object)TwoBitRecord$.MODULE$.apply(this.$outer.bytes(), (String)tup._1(), tup._2$mcI$sp()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

