/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.statisticslevel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import parquet.Preconditions;
import parquet.column.statistics.Statistics;
import parquet.common.schema.ColumnPath;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.Operators;
import parquet.filter2.predicate.UserDefinedPredicate;
import parquet.hadoop.metadata.ColumnChunkMetaData;

public class StatisticsFilter
implements FilterPredicate.Visitor<Boolean> {
    private final Map<ColumnPath, ColumnChunkMetaData> columns = new HashMap<ColumnPath, ColumnChunkMetaData>();

    public static boolean canDrop(FilterPredicate pred, List<ColumnChunkMetaData> columns) {
        Preconditions.checkNotNull((Object)pred, (String)"pred");
        Preconditions.checkNotNull(columns, (String)"columns");
        return (Boolean)pred.accept((FilterPredicate.Visitor)new StatisticsFilter(columns));
    }

    private StatisticsFilter(List<ColumnChunkMetaData> columnsList) {
        for (ColumnChunkMetaData chunk : columnsList) {
            this.columns.put(chunk.getPath(), chunk);
        }
    }

    private ColumnChunkMetaData getColumnChunk(ColumnPath columnPath) {
        ColumnChunkMetaData c = this.columns.get(columnPath);
        Preconditions.checkArgument((c != null ? 1 : 0) != 0, (String)("Column " + columnPath.toDotString() + " not found in schema!"));
        return c;
    }

    private boolean isAllNulls(ColumnChunkMetaData column) {
        return column.getStatistics().getNumNulls() == column.getValueCount();
    }

    private boolean hasNulls(ColumnChunkMetaData column) {
        return column.getStatistics().getNumNulls() > 0L;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Eq<T> eq) {
        Operators.Column filterColumn = eq.getColumn();
        Comparable value = eq.getValue();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        if (value == null) {
            return !this.hasNulls(columnChunk);
        }
        if (this.isAllNulls(columnChunk)) {
            return true;
        }
        Statistics stats = columnChunk.getStatistics();
        return value.compareTo(stats.genericGetMin()) < 0 || value.compareTo(stats.genericGetMax()) > 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.NotEq<T> notEq) {
        Operators.Column filterColumn = notEq.getColumn();
        Comparable value = notEq.getValue();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        if (value == null) {
            return this.isAllNulls(columnChunk);
        }
        if (this.hasNulls(columnChunk)) {
            return false;
        }
        Statistics stats = columnChunk.getStatistics();
        return value.compareTo(stats.genericGetMin()) == 0 && value.compareTo(stats.genericGetMax()) == 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Lt<T> lt) {
        Operators.Column filterColumn = lt.getColumn();
        Comparable value = lt.getValue();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        if (this.isAllNulls(columnChunk)) {
            return true;
        }
        Statistics stats = columnChunk.getStatistics();
        return value.compareTo(stats.genericGetMin()) <= 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.LtEq<T> ltEq) {
        Operators.Column filterColumn = ltEq.getColumn();
        Comparable value = ltEq.getValue();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        if (this.isAllNulls(columnChunk)) {
            return true;
        }
        Statistics stats = columnChunk.getStatistics();
        return value.compareTo(stats.genericGetMin()) < 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Gt<T> gt) {
        Operators.Column filterColumn = gt.getColumn();
        Comparable value = gt.getValue();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        if (this.isAllNulls(columnChunk)) {
            return true;
        }
        Statistics stats = columnChunk.getStatistics();
        return value.compareTo(stats.genericGetMax()) >= 0;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.GtEq<T> gtEq) {
        Operators.Column filterColumn = gtEq.getColumn();
        Comparable value = gtEq.getValue();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        if (this.isAllNulls(columnChunk)) {
            return true;
        }
        Statistics stats = columnChunk.getStatistics();
        return value.compareTo(stats.genericGetMax()) > 0;
    }

    public Boolean visit(Operators.And and) {
        return (Boolean)and.getLeft().accept((FilterPredicate.Visitor)this) != false && (Boolean)and.getRight().accept((FilterPredicate.Visitor)this) != false;
    }

    public Boolean visit(Operators.Or or) {
        return (Boolean)or.getLeft().accept((FilterPredicate.Visitor)this) != false && (Boolean)or.getRight().accept((FilterPredicate.Visitor)this) != false;
    }

    public Boolean visit(Operators.Not not) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through LogicalInverseRewriter? " + not);
    }

    private <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> ud, boolean inverted) {
        Operators.Column filterColumn = ud.getColumn();
        ColumnChunkMetaData columnChunk = this.getColumnChunk(filterColumn.getColumnPath());
        UserDefinedPredicate udp = ud.getUserDefinedPredicate();
        Statistics stats = columnChunk.getStatistics();
        parquet.filter2.predicate.Statistics udpStats = new parquet.filter2.predicate.Statistics((Object)stats.genericGetMin(), (Object)stats.genericGetMax());
        if (inverted) {
            return udp.inverseCanDrop(udpStats);
        }
        return udp.canDrop(udpStats);
    }

    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> ud) {
        return this.visit(ud, false);
    }

    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.LogicalNotUserDefined<T, U> lnud) {
        return this.visit(lnud.getUserDefined(), true);
    }
}

