/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.AtomicUtils;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

public class PeakRateCounter
extends AbstractMonitor<Number>
implements Counter,
ResettableMonitor<Number> {
    private final PeakInterval[] peakIntervals;

    public PeakRateCounter(MonitorConfig config) {
        this(config, Pollers.POLLING_INTERVALS);
    }

    PeakRateCounter(MonitorConfig config, long[] pollingIntervals) {
        super(config.withAdditionalTag(DataSourceType.RATE));
        this.peakIntervals = new PeakInterval[pollingIntervals.length];
        for (int i = 0; i < this.peakIntervals.length; ++i) {
            this.peakIntervals[i] = new PeakInterval((int)(pollingIntervals[i] / 1000L));
        }
    }

    @Deprecated
    public PeakRateCounter(MonitorConfig config, int intervalSeconds) {
        this(config, Pollers.POLLING_INTERVALS);
    }

    @Override
    public Number getValue() {
        return this.peakIntervals[0].getValue();
    }

    @Override
    public Number getAndResetValue() {
        return this.getAndResetValue(0);
    }

    @Override
    public Number getAndResetValue(int pollerIdx) {
        return this.peakIntervals[pollerIdx].getAndResetValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PeakRateCounter)) {
            return false;
        }
        PeakRateCounter c = (PeakRateCounter)obj;
        return this.config.equals(c.getConfig()) && Arrays.equals(this.peakIntervals, c.peakIntervals);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.getValue()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("max rate per second", (Object)this.getValue()).toString();
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void increment(long amount) {
        long now = System.currentTimeMillis() / 1000L;
        for (PeakInterval peakInterval : this.peakIntervals) {
            peakInterval.increment(now, amount);
        }
    }

    private static class PeakInterval {
        final AtomicReference<AtomicLongArray> countsRef;

        PeakInterval(int numBuckets) {
            this.countsRef = new AtomicReference<AtomicLongArray>(new AtomicLongArray(numBuckets));
        }

        Number getValue() {
            return this.getValue(this.countsRef.get());
        }

        Number getValue(AtomicLongArray counts) {
            long max = 0L;
            for (int i = 0; i < counts.length(); ++i) {
                long cnt = counts.get(i);
                if (cnt <= max) continue;
                max = cnt;
            }
            return max;
        }

        Number getAndResetValue() {
            AtomicLongArray counts = this.countsRef.getAndSet(new AtomicLongArray(this.countsRef.get().length()));
            return this.getValue(counts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PeakInterval that = (PeakInterval)o;
            return AtomicUtils.equals(this.countsRef.get(), that.countsRef.get());
        }

        public int hashCode() {
            return AtomicUtils.hashCode(this.countsRef.get());
        }

        void increment(long now, long amount) {
            int index = (int)now % this.countsRef.get().length();
            this.countsRef.get().addAndGet(index, amount);
        }
    }
}

