/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.util.concurrent.atomic.AtomicInteger;

public final class BasicTag
implements Tag {
    private final String key;
    private final String value;
    private final AtomicInteger cachedHashCode = new AtomicInteger(0);

    public BasicTag(String key, String value) {
        this.key = this.checkNotEmpty(key, "key");
        this.value = this.checkNotEmpty(value, "value");
    }

    private String checkNotEmpty(String v, String name) {
        Preconditions.checkNotNull((Object)v, (String)"%s cannot be null", (Object[])new Object[]{name});
        Preconditions.checkArgument((!"".equals(v) ? 1 : 0) != 0, (String)"%s cannot be empty", (Object[])new Object[]{name});
        return v;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BasicTag) {
            BasicTag t = (BasicTag)o;
            return this.key.equals(t.getKey()) && this.value.equals(t.getValue());
        }
        return false;
    }

    public int hashCode() {
        int hash = this.cachedHashCode.get();
        if (hash == 0) {
            hash = Objects.hashCode((Object[])new Object[]{this.key, this.value});
            this.cachedHashCode.set(hash);
        }
        return hash;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public static BasicTag parseTag(String tagString) {
        return (BasicTag)Tags.parseTag(tagString);
    }

    @Override
    public String tagString() {
        return this.toString();
    }
}

