/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.servo.jsr166e.ConcurrentHashMapV8;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExpiringCache<K, V> {
    private final ConcurrentHashMapV8<K, Entry<V>> map;
    private final long expireAfterMs;
    private final ConcurrentHashMapV8.Fun<K, Entry<V>> entryGetter;
    private static final ScheduledExecutorService service;

    public ExpiringCache(long expireAfterMs, ConcurrentHashMapV8.Fun<K, V> getter) {
        this(expireAfterMs, getter, TimeUnit.MINUTES.toMillis(1L));
    }

    public ExpiringCache(final long expireAfterMs, ConcurrentHashMapV8.Fun<K, V> getter, long expirationFreqMs) {
        Preconditions.checkArgument((expireAfterMs > 0L ? 1 : 0) != 0, (Object)"expireAfterMs must be positive.");
        Preconditions.checkArgument((expirationFreqMs > 0L ? 1 : 0) != 0, (Object)"expirationFreqMs must be positive.");
        this.map = new ConcurrentHashMapV8();
        this.expireAfterMs = expireAfterMs;
        this.entryGetter = this.toEntry(getter);
        Runnable expirationJob = new Runnable(){

            @Override
            public void run() {
                long tooOld = System.currentTimeMillis() - expireAfterMs;
                for (Map.Entry entry : ExpiringCache.this.map.entrySet()) {
                    if (((Entry)entry.getValue()).accessTime >= tooOld) continue;
                    ExpiringCache.this.map.remove(entry.getKey(), entry.getValue());
                }
            }
        };
        service.scheduleWithFixedDelay(expirationJob, 1L, expirationFreqMs, TimeUnit.MILLISECONDS);
    }

    private ConcurrentHashMapV8.Fun<K, Entry<V>> toEntry(final ConcurrentHashMapV8.Fun<K, V> underlying) {
        return new ConcurrentHashMapV8.Fun<K, Entry<V>>(){

            @Override
            public Entry<V> apply(K key) {
                return new Entry(underlying.apply(key), 0L);
            }
        };
    }

    public V get(K key) {
        Entry<V> entry = this.map.computeIfAbsent(key, this.entryGetter);
        return (V)((Entry)entry).getValue();
    }

    public List<V> values() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Entry<V> e : this.map.values()) {
            builder.add(((Entry)e).value);
        }
        return builder.build();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return "ExpiringCache{map=" + this.map + ", expireAfterMs=" + this.expireAfterMs + '}';
    }

    static {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("expiringMap-%d").build();
        service = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    private static class Entry<V> {
        private volatile long accessTime;
        private final V value;

        private Entry(V value, long accessTime) {
            this.value = value;
            this.accessTime = accessTime;
        }

        private V getValue() {
            this.accessTime = System.currentTimeMillis();
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.accessTime == entry.accessTime && this.value.equals(entry.value);
        }

        public int hashCode() {
            int result = (int)(this.accessTime ^ this.accessTime >>> 32);
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "Entry{accessTime=" + this.accessTime + ", value=" + this.value + '}';
        }
    }
}

