/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReaderFactory;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContainerParser {
    private static final Log log = Log.getInstance(ContainerParser.class);
    private final SAMFileHeader samFileHeader;
    private final Map<String, Long> nanosecondsMap = new TreeMap<String, Long>();

    public ContainerParser(SAMFileHeader sAMFileHeader) {
        this.samFileHeader = sAMFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> arrayList) throws IllegalArgumentException, IllegalAccessException {
        long l = System.nanoTime();
        if (arrayList == null) {
            arrayList = new ArrayList(container.nofRecords);
        }
        for (Slice object : container.slices) {
            arrayList.addAll(this.getRecords(object, container.header));
        }
        long l2 = System.nanoTime();
        container.parseTime = l2 - l;
        if (log.isEnabled(Log.LogLevel.DEBUG)) {
            for (String string : this.nanosecondsMap.keySet()) {
                log.debug(String.format("%s: %dms.", string, this.nanosecondsMap.get(string) / 1000000L));
            }
        }
        return arrayList;
    }

    ArrayList<CramCompressionRecord> getRecords(ArrayList<CramCompressionRecord> arrayList, Slice slice, CompressionHeader compressionHeader) throws IllegalArgumentException, IllegalAccessException {
        Object object;
        String string = "*";
        switch (slice.sequenceId) {
            case -2: 
            case -1: {
                break;
            }
            default: {
                object = this.samFileHeader.getSequence(slice.sequenceId);
                string = ((SAMSequenceRecord)object).getSequenceName();
            }
        }
        object = new DataReaderFactory();
        HashMap<Integer, InputStream> hashMap = new HashMap<Integer, InputStream>();
        for (Integer n : slice.external.keySet()) {
            log.debug("Adding external data: " + n);
            hashMap.put(n, new ByteArrayInputStream(slice.external.get(n).getRawContent()));
        }
        CramRecordReader cramRecordReader = new CramRecordReader();
        ((DataReaderFactory)object).buildReader(cramRecordReader, new DefaultBitInputStream(new ByteArrayInputStream(slice.coreBlock.getRawContent())), hashMap, compressionHeader, slice.sequenceId);
        if (arrayList == null) {
            arrayList = new ArrayList(slice.nofRecords);
        }
        long l = 0L;
        int n = slice.alignmentStart;
        for (int i = 0; i < slice.nofRecords; ++i) {
            CramCompressionRecord cramCompressionRecord = new CramCompressionRecord();
            cramCompressionRecord.sliceIndex = slice.index;
            cramCompressionRecord.index = i;
            long l2 = System.nanoTime();
            cramRecordReader.read(cramCompressionRecord);
            l += System.nanoTime() - l2;
            if (cramCompressionRecord.sequenceId == slice.sequenceId) {
                cramCompressionRecord.sequenceName = string;
                cramCompressionRecord.sequenceId = slice.sequenceId;
            } else {
                cramCompressionRecord.sequenceName = cramCompressionRecord.sequenceId == -1 ? "*" : this.samFileHeader.getSequence(cramCompressionRecord.sequenceId).getSequenceName();
            }
            arrayList.add(cramCompressionRecord);
            if (!compressionHeader.APDelta) continue;
            cramCompressionRecord.alignmentStart = n += cramCompressionRecord.alignmentDelta;
        }
        log.debug("Slice records read time: " + l / 1000000L);
        Map<String, DataReaderFactory.DataReaderWithStats> map = ((DataReaderFactory)object).getStats(cramRecordReader);
        for (String string2 : map.keySet()) {
            long l3;
            if (!this.nanosecondsMap.containsKey(string2)) {
                this.nanosecondsMap.put(string2, 0L);
                l3 = 0L;
            } else {
                l3 = this.nanosecondsMap.get(string2);
            }
            this.nanosecondsMap.put(string2, l3 + map.get((Object)string2).nanos);
        }
        return arrayList;
    }

    List<CramCompressionRecord> getRecords(Slice slice, CompressionHeader compressionHeader) throws IllegalArgumentException, IllegalAccessException {
        return this.getRecords(null, slice, compressionHeader);
    }
}

