/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class CramInt {
    public static int int32(InputStream inputStream) throws IOException {
        return inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
    }

    public static int int32(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Expecting a 4-byte integer. ");
        }
        return 0xFF & byArray[0] | (0xFF & byArray[1]) << 8 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[3]) << 24;
    }

    public static int int32(ByteBuffer byteBuffer) {
        return byteBuffer.get() | byteBuffer.get() << 8 | byteBuffer.get() << 16 | byteBuffer.get() << 24;
    }

    public static int writeInt32(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)n);
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 24));
        return 32;
    }

    public static byte[] writeInt32(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }
}

