/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.samtools.util.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class Allele
implements Comparable<Allele>,
Serializable {
    public static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_ALLELE_BASES = new byte[0];
    private boolean isRef = false;
    private boolean isNoCall = false;
    private boolean isSymbolic = false;
    private byte[] bases = null;
    public static final String NO_CALL_STRING = ".";
    public static final String SPAN_DEL_STRING = "*";
    private static final Allele REF_A = new Allele("A", true);
    private static final Allele ALT_A = new Allele("A", false);
    private static final Allele REF_C = new Allele("C", true);
    private static final Allele ALT_C = new Allele("C", false);
    private static final Allele REF_G = new Allele("G", true);
    private static final Allele ALT_G = new Allele("G", false);
    private static final Allele REF_T = new Allele("T", true);
    private static final Allele ALT_T = new Allele("T", false);
    private static final Allele REF_N = new Allele("N", true);
    private static final Allele ALT_N = new Allele("N", false);
    public static final Allele SPAN_DEL = new Allele("*", false);
    public static final Allele NO_CALL = new Allele(".", false);

    protected Allele(byte[] byArray, boolean bl) {
        if (Allele.wouldBeNullAllele(byArray)) {
            throw new IllegalArgumentException("Null alleles are not supported");
        }
        if (Allele.wouldBeNoCallAllele(byArray)) {
            this.bases = EMPTY_ALLELE_BASES;
            this.isNoCall = true;
            if (bl) {
                throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
            }
            return;
        }
        if (Allele.wouldBeSymbolicAllele(byArray)) {
            this.isSymbolic = true;
            if (bl) {
                throw new IllegalArgumentException("Cannot tag a symbolic allele as the reference allele");
            }
        } else {
            StringUtil.toUpperCase(byArray);
        }
        this.isRef = bl;
        this.bases = byArray;
        if (!Allele.acceptableAlleleBases(byArray, bl)) {
            throw new IllegalArgumentException("Unexpected base in allele bases '" + new String(byArray) + "'");
        }
    }

    protected Allele(String string, boolean bl) {
        this(string.getBytes(), bl);
    }

    protected Allele(Allele allele, boolean bl) {
        this.bases = allele.bases;
        this.isRef = bl ? false : allele.isRef;
        this.isNoCall = allele.isNoCall;
        this.isSymbolic = allele.isSymbolic;
    }

    public static Allele create(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException("create: the Allele base string cannot be null; use new Allele() or new Allele(\"\") to create a Null allele");
        }
        if (byArray.length == 1) {
            switch (byArray[0]) {
                case 46: {
                    if (bl) {
                        throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
                    }
                    return NO_CALL;
                }
                case 42: {
                    if (bl) {
                        throw new IllegalArgumentException("Cannot tag a spanning deletions allele as the reference allele");
                    }
                    return SPAN_DEL;
                }
                case 65: 
                case 97: {
                    return bl ? REF_A : ALT_A;
                }
                case 67: 
                case 99: {
                    return bl ? REF_C : ALT_C;
                }
                case 71: 
                case 103: {
                    return bl ? REF_G : ALT_G;
                }
                case 84: 
                case 116: {
                    return bl ? REF_T : ALT_T;
                }
                case 78: 
                case 110: {
                    return bl ? REF_N : ALT_N;
                }
            }
            throw new IllegalArgumentException("Illegal base [" + (char)byArray[0] + "] seen in the allele");
        }
        return new Allele(byArray, bl);
    }

    public static Allele create(byte by, boolean bl) {
        return Allele.create(new byte[]{by}, bl);
    }

    public static Allele create(byte by) {
        return Allele.create(by, false);
    }

    public static Allele extend(Allele allele, byte[] byArray) {
        if (allele.isSymbolic()) {
            throw new IllegalArgumentException("Cannot extend a symbolic allele");
        }
        byte[] byArray2 = new byte[allele.length() + byArray.length];
        System.arraycopy(allele.getBases(), 0, byArray2, 0, allele.length());
        System.arraycopy(byArray, 0, byArray2, allele.length(), byArray.length);
        return Allele.create(byArray2, allele.isReference());
    }

    public static boolean wouldBeNullAllele(byte[] byArray) {
        return byArray.length == 1 && byArray[0] == 45 || byArray.length == 0;
    }

    public static boolean wouldBeStarAllele(byte[] byArray) {
        return byArray.length == 1 && byArray[0] == 42;
    }

    public static boolean wouldBeNoCallAllele(byte[] byArray) {
        return byArray.length == 1 && byArray[0] == 46;
    }

    public static boolean wouldBeSymbolicAllele(byte[] byArray) {
        if (byArray.length <= 1) {
            return false;
        }
        String string = new String(byArray);
        return byArray[0] == 60 || byArray[byArray.length - 1] == 62 || byArray[0] == 46 || byArray[byArray.length - 1] == 46 || string.contains("[") || string.contains("]");
    }

    public static boolean acceptableAlleleBases(String string) {
        return Allele.acceptableAlleleBases(string.getBytes(), true);
    }

    public static boolean acceptableAlleleBases(String string, boolean bl) {
        return Allele.acceptableAlleleBases(string.getBytes(), bl);
    }

    public static boolean acceptableAlleleBases(byte[] byArray) {
        return Allele.acceptableAlleleBases(byArray, true);
    }

    public static boolean acceptableAlleleBases(byte[] byArray, boolean bl) {
        if (Allele.wouldBeNullAllele(byArray)) {
            return false;
        }
        if (Allele.wouldBeNoCallAllele(byArray) || Allele.wouldBeSymbolicAllele(byArray)) {
            return true;
        }
        if (Allele.wouldBeStarAllele(byArray)) {
            return !bl;
        }
        block3: for (byte by : byArray) {
            switch (by) {
                case 65: 
                case 67: 
                case 71: 
                case 78: 
                case 84: 
                case 97: 
                case 99: 
                case 103: 
                case 110: 
                case 116: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static Allele create(String string, boolean bl) {
        return Allele.create(string.getBytes(), bl);
    }

    public static Allele create(String string) {
        return Allele.create(string, false);
    }

    public static Allele create(byte[] byArray) {
        return Allele.create(byArray, false);
    }

    public static Allele create(Allele allele, boolean bl) {
        return new Allele(allele, bl);
    }

    public boolean isNoCall() {
        return this.isNoCall;
    }

    public boolean isCalled() {
        return !this.isNoCall();
    }

    public boolean isReference() {
        return this.isRef;
    }

    public boolean isNonReference() {
        return !this.isReference();
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    public String toString() {
        return (this.isNoCall() ? NO_CALL_STRING : this.getDisplayString()) + (this.isReference() ? SPAN_DEL_STRING : "");
    }

    public byte[] getBases() {
        return this.isSymbolic ? EMPTY_ALLELE_BASES : this.bases;
    }

    public String getBaseString() {
        return this.isNoCall() ? NO_CALL_STRING : new String(this.getBases());
    }

    public String getDisplayString() {
        return new String(this.bases);
    }

    public byte[] getDisplayBases() {
        return this.bases;
    }

    public boolean equals(Object object) {
        return !(object instanceof Allele) ? false : this.equals((Allele)object, false);
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.bases.length; ++i) {
            n += (i + 1) * this.bases[i];
        }
        return n;
    }

    public boolean equals(Allele allele, boolean bl) {
        return this == allele || (this.isRef == allele.isRef || bl) && this.isNoCall == allele.isNoCall && (this.bases == allele.bases || Arrays.equals(this.bases, allele.bases));
    }

    public boolean basesMatch(byte[] byArray) {
        return !this.isSymbolic && (this.bases == byArray || Arrays.equals(this.bases, byArray));
    }

    public boolean basesMatch(String string) {
        return this.basesMatch(string.toUpperCase().getBytes());
    }

    public boolean basesMatch(Allele allele) {
        return this.basesMatch(allele.getBases());
    }

    public int length() {
        return this.isSymbolic ? 0 : this.bases.length;
    }

    public static Allele getMatchingAllele(Collection<Allele> collection, byte[] byArray) {
        for (Allele allele : collection) {
            if (!allele.basesMatch(byArray)) continue;
            return allele;
        }
        if (Allele.wouldBeNoCallAllele(byArray)) {
            return NO_CALL;
        }
        return null;
    }

    @Override
    public int compareTo(Allele allele) {
        if (this.isReference() && allele.isNonReference()) {
            return -1;
        }
        if (this.isNonReference() && allele.isReference()) {
            return 1;
        }
        return this.getBaseString().compareTo(allele.getBaseString());
    }

    public static boolean oneIsPrefixOfOther(Allele allele, Allele allele2) {
        if (allele2.length() >= allele.length()) {
            return Allele.firstIsPrefixOfSecond(allele, allele2);
        }
        return Allele.firstIsPrefixOfSecond(allele2, allele);
    }

    private static boolean firstIsPrefixOfSecond(Allele allele, Allele allele2) {
        String string = allele.getBaseString();
        return allele2.getBaseString().substring(0, string.length()).equals(string);
    }
}

