/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.NameAwareCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFConstants;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public abstract class AbstractVCFCodec
extends AsciiFeatureCodec<VariantContext>
implements NameAwareCodec {
    public static final int MAX_ALLELE_SIZE_BEFORE_WARNING = (int)Math.pow(2.0, 20.0);
    protected static final int NUM_STANDARD_FIELDS = 8;
    protected VCFHeader header = null;
    protected VCFHeaderVersion version = null;
    protected Map<String, List<Allele>> alleleMap = new HashMap<String, List<Allele>>(3);
    public static boolean validate = true;
    protected String[] parts = null;
    protected String[] genotypeParts = null;
    protected final String[] locParts = new String[6];
    protected HashMap<String, List<String>> filterHash = new HashMap();
    protected String name = "Unknown";
    protected int lineNo = 0;
    protected Map<String, String> stringCache = new HashMap<String, String>();
    protected boolean warnedAboutNoEqualsForNonFlag = false;
    protected boolean doOnTheFlyModifications = true;
    protected String remappedSampleName = null;

    protected AbstractVCFCodec() {
        super(VariantContext.class);
    }

    protected abstract List<String> parseFilters(String var1);

    protected VCFHeader parseHeaderFromLines(List<String> list, VCFHeaderVersion vCFHeaderVersion) {
        this.version = vCFHeaderVersion;
        LinkedHashSet<VCFHeaderLine> linkedHashSet = new LinkedHashSet<VCFHeaderLine>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        int n = 0;
        for (String string : list) {
            if (!string.startsWith("##")) {
                String[] stringArray = string.substring(1).split("\t");
                if (stringArray.length < VCFHeader.HEADER_FIELDS.values().length) {
                    throw new TribbleException.InvalidHeader("there are not enough columns present in the header line: " + string);
                }
                int n2 = 0;
                for (VCFHeader.HEADER_FIELDS hEADER_FIELDS : VCFHeader.HEADER_FIELDS.values()) {
                    try {
                        if (hEADER_FIELDS != VCFHeader.HEADER_FIELDS.valueOf(stringArray[n2])) {
                            throw new TribbleException.InvalidHeader("we were expecting column name '" + (Object)((Object)hEADER_FIELDS) + "' but we saw '" + stringArray[n2] + "'");
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new TribbleException.InvalidHeader("unknown column name '" + stringArray[n2] + "'; it does not match a legal column header name.");
                    }
                    ++n2;
                }
                boolean bl = false;
                if (n2 < stringArray.length) {
                    if (!stringArray[n2].equals("FORMAT")) {
                        throw new TribbleException.InvalidHeader("we were expecting column name 'FORMAT' but we saw '" + stringArray[n2] + "'");
                    }
                    bl = true;
                    ++n2;
                }
                while (n2 < stringArray.length) {
                    linkedHashSet2.add(stringArray[n2++]);
                }
                if (bl && linkedHashSet2.size() == 0) {
                    throw new TribbleException.InvalidHeader("The FORMAT field was provided but there is no genotype/sample data");
                }
                if (this.remappedSampleName == null) continue;
                if (linkedHashSet2.isEmpty() || linkedHashSet2.size() > 1) {
                    throw new TribbleException(String.format("Cannot remap sample name to %s because %s samples are specified in the VCF header, and on-the-fly sample name remapping is only supported for single-sample VCFs", this.remappedSampleName, linkedHashSet2.isEmpty() ? "no" : "multiple"));
                }
                linkedHashSet2.clear();
                linkedHashSet2.add(this.remappedSampleName);
                continue;
            }
            if (string.startsWith("##INFO")) {
                VCFInfoHeaderLine vCFInfoHeaderLine = new VCFInfoHeaderLine(string.substring(7), vCFHeaderVersion);
                linkedHashSet.add(vCFInfoHeaderLine);
                continue;
            }
            if (string.startsWith("##FILTER")) {
                VCFFilterHeaderLine vCFFilterHeaderLine = new VCFFilterHeaderLine(string.substring(9), vCFHeaderVersion);
                linkedHashSet.add(vCFFilterHeaderLine);
                continue;
            }
            if (string.startsWith("##FORMAT")) {
                VCFFormatHeaderLine vCFFormatHeaderLine = new VCFFormatHeaderLine(string.substring(9), vCFHeaderVersion);
                linkedHashSet.add(vCFFormatHeaderLine);
                continue;
            }
            if (string.startsWith("##contig")) {
                VCFContigHeaderLine vCFContigHeaderLine = new VCFContigHeaderLine(string.substring(9), vCFHeaderVersion, "##contig".substring(2), n++);
                linkedHashSet.add(vCFContigHeaderLine);
                continue;
            }
            if (string.startsWith("##ALT")) {
                VCFSimpleHeaderLine vCFSimpleHeaderLine = new VCFSimpleHeaderLine(string.substring(6), vCFHeaderVersion, "##ALT".substring(2), Arrays.asList("ID", "Description"));
                linkedHashSet.add(vCFSimpleHeaderLine);
                continue;
            }
            int n3 = string.indexOf("=");
            if (n3 == -1) continue;
            linkedHashSet.add(new VCFHeaderLine(string.substring(2, n3), string.substring(n3 + 1)));
        }
        this.header = new VCFHeader(linkedHashSet, linkedHashSet2);
        if (this.doOnTheFlyModifications) {
            this.header = VCFStandardHeaderLines.repairStandardHeaderLines(this.header);
        }
        return this.header;
    }

    public VCFHeader setVCFHeader(VCFHeader vCFHeader, VCFHeaderVersion vCFHeaderVersion) {
        this.version = vCFHeaderVersion;
        this.header = this.doOnTheFlyModifications ? VCFStandardHeaderLines.repairStandardHeaderLines(vCFHeader) : vCFHeader;
        return this.header;
    }

    @Override
    public Feature decodeLoc(String string) {
        return this.decodeLine(string, false);
    }

    @Override
    public VariantContext decode(String string) {
        return this.decodeLine(string, true);
    }

    private VariantContext decodeLine(String string, boolean bl) {
        if (string.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new TribbleException("VCF Header cannot be null when decoding a record");
        }
        if (this.parts == null) {
            this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
        }
        int n = ParsingUtils.split(string, this.parts, '\t', true);
        if ((this.header == null || !this.header.hasGenotypingData()) && n != 8 || this.header != null && this.header.hasGenotypingData() && n != 9) {
            throw new TribbleException("Line " + this.lineNo + ": there aren't enough columns for line " + string + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + n + " )");
        }
        return this.parseVCFLine(this.parts, bl);
    }

    private VariantContext parseVCFLine(String[] stringArray, boolean bl) {
        Object object;
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder();
        variantContextBuilder.source(this.getName());
        ++this.lineNo;
        String string = this.getCachedString(stringArray[0]);
        variantContextBuilder.chr(string);
        int n = -1;
        try {
            n = Integer.valueOf(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.generateException(stringArray[1] + " is not a valid start position in the VCF format");
        }
        variantContextBuilder.start(n);
        if (stringArray[2].isEmpty()) {
            this.generateException("The VCF specification requires a valid ID field");
        } else if (stringArray[2].equals(".")) {
            variantContextBuilder.noID();
        } else {
            variantContextBuilder.id(stringArray[2]);
        }
        String string2 = this.getCachedString(stringArray[3].toUpperCase());
        String string3 = this.getCachedString(stringArray[4]);
        variantContextBuilder.log10PError(AbstractVCFCodec.parseQual(stringArray[5]));
        List<String> list = this.parseFilters(this.getCachedString(stringArray[6]));
        if (list != null) {
            variantContextBuilder.filters(new HashSet<String>(list));
        }
        Map<String, Object> map = this.parseInfo(stringArray[7]);
        variantContextBuilder.attributes(map);
        if (map.containsKey("END")) {
            try {
                variantContextBuilder.stop(Integer.valueOf(map.get("END").toString()).intValue());
            }
            catch (Exception exception) {
                this.generateException("the END value in the INFO field is not valid");
            }
        } else {
            variantContextBuilder.stop(n + string2.length() - 1);
        }
        List<Allele> list2 = AbstractVCFCodec.parseAlleles(string2, string3, this.lineNo);
        variantContextBuilder.alleles((Collection<Allele>)list2);
        if (stringArray.length > 8 && bl) {
            object = new LazyVCFGenotypesParser(list2, string, n);
            int n2 = this.header.getNGenotypeSamples();
            LazyGenotypesContext lazyGenotypesContext = new LazyGenotypesContext((LazyGenotypesContext.LazyParser)object, stringArray[8], n2);
            if (!this.header.samplesWereAlreadySorted()) {
                lazyGenotypesContext.decode();
            }
            variantContextBuilder.genotypesNoValidation(lazyGenotypesContext);
        }
        object = null;
        try {
            object = variantContextBuilder.make();
        }
        catch (Exception exception) {
            this.generateException(exception.getMessage());
        }
        return object;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    protected String getCachedString(String string) {
        String string2 = this.stringCache.get(string);
        if (string2 == null) {
            string2 = new String(string);
            this.stringCache.put(string2, string2);
        }
        return string2;
    }

    private Map<String, Object> parseInfo(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string.isEmpty()) {
            this.generateException("The VCF specification requires a valid (non-zero length) info field");
        }
        if (!string.equals(".")) {
            if (string.indexOf("\t") != -1 || string.indexOf(" ") != -1) {
                this.generateException("The VCF specification does not allow for whitespace in the INFO field. Offending field value was \"" + string + "\"");
            }
            List<String> list = ParsingUtils.split(string, ';');
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                String string2;
                int n = list.get(i).indexOf("=");
                if (n != -1) {
                    string2 = list.get(i).substring(0, n);
                    object2 = list.get(i).substring(n + 1);
                    List<String> list2 = ParsingUtils.split((String)object2, ',');
                    if (list2.size() == 1) {
                        object = list2.get(0);
                        VCFInfoHeaderLine vCFInfoHeaderLine = this.header.getInfoHeaderLine(string2);
                        if (vCFInfoHeaderLine != null && vCFInfoHeaderLine.getType() == VCFHeaderLineType.Flag && object.equals("0")) {
                            continue;
                        }
                    } else {
                        object = list2;
                    }
                } else {
                    string2 = list.get(i);
                    object2 = this.header.getInfoHeaderLine(string2);
                    object = object2 != null && ((VCFCompoundHeaderLine)object2).getType() != VCFHeaderLineType.Flag ? "." : Boolean.valueOf(true);
                }
                if ("".equals(object)) {
                    object = ".";
                }
                hashMap.put(string2, object);
            }
        }
        return hashMap;
    }

    protected static Allele oneAllele(String string, List<Allele> list) {
        int n;
        if (string.equals(".")) {
            return Allele.NO_CALL;
        }
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TribbleException.InternalCodecException("The following invalid GT allele index was encountered in the file: " + string);
        }
        if (n >= list.size()) {
            throw new TribbleException.InternalCodecException("The allele with index " + string + " is not defined in the REF/ALT columns in the record");
        }
        return list.get(n);
    }

    protected static List<Allele> parseGenotypeAlleles(String string, List<Allele> list, Map<String, List<Allele>> map) {
        List<Allele> list2 = map.get(string);
        if (list2 == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/|\\");
            list2 = new ArrayList<Allele>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                list2.add(AbstractVCFCodec.oneAllele(string2, list));
            }
            map.put(string, list2);
        }
        return list2;
    }

    protected static Double parseQual(String string) {
        if (string.equals(".")) {
            return 1.0;
        }
        Double d = Double.valueOf(string);
        if (d < 0.0 && Math.abs(d - VCFConstants.MISSING_QUALITY_v3_DOUBLE) < VCFConstants.VCF_ENCODING_EPSILON) {
            return 1.0;
        }
        return d / -10.0;
    }

    protected static List<Allele> parseAlleles(String string, String string2, int n) {
        ArrayList<Allele> arrayList = new ArrayList<Allele>(2);
        AbstractVCFCodec.checkAllele(string, true, n);
        Allele allele = Allele.create(string, true);
        arrayList.add(allele);
        if (string2.indexOf(",") == -1) {
            AbstractVCFCodec.parseSingleAltAllele(arrayList, string2, n);
        } else {
            for (String string3 : string2.split(",")) {
                AbstractVCFCodec.parseSingleAltAllele(arrayList, string3, n);
            }
        }
        return arrayList;
    }

    private static void checkAllele(String string, boolean bl, int n) {
        if (string == null || string.isEmpty()) {
            AbstractVCFCodec.generateException(AbstractVCFCodec.generateExceptionTextForBadAlleleBases(""), n);
        }
        if (AbstractVCFCodec.isSymbolicAllele(string)) {
            if (bl) {
                AbstractVCFCodec.generateException("Symbolic alleles not allowed as reference allele: " + string, n);
            }
        } else {
            if (string.charAt(0) == 'D' || string.charAt(0) == 'I') {
                AbstractVCFCodec.generateException("Insertions/Deletions are not supported when reading 3.x VCF's. Please convert your file to VCF4 using VCFTools, available at http://vcftools.sourceforge.net/index.html", n);
            }
            if (!Allele.acceptableAlleleBases(string)) {
                AbstractVCFCodec.generateException(AbstractVCFCodec.generateExceptionTextForBadAlleleBases(string), n);
            }
            if (bl && string.equals(".")) {
                AbstractVCFCodec.generateException("The reference allele cannot be missing", n);
            }
        }
    }

    private static String generateExceptionTextForBadAlleleBases(String string) {
        if (string.isEmpty()) {
            return "empty alleles are not permitted in VCF records";
        }
        if (string.contains("[") || string.contains("]") || string.contains(":") || string.contains(".")) {
            return "VCF support for complex rearrangements with breakends has not yet been implemented";
        }
        return "unparsable vcf record with allele " + string;
    }

    private static boolean isSymbolicAllele(String string) {
        return string != null && string.length() > 2 && (string.startsWith("<") && string.endsWith(">") || string.contains("[") || string.contains("]"));
    }

    private static void parseSingleAltAllele(List<Allele> list, String string, int n) {
        AbstractVCFCodec.checkAllele(string, false, n);
        Allele allele = Allele.create(string, false);
        if (!allele.isNoCall()) {
            list.add(allele);
        }
    }

    public static final boolean canDecodeFile(String string, String string2) {
        try {
            return AbstractVCFCodec.isVCFStream(new FileInputStream(string), string2) || AbstractVCFCodec.isVCFStream(new GZIPInputStream(new FileInputStream(string)), string2) || AbstractVCFCodec.isVCFStream(new BlockCompressedInputStream(new FileInputStream(string)), string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isVCFStream(InputStream inputStream, String string) {
        try {
            boolean bl;
            byte[] byArray = new byte[string.length()];
            int n = inputStream.read(byArray, 0, string.length());
            boolean bl2 = bl = Arrays.equals(byArray, string.getBytes());
            return bl2;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public LazyGenotypesContext.LazyData createGenotypeMap(String string, List<Allele> list, String string2, int n) {
        int n2;
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        if ((n2 = ParsingUtils.split(string, this.genotypeParts, '\t')) != this.genotypeParts.length) {
            AbstractVCFCodec.generateException("there are " + (n2 - 1) + " genotypes while the header requires that " + (this.genotypeParts.length - 1) + " genotypes be present for all records at " + string2 + ":" + n, this.lineNo);
        }
        ArrayList<Genotype> arrayList = new ArrayList<Genotype>(n2);
        List<String> list2 = ParsingUtils.split(this.genotypeParts[0], ':');
        Iterator<String> iterator = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        for (int i = 1; i < n2; ++i) {
            List<String> list3 = ParsingUtils.split(this.genotypeParts[i], ':');
            String string3 = iterator.next();
            GenotypeBuilder genotypeBuilder = new GenotypeBuilder(string3);
            if (list2.size() < list3.size()) {
                this.generateException("There are too many keys for the sample " + string3 + ", keys = " + this.parts[8] + ", values = " + this.parts[i]);
            }
            int n3 = -1;
            if (!list2.isEmpty()) {
                genotypeBuilder.maxAttributes(list2.size() - 1);
                for (int j = 0; j < list2.size(); ++j) {
                    boolean bl;
                    String string4 = list2.get(j);
                    boolean bl2 = bl = j >= list3.size();
                    if (string4.equals("GT")) {
                        n3 = j;
                        continue;
                    }
                    if (bl) continue;
                    if (string4.equals("FT")) {
                        List<String> list4 = this.parseFilters(this.getCachedString(list3.get(j)));
                        if (list4 == null) continue;
                        genotypeBuilder.filters(list4);
                        continue;
                    }
                    if (list3.get(j).equals(".")) continue;
                    if (string4.equals("GQ")) {
                        if (list3.get(j).equals("-1")) {
                            genotypeBuilder.noGQ();
                            continue;
                        }
                        genotypeBuilder.GQ((int)Math.round(Double.valueOf(list3.get(j))));
                        continue;
                    }
                    if (string4.equals("AD")) {
                        genotypeBuilder.AD(AbstractVCFCodec.decodeInts(list3.get(j)));
                        continue;
                    }
                    if (string4.equals("PL")) {
                        genotypeBuilder.PL(AbstractVCFCodec.decodeInts(list3.get(j)));
                        continue;
                    }
                    if (string4.equals("GL")) {
                        genotypeBuilder.PL(GenotypeLikelihoods.fromGLField(list3.get(j)).getAsPLs());
                        continue;
                    }
                    if (string4.equals("DP")) {
                        genotypeBuilder.DP(Integer.valueOf(list3.get(j)));
                        continue;
                    }
                    genotypeBuilder.attribute(string4, list3.get(j));
                }
            }
            if (!this.version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_1) && n3 == -1) {
                this.generateException("Unable to find the GT field for the record; the GT field is required before VCF4.1");
            }
            if (n3 > 0) {
                this.generateException("Saw GT field at position " + n3 + ", but it must be at the first position for genotypes when present");
            }
            ArrayList<Allele> arrayList2 = n3 == -1 ? new ArrayList<Allele>(0) : AbstractVCFCodec.parseGenotypeAlleles(list3.get(n3), list, this.alleleMap);
            genotypeBuilder.alleles(arrayList2);
            genotypeBuilder.phased(n3 != -1 && list3.get(n3).indexOf("|") != -1);
            try {
                arrayList.add(genotypeBuilder.make());
                continue;
            }
            catch (TribbleException tribbleException) {
                throw new TribbleException.InternalCodecException(tribbleException.getMessage() + ", at position " + string2 + ":" + n);
            }
        }
        return new LazyGenotypesContext.LazyData(arrayList, this.header.getSampleNamesInOrder(), this.header.getSampleNameToOffset());
    }

    private static final int[] decodeInts(String string) {
        List<String> list = ParsingUtils.split(string, ',');
        int[] nArray = new int[list.size()];
        try {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.parseInt(list.get(i));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    public final void disableOnTheFlyModifications() {
        this.doOnTheFlyModifications = false;
    }

    public void setRemappedSampleName(String string) {
        this.remappedSampleName = string;
    }

    protected void generateException(String string) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", this.lineNo, string));
    }

    protected static void generateException(String string, int n) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", n, string));
    }

    class LazyVCFGenotypesParser
    implements LazyGenotypesContext.LazyParser {
        final List<Allele> alleles;
        final String contig;
        final int start;

        LazyVCFGenotypesParser(List<Allele> list, String string, int n) {
            this.alleles = list;
            this.contig = string;
            this.start = n;
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object object) {
            return AbstractVCFCodec.this.createGenotypeMap((String)object, this.alleles, this.contig, this.start);
        }
    }
}

