/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFEncoder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class VCFRecordCodec
implements SortingCollection.Codec<VariantContext> {
    final VCFCodec vcfDecoder = new VCFCodec();
    final VCFEncoder vcfEncoder;
    private PrintStream outputStream = null;
    private BufferedReader inputReader = null;

    public VCFRecordCodec(VCFHeader vCFHeader) {
        this.vcfEncoder = new VCFEncoder(vCFHeader, false, false);
        this.vcfDecoder.setVCFHeader(vCFHeader, VCFHeaderVersion.VCF4_1);
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = new PrintStream(outputStream);
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    @Override
    public void encode(VariantContext variantContext) {
        this.outputStream.println(this.vcfEncoder.encode(variantContext));
    }

    @Override
    public VariantContext decode() {
        try {
            String string = this.inputReader.readLine();
            return string != null ? this.vcfDecoder.decode(string) : null;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Could not decode/read a VCF record for a sorting collection: " + iOException.getMessage(), iOException);
        }
    }

    public VCFRecordCodec clone() {
        return new VCFRecordCodec(this.vcfEncoder.getVCFHeader());
    }
}

