/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.utils.instrumentation;

import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.Accumulable;
import org.apache.spark.AccumulableParam;
import org.apache.spark.SparkContext;
import org.bdgenomics.utils.instrumentation.Alignment$;
import org.bdgenomics.utils.instrumentation.Clock;
import org.bdgenomics.utils.instrumentation.ConfigurableMonitor;
import org.bdgenomics.utils.instrumentation.InstrumentationFunctions$;
import org.bdgenomics.utils.instrumentation.Metrics;
import org.bdgenomics.utils.instrumentation.MetricsRecorder;
import org.bdgenomics.utils.instrumentation.MetricsRecorder$;
import org.bdgenomics.utils.instrumentation.RecordedTiming;
import org.bdgenomics.utils.instrumentation.ServoTimer;
import org.bdgenomics.utils.instrumentation.ServoTimer$;
import org.bdgenomics.utils.instrumentation.ServoTimers;
import org.bdgenomics.utils.instrumentation.ServoTimersAccumulableParam;
import org.bdgenomics.utils.instrumentation.StageTiming;
import org.bdgenomics.utils.instrumentation.TableHeader;
import org.bdgenomics.utils.instrumentation.TableHeader$;
import org.bdgenomics.utils.instrumentation.TimingPath;
import org.bdgenomics.utils.instrumentation.ValueExtractor;
import org.bdgenomics.utils.instrumentation.ValueExtractor$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

public final class Metrics$
implements Serializable {
    public static final Metrics$ MODULE$;
    private final ServoTimersAccumulableParam accumulableParam;
    private final String TreePathTagKey;
    private final String BlockingTagKey;
    private final String StageIdTagKey;
    private final Tag org$bdgenomics$utils$instrumentation$Metrics$$DriverTimeTag;
    private final Tag org$bdgenomics$utils$instrumentation$Metrics$$WorkerTimeTag;
    private final Tag org$bdgenomics$utils$instrumentation$Metrics$$StageDurationTag;
    private final AtomicInteger sequenceIdGenerator;
    private final DynamicVariable<Option<MetricsRecorder>> Recorder;

    static {
        new Metrics$();
    }

    private ServoTimersAccumulableParam accumulableParam() {
        return this.accumulableParam;
    }

    private final String TreePathTagKey() {
        return "TreePath";
    }

    private final String BlockingTagKey() {
        return "IsBlocking";
    }

    private final String StageIdTagKey() {
        return "StageId";
    }

    public final Tag org$bdgenomics$utils$instrumentation$Metrics$$DriverTimeTag() {
        return this.org$bdgenomics$utils$instrumentation$Metrics$$DriverTimeTag;
    }

    public final Tag org$bdgenomics$utils$instrumentation$Metrics$$WorkerTimeTag() {
        return this.org$bdgenomics$utils$instrumentation$Metrics$$WorkerTimeTag;
    }

    public final Tag org$bdgenomics$utils$instrumentation$Metrics$$StageDurationTag() {
        return this.org$bdgenomics$utils$instrumentation$Metrics$$StageDurationTag;
    }

    private AtomicInteger sequenceIdGenerator() {
        return this.sequenceIdGenerator;
    }

    public final DynamicVariable<Option<MetricsRecorder>> Recorder() {
        return this.Recorder;
    }

    public synchronized void initialize(SparkContext sparkContext) {
        Accumulable accumulable = sparkContext.accumulable((Object)new ServoTimers(), (AccumulableParam)this.accumulableParam());
        MetricsRecorder metricsRecorder = new MetricsRecorder((Accumulable<ServoTimers, RecordedTiming>)accumulable, MetricsRecorder$.MODULE$.$lessinit$greater$default$2());
        this.Recorder().value_$eq((Object)new Some((Object)metricsRecorder));
    }

    public void stopRecording() {
        this.Recorder().value_$eq((Object)None$.MODULE$);
    }

    public boolean isRecording() {
        return ((Option)this.Recorder().value()).isDefined();
    }

    public void print(PrintWriter out, Option<Seq<StageTiming>> sparkStageTimings) {
        if (((Option)this.Recorder().value()).isDefined()) {
            Accumulable<ServoTimers, RecordedTiming> accumulable = ((MetricsRecorder)((Option)this.Recorder().value()).get()).accumulable();
            Seq treeRoots = (Seq)this.buildTree(accumulable).toSeq().sortWith((Function2)new Serializable(){

                public final boolean apply(Metrics.TreeNode a, Metrics.TreeNode b) {
                    return a.timingPath().sequenceId() < b.timingPath().sequenceId();
                }
            });
            ArrayBuffer treeNodeRows = new ArrayBuffer();
            treeRoots.foreach((Function1)new Serializable(treeNodeRows){
                private final ArrayBuffer treeNodeRows$1;

                public final void apply(Metrics.TreeNode treeNode) {
                    treeNode.addToTable((Buffer<Monitor<?>>)this.treeNodeRows$1);
                }
                {
                    this.treeNodeRows$1 = treeNodeRows$1;
                }
            });
            InstrumentationFunctions$.MODULE$.renderTable(out, "Timings", (Seq<Monitor<?>>)treeNodeRows, (Seq<TableHeader>)this.createTreeViewHeader());
            out.println();
            sparkStageTimings.foreach((Function1)new Serializable(out, accumulable){
                private final PrintWriter out$1;
                private final Accumulable accumulable$1;

                public final void apply(Seq<StageTiming> x$1) {
                    Metrics$.MODULE$.org$bdgenomics$utils$instrumentation$Metrics$$printRddOperations(this.out$1, x$1, (Accumulable<ServoTimers, RecordedTiming>)this.accumulable$1);
                }
                {
                    this.out$1 = out$1;
                    this.accumulable$1 = accumulable$1;
                }
            });
            return;
        }
        throw new IllegalStateException("Trying to print metrics for an uninitialized Metrics class! Call the initialize method to initialize it.");
    }

    public int generateNewSequenceId() {
        return this.sequenceIdGenerator().incrementAndGet();
    }

    public void org$bdgenomics$utils$instrumentation$Metrics$$printRddOperations(PrintWriter out, Seq<StageTiming> sparkStageTimings, Accumulable<ServoTimers, RecordedTiming> accumulable) {
        List sortedRddOperations = (List)((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaConcurrentMap(((ServoTimers)accumulable.value()).timerMap()).filter((Function1)new Serializable(){

            public final boolean apply(Tuple2<TimingPath, ServoTimer> x$2) {
                return ((TimingPath)x$2._1()).isRDDOperation();
            }
        })).toList().sortBy((Function1)new Serializable(){

            public final int apply(Tuple2<TimingPath, ServoTimer> x$3) {
                return ((TimingPath)x$3._1()).sequenceId();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Map stageMap = ((TraversableOnce)sparkStageTimings.map((Function1)new Serializable(){

            public final Tuple2<Option<String>, StageTiming> apply(StageTiming t) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t.stageName()), (Object)t);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        List rddMonitors = (List)sortedRddOperations.map((Function1)new Serializable(stageMap){
            private final Map stageMap$1;

            public final BasicCompositeMonitor apply(Tuple2<TimingPath, ServoTimer> rddOperation) {
                String name = ((ConfigurableMonitor)rddOperation._2()).getName();
                Option stageOption = this.stageMap$1.get((Object)new Some((Object)name));
                ArrayBuffer durationMonitors = new ArrayBuffer();
                MonitorConfig.Builder monitorConfig = MonitorConfig.builder((String)name).withTag("name", name).withTag("IsBlocking", ((Object)BoxesRunTime.boxToBoolean((boolean)stageOption.isDefined())).toString());
                stageOption.foreach((Function1)new Serializable(this, name, durationMonitors, monitorConfig){
                    private final String name$1;
                    private final ArrayBuffer durationMonitors$1;
                    private final MonitorConfig.Builder monitorConfig$1;

                    public final MonitorConfig.Builder apply(StageTiming stage) {
                        LongGauge durationGauge = new LongGauge(MonitorConfig.builder((String)this.name$1).withTag(Metrics$.MODULE$.org$bdgenomics$utils$instrumentation$Metrics$$StageDurationTag()).build());
                        durationGauge.set(Predef$.MODULE$.long2Long(stage.duration().toNanos()));
                        this.durationMonitors$1.$plus$eq((Object)durationGauge);
                        return this.monitorConfig$1.withTag("StageId", ((Object)BoxesRunTime.boxToInteger((int)stage.stageId())).toString());
                    }
                    {
                        this.name$1 = name$1;
                        this.durationMonitors$1 = durationMonitors$1;
                        this.monitorConfig$1 = monitorConfig$1;
                    }
                });
                return new BasicCompositeMonitor(monitorConfig.build(), JavaConversions$.MODULE$.bufferAsJavaList((Buffer)durationMonitors));
            }
            {
                this.stageMap$1 = stageMap$1;
            }
        }, List$.MODULE$.canBuildFrom());
        InstrumentationFunctions$.MODULE$.renderTable(out, "Spark Operations", (Seq<Monitor<?>>)rddMonitors, (Seq<TableHeader>)this.createRDDOperationsHeader());
    }

    private ArrayBuffer<TableHeader> createRDDOperationsHeader() {
        TableHeader[] tableHeaderArray = new TableHeader[4];
        String x$7 = "Operation";
        ValueExtractor x$8 = ValueExtractor$.MODULE$.forTagValueWithKey("name");
        Enumeration.Value x$9 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$10 = TableHeader$.MODULE$.apply$default$3();
        tableHeaderArray[0] = new TableHeader(x$7, x$8, x$10, x$9);
        String x$11 = "Is Blocking?";
        ValueExtractor x$12 = ValueExtractor$.MODULE$.forTagValueWithKey("IsBlocking");
        Enumeration.Value x$13 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$14 = TableHeader$.MODULE$.apply$default$3();
        tableHeaderArray[1] = new TableHeader(x$11, x$12, x$14, x$13);
        tableHeaderArray[2] = new TableHeader("Duration", ValueExtractor$.MODULE$.forMonitorMatchingTag(this.org$bdgenomics$utils$instrumentation$Metrics$$StageDurationTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(){

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        String x$15 = "Stage ID";
        ValueExtractor x$16 = ValueExtractor$.MODULE$.forTagValueWithKey("StageId");
        Enumeration.Value x$17 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$18 = TableHeader$.MODULE$.apply$default$3();
        tableHeaderArray[3] = new TableHeader(x$15, x$16, x$18, x$17);
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tableHeaderArray));
    }

    private ArrayBuffer<TableHeader> createTreeViewHeader() {
        TableHeader[] tableHeaderArray = new TableHeader[7];
        String x$19 = "Metric";
        ValueExtractor x$20 = ValueExtractor$.MODULE$.forTagValueWithKey("TreePath");
        Enumeration.Value x$21 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$22 = TableHeader$.MODULE$.apply$default$3();
        tableHeaderArray[0] = new TableHeader(x$19, x$20, x$22, x$21);
        tableHeaderArray[1] = new TableHeader("Worker Time", ValueExtractor$.MODULE$.forMonitorMatchingTag(this.org$bdgenomics$utils$instrumentation$Metrics$$WorkerTimeTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(){

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[2] = new TableHeader("Driver Time", ValueExtractor$.MODULE$.forMonitorMatchingTag(this.org$bdgenomics$utils$instrumentation$Metrics$$DriverTimeTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(){

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[3] = new TableHeader("Count", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.CountTag()), TableHeader$.MODULE$.apply$default$3(), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[4] = new TableHeader("Mean", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MeanTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(){

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[5] = new TableHeader("Min", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MinTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(){

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[6] = new TableHeader("Max", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MaxTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(){

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tableHeaderArray));
    }

    private Iterable<Metrics.TreeNode> buildTree(Accumulable<ServoTimers, RecordedTiming> accumulable) {
        Seq timerPaths = JavaConversions$.MODULE$.mapAsScalaConcurrentMap(((ServoTimers)accumulable.value()).timerMap()).toSeq();
        LinkedHashMap rootNodes = new LinkedHashMap();
        this.buildTree((Seq<Tuple2<TimingPath, ServoTimer>>)timerPaths, 0, (scala.collection.mutable.Map<TimingPath, Metrics.TreeNode>)rootNodes);
        return rootNodes.values();
    }

    /*
     * WARNING - void declaration
     */
    private void buildTree(Seq<Tuple2<TimingPath, ServoTimer>> timerPaths, int depth, scala.collection.mutable.Map<TimingPath, Metrics.TreeNode> parentNodes) {
        while (true) {
            void var5_4;
            HashMap currentLevelNodes = new HashMap();
            ((IterableLike)timerPaths.filter((Function1)new Serializable(depth){
                private final int depth$1;

                public final boolean apply(Tuple2<TimingPath, ServoTimer> x$4) {
                    return ((TimingPath)x$4._1()).depth() == this.depth$1;
                }
                {
                    this.depth$1 = depth$1;
                }
            })).foreach((Function1)new Serializable(parentNodes, currentLevelNodes){
                private final scala.collection.mutable.Map parentNodes$1;
                private final HashMap currentLevelNodes$1;

                public final Object apply(Tuple2<TimingPath, ServoTimer> timerPath) {
                    return Metrics$.MODULE$.org$bdgenomics$utils$instrumentation$Metrics$$addToMaps(timerPath, (scala.collection.mutable.Map<TimingPath, Metrics.TreeNode>)this.parentNodes$1, (scala.collection.mutable.Map<TimingPath, Metrics.TreeNode>)this.currentLevelNodes$1);
                }
                {
                    this.parentNodes$1 = parentNodes$1;
                    this.currentLevelNodes$1 = currentLevelNodes$1;
                }
            });
            if (currentLevelNodes.isEmpty()) {
                return;
            }
            parentNodes = var5_4;
            ++depth;
        }
    }

    public Object org$bdgenomics$utils$instrumentation$Metrics$$addToMaps(Tuple2<TimingPath, ServoTimer> timerPath, scala.collection.mutable.Map<TimingPath, Metrics.TreeNode> parents, scala.collection.mutable.Map<TimingPath, Metrics.TreeNode> currentLevelNodes) {
        BoxedUnit boxedUnit;
        Option<TimingPath> parentPath = ((TimingPath)timerPath._1()).parentPath();
        if (parentPath.isDefined()) {
            parents.get(parentPath.get()).foreach((Function1)new Serializable(timerPath, currentLevelNodes){
                private final Tuple2 timerPath$1;
                private final scala.collection.mutable.Map currentLevelNodes$2;

                public final Option<Metrics.TreeNode> apply(Metrics.TreeNode parentNode) {
                    Metrics.TreeNode node = new Metrics.TreeNode((Tuple2<TimingPath, ServoTimer>)this.timerPath$1, (Option<Metrics.TreeNode>)new Some((Object)parentNode));
                    parentNode.addChild(node);
                    return this.currentLevelNodes$2.put(this.timerPath$1._1(), (Object)node);
                }
                {
                    this.timerPath$1 = timerPath$1;
                    this.currentLevelNodes$2 = currentLevelNodes$2;
                }
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Metrics.TreeNode node = new Metrics.TreeNode(timerPath, (Option<Metrics.TreeNode>)None$.MODULE$);
            parents.put((Object)node.timingPath(), (Object)node);
            boxedUnit = currentLevelNodes.put(timerPath._1(), (Object)node);
        }
        return boxedUnit;
    }

    public Clock $lessinit$greater$default$1() {
        return new Clock();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Metrics$() {
        MODULE$ = this;
        this.accumulableParam = new ServoTimersAccumulableParam();
        this.org$bdgenomics$utils$instrumentation$Metrics$$DriverTimeTag = Tags.newTag((String)"statistic", (String)"DriverTime");
        this.org$bdgenomics$utils$instrumentation$Metrics$$WorkerTimeTag = Tags.newTag((String)"statistic", (String)"WorkerTime");
        this.org$bdgenomics$utils$instrumentation$Metrics$$StageDurationTag = Tags.newTag((String)"statistic", (String)"StageDuration");
        this.sequenceIdGenerator = new AtomicInteger();
        this.Recorder = new DynamicVariable((Object)None$.MODULE$);
    }
}

