/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.cli.Fasta2ADAM$;
import org.bdgenomics.adam.cli.Fasta2ADAMArgs;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.formats.avro.NucleotideContigFragment;
import org.bdgenomics.utils.cli.BDGCommand;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00015<Q!\u0001\u0002\t\u0002-\t!BR1ti\u0006\u0014\u0014\tR!N\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!A\u0003$bgR\f''\u0011#B\u001bN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t92$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u001b\r\u0005)Q\u000f^5mg&\u0011A\u0004\u0007\u0002\u0014\u0005\u0012;5i\\7nC:$7i\\7qC:LwN\u001c\u0005\u0006=5!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-Aq!I\u0007C\u0002\u0013\u0005!%A\u0006d_6l\u0017M\u001c3OC6,W#A\u0012\u0011\u0005\u0011:cBA\t&\u0013\t1##\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014\u0013\u0011\u0019YS\u0002)A\u0005G\u0005a1m\\7nC:$g*Y7fA!9Q&\u0004b\u0001\n\u0003\u0011\u0013AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:DaaL\u0007!\u0002\u0013\u0019\u0013aE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\"B\u0019\u000e\t\u0003\u0011\u0014!B1qa2LHCA\u001a7!\t9B'\u0003\u000261\tQ!\tR$D_6l\u0017M\u001c3\t\u000b]\u0002\u0004\u0019\u0001\u001d\u0002\u000f\rlG\rT5oKB\u0019\u0011#O\u0012\n\u0005i\u0012\"!B!se\u0006Lh\u0001\u0002\b\u0003\u0001q\u001aBaO\u001fF\u0017B\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005Y\u0006twMC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$AB(cU\u0016\u001cG\u000fE\u0002\u0018\r\"K!a\u0012\r\u0003\u001f\t#ui\u00159be.\u001cu.\\7b]\u0012\u0004\"\u0001D%\n\u0005)\u0013!A\u0004$bgR\f''\u0011#B\u001b\u0006\u0013xm\u001d\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bQa\u001d9be.T!\u0001\u0015\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u0011VJA\u0004M_\u001e<\u0017N\\4\t\u0011Q[$Q1A\u0005\u0012U\u000bA!\u0019:hgV\t\u0001\n\u0003\u0005Xw\t\u0005\t\u0015!\u0003I\u0003\u0015\t'oZ:!\u0011\u0015q2\b\"\u0001Z)\tQ6\f\u0005\u0002\rw!)A\u000b\u0017a\u0001\u0011\"9Ql\u000fb\u0001\n\u0003q\u0016!C2p[B\fg.[8o+\u0005yfB\u0001\u0007\u0001\u0011\u0019\t7\b)A\u0005?\u0006Q1m\\7qC:LwN\u001c\u0011\t\u000b\r\\D\u0011\u00013\u0002\u0007I,h\u000e\u0006\u0002fQB\u0011\u0011CZ\u0005\u0003OJ\u0011A!\u00168ji\")\u0011N\u0019a\u0001U\u0006\u00111o\u0019\t\u0003\u0019.L!\u0001\\'\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;")
public class Fasta2ADAM
implements BDGSparkCommand<Fasta2ADAMArgs>,
Logging {
    private final Fasta2ADAMArgs args;
    private final Fasta2ADAM$ companion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        Fasta2ADAM$.MODULE$.main(stringArray);
    }

    public static BDGCommand apply(String[] stringArray) {
        return Fasta2ADAM$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return Fasta2ADAM$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Fasta2ADAM$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Fasta2ADAMArgs args() {
        return this.args;
    }

    public Fasta2ADAM$ companion() {
        return this.companion;
    }

    public void run(SparkContext sc) {
        RDD rDD;
        this.log().info("Loading FASTA data from disk.");
        RDD adamFasta = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFasta(this.args().fastaFile(), this.args().fragmentLength());
        if (this.args().verbose()) {
            Predef$.MODULE$.println((Object)"FASTA contains:");
            Predef$.MODULE$.println((Object)ADAMContext$.MODULE$.rddToContigFragmentRDD(adamFasta).adamGetSequenceDictionary());
        }
        this.log().info("Writing records to disk.");
        if (this.args().partitions() > 0) {
            int x$1 = this.args().partitions();
            Ordering x$2 = adamFasta.repartition$default$2(x$1);
            rDD = adamFasta.repartition(x$1, x$2);
        } else {
            rDD = adamFasta;
        }
        RDD finalFasta = rDD;
        ADAMContext$.MODULE$.rddToADAMRDD(finalFasta, (Function1)Predef$.MODULE$.$conforms(), ManifestFactory$.MODULE$.classType(NucleotideContigFragment.class)).adamParquetSave((SaveArgs)this.args());
    }

    public Fasta2ADAM(Fasta2ADAMArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = Fasta2ADAM$.MODULE$;
    }
}

