/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.io;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bdgenomics.adam.io.BAMFilteredRecordReader$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055u!B\u0001\u0003\u0011\u0003Y\u0011a\u0006\"B\u001b\u001aKG\u000e^3sK\u0012\u0014VmY8sIJ+\u0017\rZ3s\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005C\u0012\fWN\u0003\u0002\b\u0011\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011qCQ!N\r&dG/\u001a:fIJ+7m\u001c:e%\u0016\fG-\u001a:\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9!$\u0004a\u0001\n\u0013Y\u0012!D8qiZKWm\u001e*fO&|g.F\u0001\u001d!\r\tRdH\u0005\u0003=I\u0011aa\u00149uS>t\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\u0019iw\u000eZ3mg&\u0011A%\t\u0002\u0010%\u00164WM]3oG\u0016\u0014VmZ5p]\"9a%\u0004a\u0001\n\u00139\u0013!E8qiZKWm\u001e*fO&|gn\u0018\u0013fcR\u0011\u0001f\u000b\t\u0003#%J!A\u000b\n\u0003\tUs\u0017\u000e\u001e\u0005\bY\u0015\n\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\u0007]5\u0001\u000b\u0015\u0002\u000f\u0002\u001d=\u0004HOV5foJ+w-[8oA!)\u0001'\u0004C\u0001c\u0005I1/\u001a;SK\u001eLwN\u001c\u000b\u0003QIBQaM\u0018A\u0002}\t!B^5foJ+w-[8o\r\u0011q!\u0001A\u001b\u0014\u0005Q2\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003)A\u0017\rZ8pa~\u0013\u0017-\u001c\u0006\u0003w!\tqa]3rI>|\u0007/\u0003\u0002>q\ty!)Q'SK\u000e|'\u000f\u001a*fC\u0012,'\u000fC\u0003\u0018i\u0011\u0005q\bF\u0001A!\taA\u0007C\u0004Ci\t\u0007I\u0011A\"\u0002\u0007-,\u00170F\u0001E!\t)5*D\u0001G\u0015\t\u0019qI\u0003\u0002I\u0013\u00061\u0001.\u00193p_BT!A\u0013\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\taeI\u0001\u0007M_:<wK]5uC\ndW\r\u0003\u0004Oi\u0001\u0006I\u0001R\u0001\u0005W\u0016L\b\u0005C\u0004Qi\t\u0007I\u0011A)\u0002\rI,7m\u001c:e+\u0005\u0011\u0006CA\u001cT\u0013\t!\u0006HA\tT\u00036\u0013VmY8sI^\u0013\u0018\u000e^1cY\u0016DaA\u0016\u001b!\u0002\u0013\u0011\u0016a\u0002:fG>\u0014H\r\t\u0005\n1R\u0002\r\u00111A\u0005\u0002e\u000b!b\u001d;sS:<WM\\2z+\u0005Q\u0006CA.a\u001b\u0005a&BA/_\u0003!\u0019\u0018-\u001c;p_2\u001c(\"A0\u0002\r!$8O\u001b3l\u0013\t\tGL\u0001\u000bWC2LG-\u0019;j_:\u001cFO]5oO\u0016t7-\u001f\u0005\nGR\u0002\r\u00111A\u0005\u0002\u0011\fab\u001d;sS:<WM\\2z?\u0012*\u0017\u000f\u0006\u0002)K\"9AFYA\u0001\u0002\u0004Q\u0006BB45A\u0003&!,A\u0006tiJLgnZ3oGf\u0004\u0003\"C55\u0001\u0004\u0005\r\u0011\"\u0001k\u0003\r\u00117-[\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011a\u000eX\u0001\u0005kRLG.\u0003\u0002q[\nQ\"\t\\8dW\u000e{W\u000e\u001d:fgN,G-\u00138qkR\u001cFO]3b[\"I!\u000f\u000ea\u0001\u0002\u0004%\ta]\u0001\bE\u000eLw\fJ3r)\tAC\u000fC\u0004-c\u0006\u0005\t\u0019A6\t\rY$\u0004\u0015)\u0003l\u0003\u0011\u00117-\u001b\u0011\t\u0013a$\u0004\u0019!a\u0001\n\u0003I\u0018!B2pI\u0016\u001cW#\u0001>\u0011\u0005m[\u0018B\u0001?]\u00059\u0011\u0015)\u0014*fG>\u0014HmQ8eK\u000eD\u0011B \u001bA\u0002\u0003\u0007I\u0011A@\u0002\u0013\r|G-Z2`I\u0015\fHc\u0001\u0015\u0002\u0002!9A&`A\u0001\u0002\u0004Q\bbBA\u0003i\u0001\u0006KA_\u0001\u0007G>$Wm\u0019\u0011\t\u0017\u0005%A\u00071AA\u0002\u0013\u0005\u00111B\u0001\nM&dWm\u0015;beR,\"!!\u0004\u0011\u0007E\ty!C\u0002\u0002\u0012I\u0011A\u0001T8oO\"Y\u0011Q\u0003\u001bA\u0002\u0003\u0007I\u0011AA\f\u000351\u0017\u000e\\3Ti\u0006\u0014Ho\u0018\u0013fcR\u0019\u0001&!\u0007\t\u00131\n\u0019\"!AA\u0002\u00055\u0001\u0002CA\u000fi\u0001\u0006K!!\u0004\u0002\u0015\u0019LG.Z*uCJ$\b\u0005C\u0006\u0002\"Q\u0002\r\u00111A\u0005\u0002\u0005-\u0011A\u0003<jeR,\u0018\r\\#oI\"Y\u0011Q\u0005\u001bA\u0002\u0003\u0007I\u0011AA\u0014\u000391\u0018N\u001d;vC2,e\u000eZ0%KF$2\u0001KA\u0015\u0011%a\u00131EA\u0001\u0002\u0004\ti\u0001\u0003\u0005\u0002.Q\u0002\u000b\u0015BA\u0007\u0003-1\u0018N\u001d;vC2,e\u000e\u001a\u0011\t\u0013\u0005EB\u00071A\u0005\u0002\u0005M\u0012!D5t\u0013:LG/[1mSj,G-\u0006\u0002\u00026A\u0019\u0011#a\u000e\n\u0007\u0005e\"CA\u0004C_>dW-\u00198\t\u0013\u0005uB\u00071A\u0005\u0002\u0005}\u0012!E5t\u0013:LG/[1mSj,Gm\u0018\u0013fcR\u0019\u0001&!\u0011\t\u00131\nY$!AA\u0002\u0005U\u0002\u0002CA#i\u0001\u0006K!!\u000e\u0002\u001d%\u001c\u0018J\\5uS\u0006d\u0017N_3eA!9\u0011\u0011\n\u001b\u0005B\u0005-\u0013AC5oSRL\u0017\r\\5{KR)\u0001&!\u0014\u0002^!A\u0011qJA$\u0001\u0004\t\t&A\u0002ta2\u0004B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/:\u0015!C7baJ,G-^2f\u0013\u0011\tY&!\u0016\u0003\u0015%s\u0007/\u001e;Ta2LG\u000f\u0003\u0005\u0002`\u0005\u001d\u0003\u0019AA1\u0003\r\u0019G\u000f\u001f\t\u0005\u0003'\n\u0019'\u0003\u0003\u0002f\u0005U#A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRDq!!\u001b5\t\u0003\nY'A\u0003dY>\u001cX\rF\u0001)\u0011\u001d\ty\u0007\u000eC!\u0003c\nQbZ3u\u0007V\u0014(/\u001a8u\u0017\u0016LH#\u0001#\t\u000f\u0005UD\u0007\"\u0011\u0002x\u0005yq-\u001a;DkJ\u0014XM\u001c;WC2,X\rF\u0001S\u0011\u001d\tY\b\u000eC#\u0003{\nAB\\3yi.+\u0017PV1mk\u0016$\"!!\u000e)\t\u0005e\u0014\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0006\u0015%a\u0002;bS2\u0014Xm\u0019")
public class BAMFilteredRecordReader
extends BAMRecordReader {
    private final LongWritable key = new LongWritable();
    private final SAMRecordWritable record = new SAMRecordWritable();
    private ValidationStringency stringency;
    private BlockCompressedInputStream bci;
    private BAMRecordCodec codec;
    private long fileStart;
    private long virtualEnd;
    private boolean isInitialized = false;

    public static void setRegion(ReferenceRegion referenceRegion) {
        BAMFilteredRecordReader$.MODULE$.setRegion(referenceRegion);
    }

    public LongWritable key() {
        return this.key;
    }

    public SAMRecordWritable record() {
        return this.record;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    public void stringency_$eq(ValidationStringency x$1) {
        this.stringency = x$1;
    }

    public BlockCompressedInputStream bci() {
        return this.bci;
    }

    public void bci_$eq(BlockCompressedInputStream x$1) {
        this.bci = x$1;
    }

    public BAMRecordCodec codec() {
        return this.codec;
    }

    public void codec_$eq(BAMRecordCodec x$1) {
        this.codec = x$1;
    }

    public long fileStart() {
        return this.fileStart;
    }

    public void fileStart_$eq(long x$1) {
        this.fileStart = x$1;
    }

    public long virtualEnd() {
        return this.virtualEnd;
    }

    public void virtualEnd_$eq(long x$1) {
        this.virtualEnd = x$1;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) {
        if (this.isInitialized()) {
            this.close();
        }
        this.isInitialized_$eq(true);
        Configuration conf = ContextUtil.getConfiguration((JobContext)ctx);
        FileVirtualSplit split = (FileVirtualSplit)spl;
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(conf);
        this.stringency_$eq(SAMHeaderReader.getValidationStringency((Configuration)conf));
        FSDataInputStream in = fs.open(file);
        this.codec_$eq(new BAMRecordCodec(SAMHeaderReader.readSAMHeaderFrom((InputStream)in, (Configuration)conf)));
        in.seek(0L);
        this.bci_$eq(new BlockCompressedInputStream((SeekableStream)new WrapSeekable((InputStream)in, fs.getFileStatus(file).getLen(), file)));
        long virtualStart = split.getStartVirtualOffset();
        this.fileStart_$eq(virtualStart >>> 16);
        this.virtualEnd_$eq(split.getEndVirtualOffset());
        this.bci().seek(virtualStart);
        this.codec().setInputStream((InputStream)this.bci());
    }

    public void close() {
        this.bci().close();
    }

    public LongWritable getCurrentKey() {
        return this.key();
    }

    public SAMRecordWritable getCurrentValue() {
        return this.record();
    }

    public final boolean nextKeyValue() {
        boolean bl;
        block4: {
            SAMRecord r;
            while (true) {
                if (this.bci().getFilePointer() >= this.virtualEnd()) {
                    bl = false;
                    break block4;
                }
                r = this.codec().decode();
                if (this.stringency() != null) {
                    r.setValidationStringency(this.stringency());
                }
                if (r == null) {
                    bl = false;
                    break block4;
                }
                int start = r.getStart();
                int end = r.getEnd();
                ReferenceRegion refReg = (ReferenceRegion)BAMFilteredRecordReader$.MODULE$.org$bdgenomics$adam$io$BAMFilteredRecordReader$$optViewRegion().get();
                long regStart = refReg.start();
                long regEnd = refReg.end();
                String string = r.getContig();
                String string2 = refReg.referenceName();
                if (string != null ? !string.equals(string2) : string2 != null) continue;
                if ((long)start >= regStart && (long)end <= regEnd || (long)start <= regStart && (long)end >= regStart && (long)end <= regEnd || (long)end >= regEnd && (long)start >= regStart && (long)start <= regEnd) break;
            }
            this.key().set(BAMRecordReader.getKey((SAMRecord)r));
            this.record().set(r);
            bl = true;
        }
        return bl;
    }
}

