/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import htsjdk.samtools.SAMRecord;
import java.util.regex.Matcher;
import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.TagType$;
import org.bdgenomics.adam.util.RegExp;
import org.bdgenomics.adam.util.RegExp$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class AttributeUtils$ {
    public static final AttributeUtils$ MODULE$;
    private final RegExp attrRegex;

    static {
        new AttributeUtils$();
    }

    public RegExp attrRegex() {
        return this.attrRegex;
    }

    public Attribute convertSAMTagAndValue(SAMRecord.SAMTagAndValue attr) {
        Object object;
        block7: {
            Attribute attribute;
            block3: {
                Object object2;
                Option option;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = attr.value;
                                if (!(object instanceof Integer)) break block2;
                                attribute = new Attribute(attr.tag, (Enumeration.Value)TagType$.MODULE$.Integer(), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)attr.value)));
                                break block3;
                            }
                            if (!(object instanceof Character)) break block4;
                            attribute = new Attribute(attr.tag, (Enumeration.Value)TagType$.MODULE$.Character(), BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)attr.value)));
                            break block3;
                        }
                        if (!(object instanceof Float)) break block5;
                        attribute = new Attribute(attr.tag, (Enumeration.Value)TagType$.MODULE$.Float(), BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)attr.value)));
                        break block3;
                    }
                    if (!(object instanceof String)) break block6;
                    attribute = new Attribute(attr.tag, (Enumeration.Value)TagType$.MODULE$.String(), (String)attr.value);
                    break block3;
                }
                if (!ScalaRunTime$.MODULE$.isArray(object, 1) || (option = Array$.MODULE$.unapplySeq(object2 = object)).isEmpty()) break block7;
                attribute = new Attribute(attr.tag, (Enumeration.Value)TagType$.MODULE$.ByteSequence(), (Byte[])attr.value);
            }
            return attribute;
        }
        throw new MatchError(object);
    }

    public Seq<Attribute> parseAttributes(String tagStrings) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tagStrings.split("\t")).filter((Function1)new Serializable(){

            public final boolean apply(String x$1) {
                return x$1.length() > 0;
            }
        })).map((Function1)new Serializable(){

            public final Attribute apply(String encoded) {
                return AttributeUtils$.MODULE$.parseAttribute(encoded);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Attribute parseAttribute(String encoded) {
        Option<Matcher> option = this.attrRegex().matches(encoded);
        if (option instanceof Some) {
            Some some = (Some)option;
            Matcher m = (Matcher)some.x();
            Attribute attribute = this.createAttribute((Tuple3<String, String, String>)new Tuple3((Object)m.group(1), (Object)m.group(2), (Object)m.group(3)));
            return attribute;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("attribute string \"%s\" doesn't match format attrTuple:type:value")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encoded})));
        }
        throw new MatchError(option);
    }

    private Attribute createAttribute(Tuple3<String, String, String> attrTuple) {
        String string;
        block8: {
            Enumeration.Val val;
            String valueStr;
            String tagName;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    tagName = (String)attrTuple._1();
                                    String tagTypeString = (String)attrTuple._2();
                                    valueStr = (String)attrTuple._3();
                                    string = tagTypeString;
                                    if (!"A".equals(string)) break block2;
                                    val = TagType$.MODULE$.Character();
                                    break block3;
                                }
                                if (!"i".equals(string)) break block4;
                                val = TagType$.MODULE$.Integer();
                                break block3;
                            }
                            if (!"f".equals(string)) break block5;
                            val = TagType$.MODULE$.Float();
                            break block3;
                        }
                        if (!"Z".equals(string)) break block6;
                        val = TagType$.MODULE$.String();
                        break block3;
                    }
                    if (!"H".equals(string)) break block7;
                    val = TagType$.MODULE$.ByteSequence();
                    break block3;
                }
                if (!"B".equals(string)) break block8;
                val = TagType$.MODULE$.NumericSequence();
            }
            Enumeration.Val tagType = val;
            return new Attribute(tagName, (Enumeration.Value)tagType, this.typedStringToValue((Enumeration.Value)tagType, valueStr));
        }
        throw new MatchError((Object)string);
    }

    private Object typedStringToValue(Enumeration.Value tagType, String valueStr) {
        Enumeration.Value value;
        block8: {
            Object object;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    value = tagType;
                                    Enumeration.Val val = TagType$.MODULE$.Character();
                                    Enumeration.Value value2 = value;
                                    if (val != null ? !val.equals(value2) : value2 != null) break block2;
                                    object = BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(valueStr), 0));
                                    break block3;
                                }
                                Enumeration.Val val = TagType$.MODULE$.Integer();
                                Enumeration.Value value3 = value;
                                if (val != null ? !val.equals(value3) : value3 != null) break block4;
                                object = Integer.valueOf(valueStr);
                                break block3;
                            }
                            Enumeration.Val val = TagType$.MODULE$.Float();
                            Enumeration.Value value4 = value;
                            if (val != null ? !val.equals(value4) : value4 != null) break block5;
                            object = Float.valueOf(valueStr);
                            break block3;
                        }
                        Enumeration.Val val = TagType$.MODULE$.String();
                        Enumeration.Value value5 = value;
                        if (val != null ? !val.equals(value5) : value5 != null) break block6;
                        object = valueStr;
                        break block3;
                    }
                    Enumeration.Val val = TagType$.MODULE$.ByteSequence();
                    Enumeration.Value value6 = value;
                    if (val != null ? !val.equals(value6) : value6 != null) break block7;
                    object = new StringOps(Predef$.MODULE$.augmentString(valueStr)).map((Function1)new Serializable(){

                        public final Byte apply(char c) {
                            return Byte.valueOf(String.valueOf(BoxesRunTime.boxToCharacter((char)c)));
                        }
                    }, Predef$.MODULE$.fallbackStringCanBuildFrom());
                    break block3;
                }
                Enumeration.Val val = TagType$.MODULE$.NumericSequence();
                Enumeration.Value value7 = value;
                if (val != null ? !val.equals(value7) : value7 != null) break block8;
                object = Predef$.MODULE$.refArrayOps((Object[])valueStr.substring(2).split(",")).map((Function1)new Serializable(){

                    public final Number apply(String c) {
                        return c.contains(".") ? (Number)Float.valueOf(c) : (Number)Integer.valueOf(c);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Number.class)));
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private AttributeUtils$() {
        MODULE$ = this;
        this.attrRegex = RegExp$.MODULE$.apply("([^:]{2,4}):([AifZHB]):(.*)");
    }
}

