/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.SAMFileHeader;

class LazyBAMRecord
extends BAMRecord {
    private boolean decodedRefIdx = false;
    private boolean decodedMateRefIdx = false;

    public LazyBAMRecord(SAMFileHeader hdr, int referenceID, int coordinate, short readNameLength, short mappingQuality, int indexingBin, int cigarLen, int flags, int readLen, int mateReferenceID, int mateCoordinate, int insertSize, byte[] restOfData) {
        super(hdr, referenceID, coordinate, readNameLength, mappingQuality, indexingBin, cigarLen, flags, readLen, mateReferenceID, mateCoordinate, insertSize, restOfData);
    }

    public void setReferenceIndex(int referenceIndex) {
        this.mReferenceIndex = referenceIndex;
        this.decodedRefIdx = false;
    }

    public void setMateReferenceIndex(int referenceIndex) {
        this.mMateReferenceIndex = referenceIndex;
        this.decodedMateRefIdx = false;
    }

    public String getReferenceName() {
        if (this.mReferenceIndex != null && !this.decodedRefIdx) {
            this.decodedRefIdx = true;
            super.setReferenceIndex(this.mReferenceIndex.intValue());
        }
        return super.getReferenceName();
    }

    public String getMateReferenceName() {
        if (this.mMateReferenceIndex != null && !this.decodedMateRefIdx) {
            this.decodedMateRefIdx = true;
            super.setMateReferenceIndex(this.mMateReferenceIndex.intValue());
        }
        return super.getMateReferenceName();
    }

    protected void eagerDecode() {
        this.getReferenceName();
        this.getMateReferenceName();
        super.eagerDecode();
    }
}

