/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.algorithms.consensus;

import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.IndelTable;
import org.bdgenomics.adam.models.IndelTable$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.read.realignment.IndelRealignmentTarget;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.formats.avro.Variant;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001b\ta2i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\rJ|Wn\u00138po:\u001c(BA\u0002\u0005\u0003%\u0019wN\\:f]N,8O\u0003\u0002\u0006\r\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005\u001dA\u0011\u0001B1eC6T!!\u0003\u0006\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u00112i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012\u0001\u00024jY\u0016\u0004\"!F\u000e\u000f\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0002\rA\u0013X\rZ3g\u0013\taRD\u0001\u0004TiJLgn\u001a\u0006\u00035]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0003g\u000e\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0015R\u0011AB1qC\u000eDW-\u0003\u0002(E\ta1\u000b]1sW\u000e{g\u000e^3yi\"\u0012a$\u000b\t\u0003-)J!aK\f\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u00020aE\u0002\"a\u0004\u0001\t\u000bMa\u0003\u0019\u0001\u000b\t\u000b}a\u0003\u0019\u0001\u0011\t\u000fM\u0002!\u0019!C\u0001i\u0005Q\u0011N\u001c3fYR\u000b'\r\\3\u0016\u0003U\u00022AN\u001d<\u001b\u00059$B\u0001\u001d#\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0002;o\tI!I]8bI\u000e\f7\u000f\u001e\t\u0003y}j\u0011!\u0010\u0006\u0003}\u0019\ta!\\8eK2\u001c\u0018B\u0001!>\u0005)Ie\u000eZ3m)\u0006\u0014G.\u001a\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001b\u0002\u0017%tG-\u001a7UC\ndW\r\t\u0005\u0006\t\u0002!\t!R\u0001\ri\u0006\u0014x-\u001a;t)>\fE\r\u001a\u000b\u0002\rB\u0019acR%\n\u0005!;\"AB(qi&|g\u000eE\u0002K\u001b>k\u0011a\u0013\u0006\u0003\u0019\n\n1A\u001d3e\u0013\tq5JA\u0002S\t\u0012\u0003\"\u0001\u0015,\u000e\u0003ES!AU*\u0002\u0017I,\u0017\r\\5h]6,g\u000e\u001e\u0006\u0003)V\u000bAA]3bI*\u0011AJB\u0005\u0003/F\u0013a#\u00138eK2\u0014V-\u00197jO:lWM\u001c;UCJ<W\r\u001e\u0005\u00063\u0002!\tAW\u0001\u001eaJ,\u0007O]8dKN\u001c(+Z1eg\u001a{'OU3bY&<g.\\3oiR!1,\\8r!\raFm\u001a\b\u0003;\nt!AX1\u000e\u0003}S!\u0001\u0019\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012BA2\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001a4\u0003\u0011%#XM]1cY\u0016T!aY\f\u0011\u0005!\\W\"A5\u000b\u0005)4\u0011\u0001\u0002:jG\"L!\u0001\\5\u0003'IK7\r[!mS\u001etW.\u001a8u%\u0016\u001cwN\u001d3\t\u000b9D\u0006\u0019A.\u0002\u000bI,\u0017\rZ:\t\u000bAD\u0006\u0019\u0001\u000b\u0002\u0013I,g-\u001a:f]\u000e,\u0007\"\u0002:Y\u0001\u0004\u0019\u0018A\u0002:fO&|g\u000e\u0005\u0002=i&\u0011Q/\u0010\u0002\u0010%\u00164WM]3oG\u0016\u0014VmZ5p]\")q\u000f\u0001C\u0001q\u0006ia-\u001b8e\u0007>t7/\u001a8tkN$\"!_?\u0011\u0007q#'\u0010\u0005\u0002=w&\u0011A0\u0010\u0002\n\u0007>t7/\u001a8tkNDQA\u001c<A\u0002m\u0003")
public class ConsensusGeneratorFromKnowns
extends ConsensusGenerator {
    private final String file;
    private final transient SparkContext sc;
    private final Broadcast<IndelTable> indelTable;

    public Broadcast<IndelTable> indelTable() {
        return this.indelTable;
    }

    @Override
    public Option<RDD<IndelRealignmentTarget>> targetsToAdd() {
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc);
        String x$7 = this.file;
        Option<Schema> x$8 = qual$1.loadVariants$default$2();
        Option<SequenceDictionary> x$9 = qual$1.loadVariants$default$3();
        RDD<Variant> rdd = qual$1.loadVariants(x$7, x$8, x$9);
        return new Some((Object)rdd.filter((Function1)new Serializable(this){

            public final boolean apply(Variant v) {
                return v.getReferenceAllele().length() != v.getAlternateAllele().length();
            }
        }).map((Function1)new Serializable(this){

            public final ReferenceRegion apply(Variant v) {
                return new ReferenceRegion(v.getContig().getContigName(), Predef$.MODULE$.Long2long(v.getStart()), Predef$.MODULE$.Long2long(v.getStart()) + (long)v.getReferenceAllele().length(), ReferenceRegion$.MODULE$.apply$default$4());
            }
        }, ClassTag$.MODULE$.apply(ReferenceRegion.class)).map((Function1)new Serializable(this){

            public final IndelRealignmentTarget apply(ReferenceRegion r) {
                return new IndelRealignmentTarget((Option<ReferenceRegion>)new Some((Object)r), r);
            }
        }, ClassTag$.MODULE$.apply(IndelRealignmentTarget.class)));
    }

    @Override
    public Iterable<RichAlignmentRecord> preprocessReadsForRealignment(Iterable<RichAlignmentRecord> reads, String reference, ReferenceRegion region2) {
        return reads;
    }

    @Override
    public Iterable<Consensus> findConsensus(Iterable<RichAlignmentRecord> reads) {
        IndelTable table = (IndelTable)this.indelTable().value();
        long start = BoxesRunTime.unboxToLong((Object)((TraversableOnce)reads.map((Function1)new Serializable(this){

            public final long apply(RichAlignmentRecord x$1) {
                return Predef$.MODULE$.Long2long(x$1.record().getStart());
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){

            public final long apply(long x$2, long x$3) {
                return this.apply$mcJJJ$sp(x$2, x$3);
            }

            public long apply$mcJJJ$sp(long x$2, long x$3) {
                return RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$2), x$3);
            }
        }));
        long end = BoxesRunTime.unboxToLong((Object)((TraversableOnce)reads.map((Function1)new Serializable(this){

            public final long apply(RichAlignmentRecord x$4) {
                return Predef$.MODULE$.Long2long(RichAlignmentRecord$.MODULE$.richRecordToRecord(x$4).getEnd());
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){

            public final long apply(long x$5, long x$6) {
                return this.apply$mcJJJ$sp(x$5, x$6);
            }

            public long apply$mcJJJ$sp(long x$5, long x$6) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(x$5), x$6);
            }
        }));
        String refId = ((RichAlignmentRecord)reads.head()).record().getContig().getContigName();
        ReferenceRegion region2 = new ReferenceRegion(refId, start, end + 1L, ReferenceRegion$.MODULE$.apply$default$4());
        return table.getIndelsInRegion(region2);
    }

    public ConsensusGeneratorFromKnowns(String file, SparkContext sc) {
        this.file = file;
        this.sc = sc;
        this.indelTable = sc.broadcast((Object)IndelTable$.MODULE$.apply(file, sc), ClassTag$.MODULE$.apply(IndelTable.class));
    }
}

