/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.ValidationStringency;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.InstrumentedOrderedRDDFunctions;
import org.apache.spark.rdd.MetricsContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromReads;
import org.bdgenomics.adam.converters.AlignmentRecordConverter;
import org.bdgenomics.adam.converters.AlignmentRecordConverter$;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.RecordGroup;
import org.bdgenomics.adam.models.RecordGroup$;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.SAMFileHeaderWritable;
import org.bdgenomics.adam.models.SAMFileHeaderWritable$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.SingleReadBucket;
import org.bdgenomics.adam.models.SingleReadBucket$;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.ADAMSequenceDictionaryRDDAggregator;
import org.bdgenomics.adam.rdd.read.ADAMBAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.ADAMSAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDDFunctions$;
import org.bdgenomics.adam.rdd.read.FlagStat$;
import org.bdgenomics.adam.rdd.read.FlagStatMetrics;
import org.bdgenomics.adam.rdd.read.InstrumentedADAMBAMOutputFormat;
import org.bdgenomics.adam.rdd.read.InstrumentedADAMSAMOutputFormat;
import org.bdgenomics.adam.rdd.read.MarkDuplicates$;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndels$;
import org.bdgenomics.adam.rdd.read.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.MapTools$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0001\u0003\u00015\u00111$\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a*E\t\u001a+hn\u0019;j_:\u001c(BA\u0002\u0005\u0003\u0011\u0011X-\u00193\u000b\u0005\u00151\u0011a\u0001:eI*\u0011q\u0001C\u0001\u0005C\u0012\fWN\u0003\u0002\n\u0015\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0012B\t\u0006k5+Z9vK:\u001cW\rR5di&|g.\u0019:z%\u0012#\u0015iZ4sK\u001e\fGo\u001c:\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B1we>T!a\u0006\u0005\u0002\u000f\u0019|'/\\1ug&\u0011\u0011\u0004\u0006\u0002\u0010\u00032LwM\\7f]R\u0014VmY8sI\"AQ\u0001\u0001B\u0001B\u0003%1\u0004E\u0002\u001dEIi\u0011!\b\u0006\u0003\u000byQ!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005R\u0011AB1qC\u000eDW-\u0003\u0002$;\t\u0019!\u000b\u0012#\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u0006I\u0001\u00071\u0004C\u0003,\u0001\u0011\u0005A&A\rgS2$XM\u001d\"z\u001fZ,'\u000f\\1qa&twMU3hS>tGCA\u000e.\u0011\u0015q#\u00061\u00010\u0003\u0015\tX/\u001a:z!\t\u00014'D\u00012\u0015\t\u0011d!\u0001\u0004n_\u0012,Gn]\u0005\u0003iE\u0012qBU3gKJ,gnY3SK\u001eLwN\u001c\u0005\u0006m\u0001!\taN\u0001\r[\u0006L(-Z*bm\u0016\u0014\u0015-\u001c\u000b\u0004qy\u001a\u0005CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u007fU\u0002\r\u0001Q\u0001\u0005CJ<7\u000f\u0005\u0002\u0010\u0003&\u0011!\t\u0002\u0002\u0010\u0003\u0012\u000bUjU1wK\u0006s\u00170\u0011:hg\"9A)\u000eI\u0001\u0002\u0004A\u0014\u0001C5t'>\u0014H/\u001a3\t\u000b\u0019\u0003A\u0011A$\u0002\u001d5\f\u0017PY3TCZ,g)Y:ucR\u0011\u0001\b\u0013\u0005\u0006\u007f\u0015\u0003\r\u0001\u0011\u0005\u0006\u0015\u0002!\taS\u0001\u0016C\u0012\fW.\u00117jO:,GMU3d_J$7+\u0019<f)\tAD\nC\u0003@\u0013\u0002\u0007\u0001\tC\u0003O\u0001\u0011\u0005q*\u0001\u0005bI\u0006l7+\u0019<f)\rA\u0004+\u0015\u0005\u0006\u007f5\u0003\r\u0001\u0011\u0005\b\t6\u0003\n\u00111\u00019\u0011\u0015\u0019\u0006\u0001\"\u0001U\u00035\tG-Y7T\u00036\u001bFO]5oOV\tQ\u000b\u0005\u0002W3:\u0011\u0011hV\u0005\u00031j\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001L\u000f\u0005\u0006;\u0002!\tAX\u0001\fC\u0012\fWnU!N'\u00064X\rF\u0003`E\u00124\u0007\u000e\u0005\u0002:A&\u0011\u0011M\u000f\u0002\u0007\u0003:Lh+\u00197\t\u000b\rd\u0006\u0019A+\u0002\u0011\u0019LG.\u001a)bi\"Dq!\u001a/\u0011\u0002\u0003\u0007\u0001(A\u0003bgN\u000bW\u000eC\u0004h9B\u0005\t\u0019\u0001\u001d\u0002\u0019\u0005\u001c8+\u001b8hY\u00164\u0015\u000e\\3\t\u000f\u0011c\u0006\u0013!a\u0001q!)!\u000e\u0001C\u0001W\u0006ir-\u001a;TKF,XM\\2f%\u0016\u001cwN\u001d3t\rJ|W.\u00127f[\u0016tG\u000f\u0006\u0002mkB\u0019Q\u000e\u001d:\u000e\u00039T!a\u001c\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002r]\n\u00191+\u001a;\u0011\u0005A\u001a\u0018B\u0001;2\u00059\u0019V-];f]\u000e,'+Z2pe\u0012DQA^5A\u0002I\tA!\u001a7f[\")\u0001\u0010\u0001C\u0001s\u0006Q\u0012\rZ1n\u000f\u0016$(+Z1e\u000fJ|W\u000f\u001d#jGRLwN\\1ssR\t!\u0010\u0005\u00021w&\u0011A0\r\u0002\u0016%\u0016\u001cwN\u001d3He>,\b\u000fR5di&|g.\u0019:z\u0011\u0015q\b\u0001\"\u0001\u0000\u0003A\tG-Y7D_:4XM\u001d;U_N\u000bU\n\u0006\u0003\u0002\u0002\u0005%\u0002cB\u001d\u0002\u0004\u0005\u001d\u0011\u0011D\u0005\u0004\u0003\u000bQ$A\u0002+va2,'\u0007\u0005\u0003\u001dE\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u000bQ\u0006$wn\u001c9`E\u0006l'bAA\n\u0015\u000591/Z9e_>\u0004\u0018\u0002BA\f\u0003\u001b\u0011\u0011cU!N%\u0016\u001cwN\u001d3Xe&$\u0018M\u00197f!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0001b]1ni>|Gn\u001d\u0006\u0003\u0003G\ta\u0001\u001b;tU\u0012\\\u0017\u0002BA\u0014\u0003;\u0011QbU!N\r&dW\rS3bI\u0016\u0014\bb\u0002#~!\u0003\u0005\r\u0001\u000f\u0005\b\u0003[\u0001A\u0011AA\u0018\u00039\tG-Y7D_VtGoS7feN$B!!\r\u0002<A!ADIA\u001a!\u0019I\u00141A+\u00026A\u0019\u0011(a\u000e\n\u0007\u0005e\"H\u0001\u0003M_:<\u0007\u0002CA\u001f\u0003W\u0001\r!a\u0010\u0002\u0015-lWM\u001d'f]\u001e$\b\u000eE\u0002:\u0003\u0003J1!a\u0011;\u0005\rIe\u000e\u001e\u0005\b\u0003\u000f\u0002A\u0011AA%\u0003\u0001\nG-Y7T_J$(+Z1eg\nK(+\u001a4fe\u0016t7-\u001a)pg&$\u0018n\u001c8\u0015\u0003mAq!!\u0014\u0001\t\u0003\tI%\u0001\nbI\u0006lW*\u0019:l\tV\u0004H.[2bi\u0016\u001c\bbBA)\u0001\u0011\u0005\u00111K\u0001\tC\u0012\fWNQ)T%R91$!\u0016\u0002l\u0005U\u0004\u0002CA,\u0003\u001f\u0002\r!!\u0017\u0002\u0013-twn\u001e8T]B\u001c\bCBA.\u0003C\n)'\u0004\u0002\u0002^)\u0019\u0011q\f\u0010\u0002\u0013\t\u0014x.\u00193dCN$\u0018\u0002BA2\u0003;\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007A\n9'C\u0002\u0002jE\u0012\u0001b\u00158q)\u0006\u0014G.\u001a\u0005\u000b\u0003[\ny\u0005%AA\u0002\u0005=\u0014aE8cg\u0016\u0014h/\u0019;j_:$U/\u001c9GS2,\u0007\u0003B\u001d\u0002rUK1!a\u001d;\u0005\u0019y\u0005\u000f^5p]\"Q\u0011qOA(!\u0003\u0005\r!!\u001f\u0002)Y\fG.\u001b3bi&|gn\u0015;sS:<WM\\2z!\u0011\tY\"a\u001f\n\t\u0005u\u0014Q\u0004\u0002\u0015-\u0006d\u0017\u000eZ1uS>t7\u000b\u001e:j]\u001e,gnY=\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\u0006\t\u0012\rZ1n%\u0016\fG.[4o\u0013:$W\r\\:\u0015\u001bm\t))!'\u0002\u001c\u0006}\u00151UAW\u0011)\t9)a \u0011\u0002\u0003\u0007\u0011\u0011R\u0001\u000fG>t7/\u001a8tkNlu\u000eZ3m!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000b\u0011bY8og\u0016t7/^:\u000b\u0007\u0005Me!\u0001\u0006bY\u001e|'/\u001b;i[NLA!a&\u0002\u000e\n\u00112i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\u0011!!\u0015q\u0010I\u0001\u0002\u0004A\u0004BCAO\u0003\u007f\u0002\n\u00111\u0001\u0002@\u0005aQ.\u0019=J]\u0012,GnU5{K\"Q\u0011\u0011UA@!\u0003\u0005\r!a\u0010\u0002%5\f\u0007pQ8og\u0016t7/^:Ok6\u0014WM\u001d\u0005\u000b\u0003K\u000by\b%AA\u0002\u0005\u001d\u0016\u0001\u00047pIRC'/Z:i_2$\u0007cA\u001d\u0002*&\u0019\u00111\u0016\u001e\u0003\r\u0011{WO\u00197f\u0011)\ty+a \u0011\u0002\u0003\u0007\u0011qH\u0001\u000e[\u0006DH+\u0019:hKR\u001c\u0016N_3\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006a\u0011\rZ1n\r2\fwm\u0015;biR\u0011\u0011q\u0017\t\bs\u0005\r\u0011\u0011XA]!\rA\u00131X\u0005\u0004\u0003{\u0013!a\u0004$mC\u001e\u001cF/\u0019;NKR\u0014\u0018nY:\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\u0006)\u0012\rZ1n'&tw\r\\3SK\u0006$')^2lKR\u001cHCAAc!\u0011a\"%a2\u0011\u0007A\nI-C\u0002\u0002LF\u0012\u0001cU5oO2,'+Z1e\u0005V\u001c7.\u001a;\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\u0006!\u0012\rZ1n\u0007\"\f'/Y2uKJL'0\u001a+bON$\"!!\r\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\u0006I\u0012\rZ1n\u0007\"\f'/Y2uKJL'0\u001a+bOZ\u000bG.^3t)\u0011\tI.!:\u0011\u000fY\u000bY.a8\u00026%\u0019\u0011Q\\.\u0003\u00075\u000b\u0007\u000fE\u0002:\u0003CL1!a9;\u0005\r\te.\u001f\u0005\b\u0003O\f\u0019\u000e1\u0001V\u0003\r!\u0018m\u001a\u0005\b\u0003W\u0004A\u0011AAw\u0003a\tG-Y7GS2$XM\u001d*fG>\u0014Hm],ji\"$\u0016m\u001a\u000b\u00047\u0005=\bbBAy\u0003S\u0004\r!V\u0001\bi\u0006<g*Y7f\u0011\u001d\t)\u0010\u0001C\u0001\u0003o\fQ#\u00193b[N\u000bg/Z!t!\u0006L'/\u001a3GCN$\u0018\u000f\u0006\u0007\u0002z\u0006}(1\u0001B\u0004\u0005\u0017\u0011i\u0001E\u0002:\u0003wL1!!@;\u0005\u0011)f.\u001b;\t\u000f\t\u0005\u00111\u001fa\u0001+\u0006Ia-\u001b7f\u001d\u0006lW-\r\u0005\b\u0005\u000b\t\u0019\u00101\u0001V\u0003%1\u0017\u000e\\3OC6,'\u0007C\u0005\u0003\n\u0005M\b\u0013!a\u0001q\u0005Yr.\u001e;qkR|%/[4j]\u0006d')Y:f#V\fG.\u001b;jKND!\"a\u001e\u0002tB\u0005\t\u0019AA=\u0011)\u0011y!a=\u0011\u0002\u0003\u0007!\u0011C\u0001\ra\u0016\u00148/[:u\u0019\u00164X\r\u001c\t\u0006s\u0005E$1\u0003\t\u0005\u0005+\u0011Y\"\u0004\u0002\u0003\u0018)\u0019!\u0011\u0004\u0010\u0002\u000fM$xN]1hK&!!Q\u0004B\f\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005G\tq\"\u00193b[N\u000bg/Z!t\r\u0006\u001cH/\u001d\u000b\u000f\u0003s\u0014)C!\u000b\u0003.\t=\"1\u0007B\u001b\u0011\u001d\u00119Ca\bA\u0002U\u000b\u0001BZ5mK:\u000bW.\u001a\u0005\u000b\u0005W\u0011y\u0002%AA\u0002\u0005=\u0014\u0001\u00044jY\u0016t\u0015-\\33\u001fB$\b\"\u0003B\u0005\u0005?\u0001\n\u00111\u00019\u0011%\u0011\tDa\b\u0011\u0002\u0003\u0007\u0001(\u0001\u0003t_J$\bBCA<\u0005?\u0001\n\u00111\u0001\u0002z!Q!q\u0002B\u0010!\u0003\u0005\rA!\u0005\t\u000f\te\u0002\u0001\"\u0001\u0003<\u0005y\u0011\rZ1n%\u0016\u0004\u0016-\u001b:SK\u0006$7\u000fF\u0003\u001c\u0005{\u0011\t\u0005C\u0004\u0003@\t]\u0002\u0019A\u000e\u0002\u001bM,7m\u001c8e!\u0006L'O\u00153e\u0011)\t9Ha\u000e\u0011\u0002\u0003\u0007\u0011\u0011\u0010\u0005\n\u0005\u000b\u0002\u0011\u0013!C\u0001\u0005\u000f\na#\\1zE\u0016\u001c\u0016M^3CC6$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0013R3\u0001\u000fB&W\t\u0011i\u0005\u0005\u0003\u0003P\teSB\u0001B)\u0015\u0011\u0011\u0019F!\u0016\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B,u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm#\u0011\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B0\u0001E\u0005I\u0011\u0001B$\u0003U\tG-Y7T\u00036\u001b\u0016M^3%I\u00164\u0017-\u001e7uIIB\u0011Ba\u0019\u0001#\u0003%\tAa\u0012\u0002+\u0005$\u0017-\\*B\u001bN\u000bg/\u001a\u0013eK\u001a\fW\u000f\u001c;%g!I!q\r\u0001\u0012\u0002\u0013\u0005!qI\u0001\u0016C\u0012\fWnU!N'\u00064X\r\n3fM\u0006,H\u000e\u001e\u00135\u0011%\u0011Y\u0007AI\u0001\n\u0003\u00119%\u0001\u000ebI\u0006l7i\u001c8wKJ$Hk\\*B\u001b\u0012\"WMZ1vYR$\u0013\u0007C\u0005\u0003p\u0001\t\n\u0011\"\u0001\u0003r\u0005I\u0012\rZ1n'\u00064X-Q:GCN$\u0018\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019H\u000b\u0003\u0002p\t-\u0003\"\u0003B<\u0001E\u0005I\u0011\u0001B$\u0003e\tG-Y7TCZ,\u0017i\u001d$bgR\fH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\tm\u0004!%A\u0005\u0002\t\u001d\u0013!G1eC6\u001c\u0016M^3Bg\u001a\u000b7\u000f^9%I\u00164\u0017-\u001e7uIQB\u0011Ba \u0001#\u0003%\tA!!\u00023\u0005$\u0017-\\*bm\u0016\f5OR1tiF$C-\u001a4bk2$H%N\u000b\u0003\u0005\u0007SC!!\u001f\u0003L!I!q\u0011\u0001\u0012\u0002\u0013\u0005!\u0011R\u0001\u001aC\u0012\fWnU1wK\u0006\u001bh)Y:uc\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\f*\"!\u0011\u0003B&\u0011%\u0011y\tAI\u0001\n\u0003\u00119%\u0001\nbI\u0006l7+\u0019<fI\u0011,g-Y;mi\u0012\u0012\u0004\"\u0003BJ\u0001E\u0005I\u0011\u0001B9\u0003I\tG-Y7C#N\u0013F\u0005Z3gCVdG\u000f\n\u001a\t\u0013\t]\u0005!%A\u0005\u0002\t\u0005\u0015AE1eC6\u0014\u0015k\u0015*%I\u00164\u0017-\u001e7uIMB\u0011Ba'\u0001#\u0003%\tA!(\u00027\u0005$\u0017-\u001c*fC2LwM\\%oI\u0016d7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yJ\u000b\u0003\u0002\n\n-\u0003\"\u0003BR\u0001E\u0005I\u0011\u0001B$\u0003m\tG-Y7SK\u0006d\u0017n\u001a8J]\u0012,Gn\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I!q\u0015\u0001\u0012\u0002\u0013\u0005!\u0011V\u0001\u001cC\u0012\fWNU3bY&<g.\u00138eK2\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t-&\u0006BA \u0005\u0017B\u0011Ba,\u0001#\u0003%\tA!+\u00027\u0005$\u0017-\u001c*fC2LwM\\%oI\u0016d7\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011%\u0011\u0019\fAI\u0001\n\u0003\u0011),A\u000ebI\u0006l'+Z1mS\u001et\u0017J\u001c3fYN$C-\u001a4bk2$H%N\u000b\u0003\u0005oSC!a*\u0003L!I!1\u0018\u0001\u0012\u0002\u0013\u0005!\u0011V\u0001\u001cC\u0012\fWNU3bY&<g.\u00138eK2\u001cH\u0005Z3gCVdG\u000f\n\u001c\t\u0013\t}\u0006!%A\u0005\u0002\t\u001d\u0013aH1eC6\u001c\u0016M^3BgB\u000b\u0017N]3e\r\u0006\u001cH/\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I!1\u0019\u0001\u0012\u0002\u0013\u0005!\u0011Q\u0001 C\u0012\fWnU1wK\u0006\u001b\b+Y5sK\u00124\u0015m\u001d;rI\u0011,g-Y;mi\u0012\"\u0004\"\u0003Bd\u0001E\u0005I\u0011\u0001BE\u0003}\tG-Y7TCZ,\u0017i\u001d)bSJ,GMR1tiF$C-\u001a4bk2$H%\u000e\u0005\n\u0005\u0017\u0004\u0011\u0013!C\u0001\u0005\u0003\u000b\u0011$\u00193b[J+\u0007+Y5s%\u0016\fGm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public class AlignmentRecordRDDFunctions
extends ADAMSequenceDictionaryRDDAggregator<AlignmentRecord> {
    public final RDD<AlignmentRecord> org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd;

    public RDD<AlignmentRecord> filterByOverlappingRegion(ReferenceRegion query) {
        return this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.filter((Function1)new Serializable(this, query){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final ReferenceRegion query$1;

            public final boolean apply(AlignmentRecord rec) {
                return this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$overlapsQuery$1(rec, this.query$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
    }

    public boolean maybeSaveBam(ADAMSaveAnyArgs args, boolean isSorted) {
        boolean bl;
        if (args.outputPath().endsWith(".sam")) {
            this.log().info("Saving data in SAM format");
            AlignmentRecordRDDFunctions qual$2 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
            String x$33 = args.outputPath();
            boolean x$34 = args.asSingleFile();
            boolean x$35 = qual$2.adamSAMSave$default$2();
            boolean x$36 = qual$2.adamSAMSave$default$4();
            qual$2.adamSAMSave(x$33, x$35, x$34, x$36);
            bl = true;
        } else if (args.outputPath().endsWith(".bam")) {
            this.log().info("Saving data in BAM format");
            AlignmentRecordRDDFunctions qual$3 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
            String x$37 = args.outputPath();
            boolean x$38 = false;
            boolean x$39 = args.asSingleFile();
            boolean x$40 = qual$3.adamSAMSave$default$4();
            qual$3.adamSAMSave(x$37, x$38, x$39, x$40);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean maybeSaveBam$default$2() {
        return false;
    }

    public boolean maybeSaveFastq(ADAMSaveAnyArgs args) {
        boolean bl;
        if (args.outputPath().endsWith(".fq") || args.outputPath().endsWith(".fastq") || args.outputPath().endsWith(".ifq")) {
            AlignmentRecordRDDFunctions qual$4 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
            String x$41 = args.outputPath();
            boolean x$42 = args.sortFastqOutput();
            Option<String> x$43 = qual$4.adamSaveAsFastq$default$2();
            boolean x$44 = qual$4.adamSaveAsFastq$default$3();
            ValidationStringency x$45 = qual$4.adamSaveAsFastq$default$5();
            Option<StorageLevel> x$46 = qual$4.adamSaveAsFastq$default$6();
            qual$4.adamSaveAsFastq(x$41, x$43, x$44, x$42, x$45, x$46);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean adamAlignedRecordSave(ADAMSaveAnyArgs args) {
        if (this.maybeSaveBam(args, this.maybeSaveBam$default$2())) return true;
        ADAMContext$.MODULE$.rddToADAMRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, Predef$.MODULE$.$conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).adamParquetSave(args);
        if (!true) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean adamSave(ADAMSaveAnyArgs args, boolean isSorted) {
        if (this.maybeSaveBam(args, isSorted)) return true;
        if (this.maybeSaveFastq(args)) return true;
        ADAMContext$.MODULE$.rddToADAMRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, Predef$.MODULE$.$conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).adamParquetSave(args);
        if (!true) return false;
        return true;
    }

    public boolean adamSave$default$2() {
        return false;
    }

    public String adamSAMString() {
        boolean x$47;
        AlignmentRecordRDDFunctions qual$5 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
        Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2 = qual$5.adamConvertToSAM(x$47 = qual$5.adamConvertToSAM$default$1());
        if (tuple2 != null) {
            RDD convertRecords = (RDD)tuple2._1();
            SAMFileHeader header2 = (SAMFileHeader)tuple2._2();
            if (convertRecords != null) {
                RDD rDD = convertRecords;
                if (header2 != null) {
                    Tuple2 tuple22;
                    SAMFileHeader sAMFileHeader = header2;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)rDD, (Object)sAMFileHeader);
                    RDD convertRecords2 = (RDD)tuple23._1();
                    SAMFileHeader header3 = (SAMFileHeader)tuple23._2();
                    int x$48 = 1;
                    boolean x$49 = true;
                    Ordering x$50 = convertRecords2.coalesce$default$3(x$48, x$49);
                    SAMRecordWritable[] records = (SAMRecordWritable[])convertRecords2.coalesce(x$48, x$49, x$50).collect();
                    SAMTextHeaderCodec samHeaderCodec = new SAMTextHeaderCodec();
                    samHeaderCodec.setValidationStringency(ValidationStringency.SILENT);
                    StringWriter samStringWriter = new StringWriter();
                    samHeaderCodec.encode((Writer)samStringWriter, header3);
                    SAMTextWriter samWriter = new SAMTextWriter((Writer)samStringWriter);
                    Predef$.MODULE$.refArrayOps((Object[])records).foreach((Function1)new Serializable(this, samWriter){
                        private final SAMTextWriter samWriter$1;

                        public final void apply(SAMRecordWritable record) {
                            this.samWriter$1.writeAlignment(record.get());
                        }
                        {
                            this.samWriter$1 = samWriter$1;
                        }
                    });
                    return samStringWriter.toString();
                }
            }
        }
        throw new MatchError(tuple2);
    }

    public Object adamSAMSave(String filePath, boolean asSam, boolean asSingleFile, boolean isSorted) {
        return Timers$.MODULE$.SAMSave().time((Function0)new Serializable(this, filePath, asSam, asSingleFile, isSorted){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final String filePath$1;
            public final boolean asSam$1;
            private final boolean asSingleFile$1;
            private final boolean isSorted$1;

            public final Object apply() {
                Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2;
                block8: {
                    boolean bl;
                    block11: {
                        boolean bl2;
                        block14: {
                            Object object;
                            block13: {
                                Configuration conf;
                                RDD withKey;
                                block12: {
                                    block10: {
                                        SAMFileHeader header2;
                                        block9: {
                                            RDD rDD;
                                            Tuple2 tuple22;
                                            tuple2 = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamConvertToSAM(this.isSorted$1);
                                            if (tuple2 == null) break block8;
                                            RDD convertRecords = (RDD)tuple2._1();
                                            SAMFileHeader header3 = (SAMFileHeader)tuple2._2();
                                            if (convertRecords == null) break block8;
                                            RDD rDD2 = convertRecords;
                                            if (header3 == null) break block8;
                                            SAMFileHeader sAMFileHeader = header3;
                                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rDD2, (Object)sAMFileHeader);
                                            RDD convertRecords2 = (RDD)tuple23._1();
                                            header2 = (SAMFileHeader)tuple23._2();
                                            if (this.asSingleFile$1) {
                                                RDD qual$1 = convertRecords2.keyBy((Function1)new Serializable(this){

                                                    public final LongWritable apply(SAMRecordWritable v) {
                                                        return new LongWritable((long)v.get().getAlignmentStart());
                                                    }
                                                });
                                                int x$28 = 1;
                                                boolean x$29 = qual$1.coalesce$default$2();
                                                int x$30 = x$28;
                                                boolean x$31 = x$29;
                                                Ordering x$32 = qual$1.coalesce$default$3(x$30, x$31);
                                                rDD = qual$1.coalesce(x$30, x$31, x$32);
                                            } else {
                                                rDD = convertRecords2.keyBy((Function1)new Serializable(this){

                                                    public final LongWritable apply(SAMRecordWritable v) {
                                                        return new LongWritable((long)v.get().getAlignmentStart());
                                                    }
                                                });
                                            }
                                            withKey = rDD;
                                            Broadcast bcastHeader = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.context().broadcast((Object)header2, ClassTag$.MODULE$.apply(SAMFileHeader.class));
                                            long mp = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.mapPartitionsWithIndex((Function2)new Serializable(this, bcastHeader){
                                                private final /* synthetic */ $anonfun$adamSAMSave$1 $outer;
                                                private final Broadcast bcastHeader$1;

                                                public final Iterator<Object> apply(int idx, Iterator<AlignmentRecord> iter) {
                                                    this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer().log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting ", " header for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.asSam$1 ? "SAM" : "BAM", BoxesRunTime.boxToInteger((int)idx)})));
                                                    SAMFileHeader header2 = (SAMFileHeader)this.bcastHeader$1.value();
                                                    AlignmentRecordRDDFunctions alignmentRecordRDDFunctions = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer();
                                                    synchronized (alignmentRecordRDDFunctions) {
                                                        boolean bl;
                                                        block6: {
                                                            bl = this.$outer.asSam$1;
                                                            if (bl) {
                                                                ADAMSAMOutputFormat$.MODULE$.clearHeader();
                                                                ADAMSAMOutputFormat$.MODULE$.addHeader(header2);
                                                                this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer().log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set SAM header for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx)})));
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                if (bl) break block6;
                                                                ADAMBAMOutputFormat$.MODULE$.clearHeader();
                                                                ADAMBAMOutputFormat$.MODULE$.addHeader(header2);
                                                                this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer().log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set BAM header for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx)})));
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            }
                                                            return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                                                        }
                                                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                                                    }
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.bcastHeader$1 = bcastHeader$1;
                                                }
                                            }, this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).count();
                                            if (mp != 0L) {
                                                this.$outer.log().error("Had more than 0 elements after map partitions call to set VCF header across cluster.");
                                            }
                                            if (!(bl = this.asSam$1)) break block9;
                                            ADAMSAMOutputFormat$.MODULE$.clearHeader();
                                            ADAMSAMOutputFormat$.MODULE$.addHeader(header2);
                                            this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set SAM header on driver"})).s((Seq)Nil$.MODULE$));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block10;
                                        }
                                        if (bl) break block11;
                                        ADAMBAMOutputFormat$.MODULE$.clearHeader();
                                        ADAMBAMOutputFormat$.MODULE$.addHeader(header2);
                                        this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set BAM header on driver"})).s((Seq)Nil$.MODULE$));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    conf = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.context().hadoopConfiguration();
                                    bl2 = this.asSam$1;
                                    if (!bl2) break block12;
                                    MetricsContext$.MODULE$.rddToInstrumentedPairRDD(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(this.filePath$1, LongWritable.class, SAMRecordWritable.class, InstrumentedADAMSAMOutputFormat.class, conf);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block13;
                                }
                                if (bl2) break block14;
                                MetricsContext$.MODULE$.rddToInstrumentedPairRDD(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsNewAPIHadoopFile(this.filePath$1, LongWritable.class, SAMRecordWritable.class, InstrumentedADAMBAMOutputFormat.class, conf);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            if (this.asSingleFile$1) {
                                this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing single ", " file (not Hadoop-style directory)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asSam$1 ? "SAM" : "BAM"})));
                                Configuration conf = new Configuration();
                                FileSystem fs = FileSystem.get((Configuration)conf);
                                String ouputParentDir = this.filePath$1.substring(0, this.filePath$1.lastIndexOf("/") + 1);
                                String tmpPath = new StringBuilder().append((Object)ouputParentDir).append((Object)"tmp").append((Object)((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString()).toString();
                                fs.rename(new Path(new StringBuilder().append((Object)this.filePath$1).append((Object)"/part-r-00000").toString()), new Path(tmpPath));
                                fs.delete(new Path(this.filePath$1), true);
                                object = BoxesRunTime.boxToBoolean((boolean)fs.rename(new Path(tmpPath), new Path(this.filePath$1)));
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            return object;
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ AlignmentRecordRDDFunctions org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.filePath$1 = filePath$1;
                this.asSam$1 = asSam$1;
                this.asSingleFile$1 = asSingleFile$1;
                this.isSorted$1 = isSorted$1;
            }
        });
    }

    public boolean adamSAMSave$default$2() {
        return true;
    }

    public boolean adamSAMSave$default$3() {
        return false;
    }

    public boolean adamSAMSave$default$4() {
        return false;
    }

    @Override
    public Set<SequenceRecord> getSequenceRecordsFromElement(AlignmentRecord elem) {
        return SequenceRecord$.MODULE$.fromADAMRecord(elem);
    }

    public RecordGroupDictionary adamGetReadGroupDictionary() {
        Seq rgNames = Predef$.MODULE$.refArrayOps((Object[])this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.flatMap((Function1)new Serializable(this){

            public final Iterable<RecordGroup> apply(AlignmentRecord x$3) {
                return Option$.MODULE$.option2Iterable(RecordGroup$.MODULE$.apply(x$3));
            }
        }, ClassTag$.MODULE$.apply(RecordGroup.class)).distinct().collect()).toSeq();
        return new RecordGroupDictionary((Seq<RecordGroup>)rgNames);
    }

    public Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> adamConvertToSAM(boolean isSorted) {
        return (Tuple2)Timers$.MODULE$.ConvertToSAM().time((Function0)new Serializable(this, isSorted){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final boolean isSorted$2;

            public final Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> apply() {
                SequenceDictionary sd = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamGetSequenceDictionary();
                RecordGroupDictionary rgd = ADAMContext$.MODULE$.rddToADAMRecordRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd).adamGetReadGroupDictionary();
                AlignmentRecordConverter adamRecordConverter = new AlignmentRecordConverter();
                SAMFileHeader header2 = adamRecordConverter.createSAMHeader(sd, rgd);
                if (this.isSorted$2) {
                    header2.setSortOrder(SAMFileHeader.SortOrder.coordinate);
                }
                Broadcast hdrBcast = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.context().broadcast((Object)SAMFileHeaderWritable$.MODULE$.apply(header2), ClassTag$.MODULE$.apply(SAMFileHeaderWritable.class));
                RDD convertedRDD = this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.map((Function1)new Serializable(this, adamRecordConverter, hdrBcast){
                    private final AlignmentRecordConverter adamRecordConverter$1;
                    private final Broadcast hdrBcast$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final SAMRecordWritable apply(AlignmentRecord r) {
                        void var2_2;
                        SAMRecordWritable srw = new SAMRecordWritable();
                        srw.set(this.adamRecordConverter$1.convert(r, (SAMFileHeaderWritable)this.hdrBcast$1.value()));
                        return var2_2;
                    }
                    {
                        this.adamRecordConverter$1 = adamRecordConverter$1;
                        this.hdrBcast$1 = hdrBcast$1;
                    }
                }, ClassTag$.MODULE$.apply(SAMRecordWritable.class));
                return new Tuple2((Object)convertedRDD, (Object)header2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSorted$2 = isSorted$2;
            }
        });
    }

    public boolean adamConvertToSAM$default$1() {
        return false;
    }

    public RDD<Tuple2<String, Object>> adamCountKmers(int kmerLength) {
        return MetricsContext$.MODULE$.rddToInstrumentedPairRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.flatMap((Function1)new Serializable(this, kmerLength){
            private final int kmerLength$1;

            public final Iterator<Tuple2<String, Object>> apply(AlignmentRecord r) {
                return new StringOps(Predef$.MODULE$.augmentString(r.getSequence().toString())).sliding(this.kmerLength$1).map((Function1)new Serializable(this){

                    public final Tuple2<String, Object> apply(String k) {
                        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                });
            }
            {
                this.kmerLength$1 = kmerLength$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){

            public final long apply(long k1, long k2) {
                return this.apply$mcJJJ$sp(k1, k2);
            }

            public long apply$mcJJJ$sp(long k1, long k2) {
                return k1 + k2;
            }
        });
    }

    public RDD<AlignmentRecord> adamSortReadsByReferencePosition() {
        return (RDD)Timers$.MODULE$.SortReads().time((Function0)new Serializable(this){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;

            public final RDD<AlignmentRecord> apply() {
                this.$outer.log().info("Sorting reads by reference position");
                InstrumentedOrderedRDDFunctions qual$6 = MetricsContext$.MODULE$.rddToInstrumentedOrderedRDD(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.keyBy((Function1)new Serializable(this){

                    public final ReferencePosition apply(AlignmentRecord r) {
                        return Predef$.MODULE$.Boolean2boolean(r.getReadMapped()) ? ReferencePosition$.MODULE$.apply(r) : ReferencePosition$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("ZZZ%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r.getReadName()})), 0L);
                    }
                }), (Ordering)ReferencePosition$.MODULE$.orderingForPositions(), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
                boolean x$51 = qual$6.sortByKey$default$1();
                int x$52 = qual$6.sortByKey$default$2();
                return qual$6.sortByKey(x$51, x$52).map((Function1)new Serializable(this){

                    public final AlignmentRecord apply(Tuple2<ReferencePosition, AlignmentRecord> p) {
                        return (AlignmentRecord)p._2();
                    }
                }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public RDD<AlignmentRecord> adamMarkDuplicates() {
        return (RDD)Timers$.MODULE$.MarkDuplicatesInDriver().time((Function0)new Serializable(this){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;

            public final RDD<AlignmentRecord> apply() {
                return MarkDuplicates$.MODULE$.apply(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public RDD<AlignmentRecord> adamBQSR(Broadcast<SnpTable> knownSnps, Option<String> observationDumpFile, ValidationStringency validationStringency) {
        return (RDD)Timers$.MODULE$.BQSRInDriver().time((Function0)new Serializable(this, knownSnps, observationDumpFile, validationStringency){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final Broadcast knownSnps$1;
            private final Option observationDumpFile$1;
            private final ValidationStringency validationStringency$1;

            public final RDD<AlignmentRecord> apply() {
                return BaseQualityRecalibration$.MODULE$.apply(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, (Broadcast<SnpTable>)this.knownSnps$1, (Option<String>)this.observationDumpFile$1, this.validationStringency$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.knownSnps$1 = knownSnps$1;
                this.observationDumpFile$1 = observationDumpFile$1;
                this.validationStringency$1 = validationStringency$1;
            }
        });
    }

    public Option<String> adamBQSR$default$2() {
        return None$.MODULE$;
    }

    public ValidationStringency adamBQSR$default$3() {
        return ValidationStringency.LENIENT;
    }

    public RDD<AlignmentRecord> adamRealignIndels(ConsensusGenerator consensusModel, boolean isSorted, int maxIndelSize, int maxConsensusNumber, double lodThreshold, int maxTargetSize) {
        return (RDD)Timers$.MODULE$.RealignIndelsInDriver().time((Function0)new Serializable(this, consensusModel, isSorted, maxIndelSize, maxConsensusNumber, lodThreshold){
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final ConsensusGenerator consensusModel$1;
            private final boolean isSorted$3;
            private final int maxIndelSize$1;
            private final int maxConsensusNumber$1;
            private final double lodThreshold$1;

            public final RDD<AlignmentRecord> apply() {
                return RealignIndels$.MODULE$.apply(this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, this.consensusModel$1, this.isSorted$3, this.maxIndelSize$1, this.maxConsensusNumber$1, this.lodThreshold$1, RealignIndels$.MODULE$.apply$default$7());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consensusModel$1 = consensusModel$1;
                this.isSorted$3 = isSorted$3;
                this.maxIndelSize$1 = maxIndelSize$1;
                this.maxConsensusNumber$1 = maxConsensusNumber$1;
                this.lodThreshold$1 = lodThreshold$1;
            }
        });
    }

    public ConsensusGenerator adamRealignIndels$default$1() {
        return new ConsensusGeneratorFromReads();
    }

    public boolean adamRealignIndels$default$2() {
        return false;
    }

    public int adamRealignIndels$default$3() {
        return 500;
    }

    public int adamRealignIndels$default$4() {
        return 30;
    }

    public double adamRealignIndels$default$5() {
        return 5.0;
    }

    public int adamRealignIndels$default$6() {
        return 3000;
    }

    public Tuple2<FlagStatMetrics, FlagStatMetrics> adamFlagStat() {
        return FlagStat$.MODULE$.apply(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
    }

    public RDD<SingleReadBucket> adamSingleReadBuckets() {
        return SingleReadBucket$.MODULE$.apply(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd);
    }

    public RDD<Tuple2<String, Object>> adamCharacterizeTags() {
        return MetricsContext$.MODULE$.rddToInstrumentedPairRDD(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.flatMap((Function1)new Serializable(this){

            public final Seq<Tuple2<String, Object>> apply(AlignmentRecord x$4) {
                return (Seq)RichAlignmentRecord$.MODULE$.apply(x$4).tags().map((Function1)new Serializable(this){

                    public final Tuple2<String, Object> apply(Attribute attr) {
                        return new Tuple2((Object)attr.tag(), (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){

            public final long apply(long x$5, long x$6) {
                return this.apply$mcJJJ$sp(x$5, x$6);
            }

            public long apply$mcJJJ$sp(long x$5, long x$6) {
                return x$5 + x$6;
            }
        });
    }

    public scala.collection.immutable.Map<Object, Object> adamCharacterizeTagValues(String tag) {
        return (scala.collection.immutable.Map)this.adamFilterRecordsWithTag(tag).flatMap((Function1)new Serializable(this, tag){
            public final String tag$1;

            public final Iterable<Attribute> apply(AlignmentRecord x$7) {
                return Option$.MODULE$.option2Iterable(RichAlignmentRecord$.MODULE$.apply(x$7).tags().find((Function1)new Serializable(this){
                    private final /* synthetic */ $anonfun$adamCharacterizeTagValues$1 $outer;

                    public final boolean apply(Attribute x$8) {
                        String string = x$8.tag();
                        String string2 = this.$outer.tag$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(Attribute.class)).map((Function1)new Serializable(this){

            public final scala.collection.immutable.Map<Object, Object> apply(Attribute attr) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(attr.value()), (Object)BoxesRunTime.boxToLong((long)1L))}));
            }
        }, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class)).reduce((Function2)new Serializable(this){

            public final scala.collection.immutable.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> map1, scala.collection.immutable.Map<Object, Object> map2) {
                return MapTools$.MODULE$.add(map1, map2, Numeric.LongIsIntegral$.MODULE$);
            }
        });
    }

    public RDD<AlignmentRecord> adamFilterRecordsWithTag(String tagName) {
        Predef$.MODULE$.assert(tagName.length() == 2, (Function0)new Serializable(this, tagName){
            private final String tagName$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("withAttribute takes a tagName argument of length 2; tagName=\"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tagName$1}));
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
        return this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.filter((Function1)new Serializable(this, tagName){
            public final String tagName$1;

            public final boolean apply(AlignmentRecord x$9) {
                return RichAlignmentRecord$.MODULE$.apply(x$9).tags().exists((Function1)new Serializable(this){
                    private final /* synthetic */ $anonfun$adamFilterRecordsWithTag$2 $outer;

                    public final boolean apply(Attribute x$10) {
                        String string = x$10.tag();
                        String string2 = this.$outer.tagName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
    }

    public void adamSaveAsPairedFastq(String fileName1, String fileName2, boolean outputOriginalBaseQualities, ValidationStringency validationStringency, Option<StorageLevel> persistLevel) {
        this.maybePersist$1(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd, persistLevel);
        long numRecords = this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.count();
        RDD readsByID = this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.groupBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord record) {
                return AlignmentRecordConverter$.MODULE$.readNameHasPairedSuffix(record) ? (String)new StringOps(Predef$.MODULE$.augmentString(record.getReadName().toString())).dropRight(2) : record.getReadName().toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        ValidationStringency validationStringency2 = validationStringency;
        ValidationStringency validationStringency3 = ValidationStringency.STRICT;
        if (!(validationStringency2 != null ? !validationStringency2.equals(validationStringency3) : validationStringency3 != null)) {
            RDD readIDsWithCounts = MetricsContext$.MODULE$.rddToInstrumentedPairRDD(readsByID, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)new Serializable(this){

                public final int apply(Iterable<AlignmentRecord> x$13) {
                    return x$13.size();
                }
            });
            RDD unpairedReadIDsWithCounts = readIDsWithCounts.filter((Function1)new Serializable(this){

                public final boolean apply(Tuple2<String, Object> x$14) {
                    return x$14._2$mcI$sp() != 2;
                }
            });
            this.maybePersist$1(unpairedReadIDsWithCounts, persistLevel);
            long numUnpairedReadIDsWithCounts = unpairedReadIDsWithCounts.count();
            if (numUnpairedReadIDsWithCounts != 0L) {
                Map readNameOccurrencesMap = unpairedReadIDsWithCounts.map((Function1)new Serializable(this){

                    public final int apply(Tuple2<String, Object> x$15) {
                        return x$15._2$mcI$sp();
                    }
                }, ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
                throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Found %d read names that don't occur exactly twice:\n%s\n\nSamples:\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numUnpairedReadIDsWithCounts), ((TraversableOnce)readNameOccurrencesMap.map((Function1)new Serializable(this){

                    public final String apply(Tuple2<Object, Object> p) {
                        return new StringOps(Predef$.MODULE$.augmentString("%dx:\t%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)p._1$mcI$sp()), BoxesRunTime.boxToLong((long)p._2$mcJ$sp())}));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", ""), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])unpairedReadIDsWithCounts.take(100)).map((Function1)new Serializable(this){

                    public final String apply(Tuple2<String, Object> x$16) {
                        return (String)x$16._1();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\t", "\n\t", "")})));
            }
        }
        RDD pairedRecords = readsByID.filter((Function1)new Serializable(this){

            public final boolean apply(Tuple2<String, Iterable<AlignmentRecord>> x$17) {
                return ((TraversableOnce)x$17._2()).size() == 2;
            }
        }).map((Function1)new Serializable(this){

            public final Iterable<AlignmentRecord> apply(Tuple2<String, Iterable<AlignmentRecord>> x$18) {
                return (Iterable)x$18._2();
            }
        }, ClassTag$.MODULE$.apply(Iterable.class)).flatMap((Function1)new Serializable(this){

            public final Iterable<AlignmentRecord> apply(Iterable<AlignmentRecord> x) {
                return x;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        this.maybePersist$1(pairedRecords, persistLevel);
        long numPairedRecords = pairedRecords.count();
        this.maybeUnpersist$1(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.unpersist(this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.unpersist$default$1()), persistLevel);
        RDD firstInPairRecords = pairedRecords.filter((Function1)new Serializable(this){

            public final boolean apply(AlignmentRecord x$19) {
                return Predef$.MODULE$.Boolean2boolean(x$19.getFirstOfPair());
            }
        });
        this.maybePersist$1(firstInPairRecords, persistLevel);
        long numFirstInPairRecords = firstInPairRecords.count();
        RDD secondInPairRecords = pairedRecords.filter((Function1)new Serializable(this){

            public final boolean apply(AlignmentRecord x$20) {
                return Predef$.MODULE$.Boolean2boolean(x$20.getSecondOfPair());
            }
        });
        this.maybePersist$1(secondInPairRecords, persistLevel);
        long numSecondInPairRecords = secondInPairRecords.count();
        this.maybeUnpersist$1(pairedRecords, persistLevel);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("%d/%d records are properly paired: %d firsts, %d seconds")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numPairedRecords), BoxesRunTime.boxToLong((long)numRecords), BoxesRunTime.boxToLong((long)numFirstInPairRecords), BoxesRunTime.boxToLong((long)numSecondInPairRecords)})));
        ValidationStringency validationStringency4 = validationStringency;
        ValidationStringency validationStringency5 = ValidationStringency.STRICT;
        if (!(validationStringency4 != null ? !validationStringency4.equals(validationStringency5) : validationStringency5 != null)) {
            firstInPairRecords.foreach((Function1)new Serializable(this){

                public final void apply(AlignmentRecord read) {
                    if (Predef$.MODULE$.Boolean2boolean(read.getSecondOfPair())) {
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Read %s found with first- and second-of-pair set")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{read.getReadName()})));
                    }
                }
            });
            secondInPairRecords.foreach((Function1)new Serializable(this){

                public final void apply(AlignmentRecord read) {
                    if (Predef$.MODULE$.Boolean2boolean(read.getFirstOfPair())) {
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Read %s found with first- and second-of-pair set")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{read.getReadName()})));
                    }
                }
            });
        }
        Predef$.MODULE$.assert(numFirstInPairRecords == numSecondInPairRecords, (Function0)new Serializable(this, numFirstInPairRecords, numSecondInPairRecords){
            private final long numFirstInPairRecords$1;
            private final long numSecondInPairRecords$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Different numbers of first- and second-reads: %d vs. %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numFirstInPairRecords$1), BoxesRunTime.boxToLong((long)this.numSecondInPairRecords$1)}));
            }
            {
                this.numFirstInPairRecords$1 = numFirstInPairRecords$1;
                this.numSecondInPairRecords$1 = numSecondInPairRecords$1;
            }
        });
        AlignmentRecordConverter arc = new AlignmentRecordConverter();
        firstInPairRecords.sortBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$21) {
                return x$21.getReadName().toString();
            }
        }, firstInPairRecords.sortBy$default$2(), firstInPairRecords.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this, outputOriginalBaseQualities, arc){
            private final boolean outputOriginalBaseQualities$2;
            private final AlignmentRecordConverter arc$1;

            public final String apply(AlignmentRecord record) {
                return this.arc$1.convertToFastq(record, true, this.outputOriginalBaseQualities$2);
            }
            {
                this.outputOriginalBaseQualities$2 = outputOriginalBaseQualities$2;
                this.arc$1 = arc$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName1);
        secondInPairRecords.sortBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$22) {
                return x$22.getReadName().toString();
            }
        }, secondInPairRecords.sortBy$default$2(), secondInPairRecords.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this, outputOriginalBaseQualities, arc){
            private final boolean outputOriginalBaseQualities$2;
            private final AlignmentRecordConverter arc$1;

            public final String apply(AlignmentRecord record) {
                return this.arc$1.convertToFastq(record, true, this.outputOriginalBaseQualities$2);
            }
            {
                this.outputOriginalBaseQualities$2 = outputOriginalBaseQualities$2;
                this.arc$1 = arc$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName2);
        this.maybeUnpersist$1(firstInPairRecords, persistLevel);
        this.maybeUnpersist$1(secondInPairRecords, persistLevel);
    }

    public boolean adamSaveAsPairedFastq$default$3() {
        return false;
    }

    public ValidationStringency adamSaveAsPairedFastq$default$4() {
        return ValidationStringency.LENIENT;
    }

    public Option<StorageLevel> adamSaveAsPairedFastq$default$5() {
        return None$.MODULE$;
    }

    public void adamSaveAsFastq(String fileName, Option<String> fileName2Opt, boolean outputOriginalBaseQualities, boolean sort, ValidationStringency validationStringency, Option<StorageLevel> persistLevel) {
        this.log().info("Saving data in FASTQ format.");
        Option<String> option = fileName2Opt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String fileName2 = (String)some.x();
            this.adamSaveAsPairedFastq(fileName, fileName2, outputOriginalBaseQualities, validationStringency, persistLevel);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AlignmentRecordConverter arc = new AlignmentRecordConverter();
            RDD outputRdd = sort || fileName2Opt.isDefined() ? this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.sortBy((Function1)new Serializable(this){

                public final String apply(AlignmentRecord x$23) {
                    return x$23.getReadName().toString();
                }
            }, this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.sortBy$default$2(), this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)) : this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd;
            outputRdd.map((Function1)new Serializable(this, outputOriginalBaseQualities, arc){
                private final boolean outputOriginalBaseQualities$1;
                private final AlignmentRecordConverter arc$2;

                public final String apply(AlignmentRecord record) {
                    AlignmentRecord x$53 = record;
                    boolean x$54 = this.outputOriginalBaseQualities$1;
                    boolean x$55 = this.arc$2.convertToFastq$default$2();
                    return this.arc$2.convertToFastq(x$53, x$55, x$54);
                }
                {
                    this.outputOriginalBaseQualities$1 = outputOriginalBaseQualities$1;
                    this.arc$2 = arc$2;
                }
            }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<String> adamSaveAsFastq$default$2() {
        return None$.MODULE$;
    }

    public boolean adamSaveAsFastq$default$3() {
        return false;
    }

    public boolean adamSaveAsFastq$default$4() {
        return false;
    }

    public ValidationStringency adamSaveAsFastq$default$5() {
        return ValidationStringency.LENIENT;
    }

    public Option<StorageLevel> adamSaveAsFastq$default$6() {
        return None$.MODULE$;
    }

    public RDD<AlignmentRecord> adamRePairReads(RDD<AlignmentRecord> secondPairRdd, ValidationStringency validationStringency) {
        RDD firstPairRdd = this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd.cache();
        secondPairRdd.cache();
        RDD firstRDDKeyedByReadName = firstPairRdd.keyBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$24) {
                return (String)new StringOps(Predef$.MODULE$.augmentString(x$24.getReadName().toString())).dropRight(2);
            }
        });
        RDD secondRDDKeyedByReadName = secondPairRdd.keyBy((Function1)new Serializable(this){

            public final String apply(AlignmentRecord x$25) {
                return (String)new StringOps(Predef$.MODULE$.augmentString(x$25.getReadName().toString())).dropRight(2);
            }
        });
        ValidationStringency validationStringency2 = validationStringency;
        ValidationStringency validationStringency3 = ValidationStringency.STRICT;
        RDD joinedRDD = !(validationStringency2 != null ? !validationStringency2.equals(validationStringency3) : validationStringency3 != null) ? MetricsContext$.MODULE$.rddToInstrumentedPairRDD(firstRDDKeyedByReadName, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), (Ordering)Ordering.String$.MODULE$).cogroup(secondRDDKeyedByReadName).map((Function1)new Serializable(this){

            public final Tuple2<String, Tuple2<AlignmentRecord, AlignmentRecord>> apply(Tuple2<String, Tuple2<Iterable<AlignmentRecord>, Iterable<AlignmentRecord>>> x0$1) {
                Tuple2<String, Tuple2<Iterable<AlignmentRecord>, Iterable<AlignmentRecord>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String readName = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Iterable firstReads = (Iterable)tuple22._1();
                        Iterable secondReads = (Iterable)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)firstReads.toList(), (Object)secondReads.toList());
                        if (tuple23 != null) {
                            List list = (List)tuple23._1();
                            List list2 = (List)tuple23._2();
                            if (list instanceof .colon.colon) {
                                .colon.colon colon2 = (.colon.colon)list;
                                AlignmentRecord firstRead = (AlignmentRecord)colon2.head();
                                List list3 = colon2.tl$1();
                                if (Nil$.MODULE$.equals(list3) && list2 instanceof .colon.colon) {
                                    .colon.colon colon3 = (.colon.colon)list2;
                                    AlignmentRecord secondRead = (AlignmentRecord)colon3.head();
                                    List list4 = colon3.tl$1();
                                    if (Nil$.MODULE$.equals(list4)) {
                                        Tuple2 tuple24;
                                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)readName, (Object)new Tuple2((Object)firstRead, (Object)secondRead));
                                        return tuple25;
                                    }
                                }
                            }
                        }
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Expected %d first reads and %d second reads for name %s; expected exactly one of each:\n%s\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstReads.size()), BoxesRunTime.boxToInteger((int)secondReads.size()), readName, ((TraversableOnce)firstReads.map((Function1)new Serializable(this){

                            public final String apply(AlignmentRecord x$26) {
                                return x$26.getReadName().toString();
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", ""), ((TraversableOnce)secondReads.map((Function1)new Serializable(this){

                            public final String apply(AlignmentRecord x$27) {
                                return x$27.getReadName().toString();
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", "")})));
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)) : MetricsContext$.MODULE$.rddToInstrumentedPairRDD(firstRDDKeyedByReadName, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), (Ordering)Ordering.String$.MODULE$).join(secondRDDKeyedByReadName);
        RDD finalRdd = joinedRDD.flatMap((Function1)new Serializable(this){

            public final Seq<AlignmentRecord> apply(Tuple2<String, Tuple2<AlignmentRecord, AlignmentRecord>> kv) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{AlignmentRecord.newBuilder((AlignmentRecord)((AlignmentRecord)((Tuple2)kv._2())._1())).setReadPaired(Predef$.MODULE$.boolean2Boolean(true)).setProperPair(Predef$.MODULE$.boolean2Boolean(true)).setFirstOfPair(Predef$.MODULE$.boolean2Boolean(true)).setSecondOfPair(Predef$.MODULE$.boolean2Boolean(false)).build(), AlignmentRecord.newBuilder((AlignmentRecord)((AlignmentRecord)((Tuple2)kv._2())._2())).setReadPaired(Predef$.MODULE$.boolean2Boolean(true)).setProperPair(Predef$.MODULE$.boolean2Boolean(true)).setFirstOfPair(Predef$.MODULE$.boolean2Boolean(false)).setSecondOfPair(Predef$.MODULE$.boolean2Boolean(true)).build()}));
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        firstPairRdd.unpersist(firstPairRdd.unpersist$default$1());
        secondPairRdd.unpersist(secondPairRdd.unpersist$default$1());
        return finalRdd;
    }

    public ValidationStringency adamRePairReads$default$2() {
        return ValidationStringency.LENIENT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$overlapsQuery$1(AlignmentRecord rec, ReferenceRegion query$1) {
        if (!Predef$.MODULE$.Boolean2boolean(rec.getReadMapped())) return false;
        String string = rec.getContig().getContigName().toString();
        String string2 = query$1.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (Predef$.MODULE$.Long2long(rec.getStart()) >= query$1.end()) return false;
        if (Predef$.MODULE$.Long2long(rec.getEnd()) <= query$1.start()) return false;
        return true;
    }

    private final void maybePersist$1(RDD r, Option persistLevel$1) {
        persistLevel$1.foreach((Function1)new Serializable(this, r){
            private final RDD r$1;

            public final RDD<T> apply(StorageLevel x$11) {
                return this.r$1.persist(x$11);
            }
            {
                this.r$1 = r$1;
            }
        });
    }

    private final void maybeUnpersist$1(RDD r, Option persistLevel$1) {
        persistLevel$1.foreach((Function1)new Serializable(this, r){
            private final RDD r$2;

            public final RDD<T> apply(StorageLevel x$12) {
                return this.r$2.unpersist(this.r$2.unpersist$default$1());
            }
            {
                this.r$2 = r$2;
            }
        });
    }

    public AlignmentRecordRDDFunctions(RDD<AlignmentRecord> rdd) {
        this.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$rdd = rdd;
        super(rdd);
    }
}

