/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.TagList;

public final class Metric {
    private final MonitorConfig config;
    private final long timestamp;
    private final Object value;

    public Metric(String name, TagList tags, long timestamp, Object value) {
        this(new MonitorConfig.Builder(name).withTags(tags).build(), timestamp, value);
    }

    public Metric(MonitorConfig config, long timestamp, Object value) {
        this.config = (MonitorConfig)Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        this.timestamp = timestamp;
        this.value = Preconditions.checkNotNull((Object)value, (String)"value cannot be null (config=%s)", (Object[])new Object[]{config});
    }

    public MonitorConfig getConfig() {
        return this.config;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Number getNumberValue() {
        return (Number)this.value;
    }

    public boolean hasNumberValue() {
        return this.value instanceof Number;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Metric)) {
            return false;
        }
        Metric m = (Metric)obj;
        return this.config.equals(m.getConfig()) && this.timestamp == m.getTimestamp() && this.value.equals(m.getValue());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.timestamp, this.value});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("timestamp", this.timestamp).add("value", this.value).toString();
    }
}

