/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.util.List;

public class BinningIndexBuilder {
    private final int referenceSequence;
    private final Bin[] bins;
    private int binsSeen = 0;
    private final long[] index = new long[LinearIndex.MAX_LINEAR_INDEX_SIZE];
    private int largestIndexSeen = -1;

    public BinningIndexBuilder(int n, int n2) {
        this.referenceSequence = n;
        int n3 = n2 <= 0 ? 37451 : AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(n2) + 1;
        this.bins = new Bin[n3];
    }

    public BinningIndexBuilder(int n) {
        this(n, 0);
    }

    public void processFeature(FeatureToBeIndexed featureToBeIndexed) {
        Bin bin;
        int n;
        Integer n2 = featureToBeIndexed.getIndexingBin();
        int n3 = n = n2 == null ? this.computeIndexingBin(featureToBeIndexed) : n2.intValue();
        if (this.bins[n] != null) {
            bin = this.bins[n];
        } else {
            this.bins[n] = bin = new Bin(this.referenceSequence, n);
            ++this.binsSeen;
        }
        Chunk chunk = featureToBeIndexed.getChunk();
        long l = chunk.getChunkStart();
        long l2 = chunk.getChunkEnd();
        List<Chunk> list = bin.getChunkList();
        if (!bin.containsChunks()) {
            bin.addInitialChunk(chunk);
        } else {
            Chunk chunk2 = bin.getLastChunk();
            if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(chunk2.getChunkEnd(), l)) {
                chunk2.setChunkEnd(l2);
            } else {
                list.add(chunk);
                bin.setLastChunk(chunk);
            }
        }
        int n4 = featureToBeIndexed.getEnd();
        int n5 = LinearIndex.convertToLinearIndexOffset(featureToBeIndexed.getStart());
        int n6 = n4 == 0 ? (n5 = LinearIndex.convertToLinearIndexOffset(featureToBeIndexed.getStart() - 1)) : LinearIndex.convertToLinearIndexOffset(n4);
        if (n6 > this.largestIndexSeen) {
            this.largestIndexSeen = n6;
        }
        for (int i = n5; i <= n6; ++i) {
            if (this.index[i] != 0L && l >= this.index[i]) continue;
            this.index[i] = l;
        }
    }

    public BinningIndexContent generateIndexContent() {
        if (this.binsSeen == 0) {
            return null;
        }
        long[] lArray = new long[this.largestIndexSeen + 1];
        long l = 0L;
        for (int i = 0; i <= this.largestIndexSeen; ++i) {
            if (this.index[i] == 0L) {
                this.index[i] = l;
            } else {
                l = this.index[i];
            }
            lArray[i] = this.index[i];
        }
        LinearIndex linearIndex = new LinearIndex(this.referenceSequence, 0, lArray);
        return new BinningIndexContent(this.referenceSequence, new BinningIndexContent.BinList(this.bins, this.binsSeen), linearIndex);
    }

    private int computeIndexingBin(FeatureToBeIndexed featureToBeIndexed) {
        int n = featureToBeIndexed.getStart() - 1;
        int n2 = featureToBeIndexed.getEnd();
        if (n2 <= 0) {
            n2 = n + 1;
        }
        return GenomicIndexUtil.reg2bin(n, n2);
    }

    public static interface FeatureToBeIndexed {
        public int getStart();

        public int getEnd();

        public Integer getIndexingBin();

        public Chunk getChunk();
    }
}

