/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ReadNameFilter
implements SamRecordFilter {
    private boolean includeReads = false;
    private Set<String> readNameFilterSet = new HashSet<String>();

    public ReadNameFilter(File file, boolean bl) {
        IOUtil.assertFileIsReadable(file);
        IOUtil.assertFileSizeNonZero(file);
        try {
            BufferedReader bufferedReader = IOUtil.openFileForBufferedReading(file);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().isEmpty()) continue;
                this.readNameFilterSet.add(string.split("\\s+")[0]);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new SAMException(iOException.getMessage(), iOException);
        }
        this.includeReads = bl;
    }

    public ReadNameFilter(Set<String> set, boolean bl) {
        this.readNameFilterSet = set;
        this.includeReads = bl;
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord) {
        return !(this.includeReads ? this.readNameFilterSet.contains(sAMRecord.getReadName()) : !this.readNameFilterSet.contains(sAMRecord.getReadName()));
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return !(this.includeReads ? this.readNameFilterSet.contains(sAMRecord.getReadName()) && this.readNameFilterSet.contains(sAMRecord2.getReadName()) : !this.readNameFilterSet.contains(sAMRecord.getReadName()) && !this.readNameFilterSet.contains(sAMRecord2.getReadName()));
    }
}

