/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.TabixFeatureReader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.TribbleIndexedFeatureReader;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.util.ParsingUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractFeatureReader<T extends Feature, SOURCE>
implements FeatureReader<T> {
    String path;
    protected final FeatureCodec<T, SOURCE> codec;
    protected FeatureCodecHeader header;
    private static ComponentMethods methods = new ComponentMethods();
    public static final Set<String> BLOCK_COMPRESSED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".gz", ".gzip", ".bgz", ".bgzf")));

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String string, FeatureCodec<FEATURE, SOURCE> featureCodec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(string, featureCodec, true);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String string, FeatureCodec<FEATURE, SOURCE> featureCodec, boolean bl) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(string, null, featureCodec, bl);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String string, String string2, FeatureCodec<FEATURE, SOURCE> featureCodec, boolean bl) throws TribbleException {
        try {
            if (methods.isTabix(string, string2)) {
                if (!(featureCodec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + featureCodec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(string, string2, (AsciiFeatureCodec)featureCodec);
            }
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(string, string2, featureCodec, bl);
        }
        catch (IOException iOException) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", string, iOException);
        }
        catch (TribbleException tribbleException) {
            tribbleException.setSource(string);
            throw tribbleException;
        }
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String string, FeatureCodec<FEATURE, SOURCE> featureCodec, Index index) throws TribbleException {
        try {
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(string, featureCodec, index);
        }
        catch (IOException iOException) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", string, iOException);
        }
    }

    protected AbstractFeatureReader(String string, FeatureCodec<T, SOURCE> featureCodec) {
        this.path = string;
        this.codec = featureCodec;
    }

    public boolean hasIndex() {
        return false;
    }

    public static void setComponentMethods(ComponentMethods componentMethods) {
        methods = componentMethods;
    }

    public static boolean hasBlockCompressedExtension(String string) {
        for (String string2 : BLOCK_COMPRESSED_EXTENSIONS) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBlockCompressedExtension(File file) {
        return AbstractFeatureReader.hasBlockCompressedExtension(file.getName());
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    public static class ComponentMethods {
        public boolean isTabix(String string, String string2) throws IOException {
            if (string2 == null) {
                string2 = ParsingUtils.appendToPath(string, ".tbi");
            }
            return AbstractFeatureReader.hasBlockCompressedExtension(string) && ParsingUtils.resourceExists(string2);
        }
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

