/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;

public enum VCFFormat {
    VCF,
    BCF;


    public static VCFFormat inferFromFilePath(Path path) {
        return VCFFormat.inferFromFilePath(path.getName());
    }

    public static VCFFormat inferFromFilePath(String name) {
        if (name.endsWith(".bcf")) {
            return BCF;
        }
        if (name.endsWith(".vcf")) {
            return VCF;
        }
        return null;
    }

    public static VCFFormat inferFromData(InputStream in) throws IOException {
        byte b = (byte)in.read();
        in.close();
        switch (b) {
            case 31: {
                return BCF;
            }
            case 66: {
                return BCF;
            }
            case 35: {
                return VCF;
            }
        }
        return null;
    }
}

