/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.cli.CLIMRPlugin;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;

public abstract class CLIMRBAMPlugin
extends CLIMRPlugin {
    protected SAMFormat samFormat = null;
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    protected static final CmdLineParser.Option formatOpt = new CmdLineParser.Option.StringOption('F', "format=FMT");
    protected static final CmdLineParser.Option noTrustExtsOpt = new CmdLineParser.Option.BooleanOption("no-trust-exts");

    protected CLIMRBAMPlugin(String commandName, String description, String version, String usageParams, List<Pair<CmdLineParser.Option, String>> optionDescs, String longDescription) {
        super(commandName, description, version, usageParams, optionDescs == null ? CLIMRBAMPlugin.optionDescs : (optionDescs.addAll(CLIMRBAMPlugin.optionDescs) ? optionDescs : optionDescs), longDescription);
    }

    @Override
    public boolean cacheAndSetProperties(CmdLineParser parser) {
        if (!super.cacheAndSetProperties(parser)) {
            return false;
        }
        if (!this.cacheSAMFormat(parser)) {
            return false;
        }
        Configuration conf = this.getConf();
        conf.setBoolean("hadoopbam.anysam.trust-exts", !parser.getBoolean(noTrustExtsOpt));
        conf.setBoolean("hadoopbam.anysam.write-header", this.outPath == null);
        return true;
    }

    private boolean cacheSAMFormat(CmdLineParser parser) {
        String f = (String)parser.getOptionValue(formatOpt);
        if (f != null) {
            try {
                this.samFormat = SAMFormat.valueOf(f.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                System.err.printf("%s :: invalid format '%s'\n", this.getCommandName(), f);
                return false;
            }
        }
        if (this.samFormat == null) {
            this.samFormat = this.outPath == null ? SAMFormat.BAM : SAMFormat.inferFromFilePath(this.outPath);
        }
        this.getConf().set("hadoopbam.anysam.output-format", this.samFormat.toString());
        return true;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(noTrustExtsOpt, "detect SAM/BAM files only by contents, never by file extension"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(formatOpt, "select the output format based on FMT: SAM or BAM"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(outputPathOpt, "output a complete SAM/BAM file to the file PATH, removing the parts from WORKDIR; SAM/BAM is chosen by file extension, if appropriate (but -F takes precedence)"));
    }
}

