/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins.chipster;

import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.seqdoop.hadoop_bam.cli.CLIMRPlugin;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.Range;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.RangeCount;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SummarizeInputFormat;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SummarizeOutputFormat;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SummarizeReducer;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.SummarySort;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.Timer;

public final class Summarize
extends CLIMRPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    private static final CmdLineParser.Option sortOpt = new CmdLineParser.Option.BooleanOption('s', "sort");
    private static final CmdLineParser.Option noTrustExtsOpt = new CmdLineParser.Option.BooleanOption("no-trust-exts");
    private final Timer t = new Timer();
    private String[] levels;
    private Path wrkDir;
    private Path mainSortOutputDir;
    private String wrkFile;
    private boolean sorted = false;

    public Summarize() {
        super("summarize", "summarize SAM or BAM for zooming", "3.1", "WORKDIR LEVELS INPATH", optionDescs, "Outputs, for each level in LEVELS, a summary file describing the average number of alignments at various positions in the SAM or BAM file in INPATH. The summary files are placed in parts in WORKDIR.\n\nLEVELS should be a comma-separated list of positive integers. Each level is the number of alignments that are summarized into one group.");
    }

    private int missingArg(String s) {
        System.err.printf("summarize :: %s not given.\n", s);
        return 3;
    }

    @Override
    protected int run(CmdLineParser parser) {
        block32: {
            List<String> args = parser.getRemainingArgs();
            switch (args.size()) {
                case 0: {
                    return this.missingArg("WORKDIR");
                }
                case 1: {
                    return this.missingArg("LEVELS");
                }
                case 2: {
                    return this.missingArg("INPATH");
                }
            }
            if (!this.cacheAndSetProperties(parser)) {
                return 3;
            }
            for (String l : this.levels = args.get(1).split(",")) {
                try {
                    int lvl = Integer.parseInt(l);
                    if (lvl > 0) continue;
                    System.err.printf("summarize :: summary level '%d' is not positive!\n", lvl);
                }
                catch (NumberFormatException e) {
                    System.err.printf("summarize :: summary level '%s' is not an integer!\n", l);
                }
                return 3;
            }
            this.wrkDir = new Path(args.get(0));
            Path bam = new Path(args.get(2));
            boolean sort = parser.getBoolean(sortOpt);
            Configuration conf = this.getConf();
            conf.setBoolean("hadoopbam.anysam.trust-exts", !parser.getBoolean(noTrustExtsOpt));
            this.wrkFile = bam.getName();
            conf.set("hadoopbam.work.filename", this.wrkFile);
            conf.setStrings("summarize.summary.levels", this.levels);
            try {
                try {
                    this.wrkDir = this.wrkDir.getFileSystem(conf).makeQualified(this.wrkDir);
                    Path path = this.mainSortOutputDir = sort ? new Path(this.wrkDir, "sorted.tmp") : null;
                    if (!this.runSummary(bam)) {
                        return 4;
                    }
                }
                catch (IOException e) {
                    System.err.printf("summarize :: Summarizing failed: %s\n", e);
                    return 4;
                }
                Path mergedTmpDir = null;
                try {
                    if (sort) {
                        mergedTmpDir = new Path(this.wrkDir, "sort.tmp");
                        this.mergeOutputs(mergedTmpDir);
                    } else if (this.outPath != null) {
                        this.mergeOutputs(this.outPath);
                    }
                }
                catch (IOException e) {
                    System.err.printf("summarize :: Merging failed: %s\n", e);
                    return 5;
                }
                if (!sort) break block32;
                if (!this.doSorting(mergedTmpDir)) {
                    return 6;
                }
                conf.set("hadoopbam.work.filename", this.wrkFile);
                this.tryDelete(mergedTmpDir);
                if (this.outPath != null) {
                    try {
                        this.sorted = true;
                        this.mergeOutputs(this.outPath);
                    }
                    catch (IOException e) {
                        System.err.printf("summarize :: Merging sorted output failed: %s\n", e);
                        return 7;
                    }
                }
                System.out.println("summarize :: Moving outputs from temporary directories...");
                this.t.start();
                try {
                    FileSystem fs = this.wrkDir.getFileSystem(conf);
                    for (String lvl : this.levels) {
                        FileStatus[] parts;
                        try {
                            parts = fs.globStatus(new Path(new Path(this.mainSortOutputDir, lvl + "[fr]"), "*-[0-9][0-9][0-9][0-9][0-9][0-9]"));
                        }
                        catch (IOException e) {
                            System.err.printf("summarize :: Couldn't move level %s results: %s", lvl, e);
                            continue;
                        }
                        for (FileStatus part : parts) {
                            Path path = part.getPath();
                            try {
                                fs.rename(path, new Path(this.wrkDir, path.getName()));
                            }
                            catch (IOException e) {
                                System.err.printf("summarize :: Couldn't move '%s': %s", path, e);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    System.err.printf("summarize :: Moving results failed: %s", e);
                }
                System.out.printf("summarize :: Moved in %d.%03d s.\n", this.t.stopS(), this.t.fms());
                this.tryDelete(this.mainSortOutputDir);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return 0;
    }

    private boolean runSummary(Path bamPath) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = this.getConf();
        Utils.configureSampling(this.wrkDir, bamPath.getName(), conf);
        Job job = new Job(conf);
        job.setJarByClass(Summarize.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(SummarizeReducer.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(Range.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(RangeCount.class);
        job.setInputFormatClass(SummarizeInputFormat.class);
        job.setOutputFormatClass(SummarizeOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{bamPath});
        FileOutputFormat.setOutputPath((Job)job, (Path)this.wrkDir);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        System.out.println("summarize :: Sampling...");
        this.t.start();
        InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new InputSampler.RandomSampler(0.01, 10000, Math.max(100, this.reduceTasks)));
        System.out.printf("summarize :: Sampling complete in %d.%03d s.\n", this.t.stopS(), this.t.fms());
        for (String lvl : this.levels) {
            MultipleOutputs.addNamedOutput((Job)job, (String)Summarize.getSummaryName(lvl, false), SummarizeOutputFormat.class, NullWritable.class, Range.class);
            MultipleOutputs.addNamedOutput((Job)job, (String)Summarize.getSummaryName(lvl, true), SummarizeOutputFormat.class, NullWritable.class, Range.class);
        }
        job.submit();
        System.out.println("summarize :: Waiting for job completion...");
        this.t.start();
        if (!job.waitForCompletion(this.verbose)) {
            System.err.println("summarize :: Job failed.");
            return false;
        }
        System.out.printf("summarize :: Job complete in %d.%03d s.\n", this.t.stopS(), this.t.fms());
        return true;
    }

    private void mergeOutputs(Path out) throws IOException {
        System.out.println("summarize :: Merging output...");
        this.t.start();
        Configuration conf = this.getConf();
        FileSystem srcFS = this.wrkDir.getFileSystem(conf);
        FileSystem dstFS = out.getFileSystem(conf);
        Timer tl = new Timer();
        for (String l : this.levels) {
            this.mergeOne(l, false, out, srcFS, dstFS, tl);
            this.mergeOne(l, true, out, srcFS, dstFS, tl);
        }
        System.out.printf("summarize :: Merging complete in %d.%03d s.\n", this.t.stopS(), this.t.fms());
    }

    private void mergeOne(String lvl, boolean reverseStrand, Path out, FileSystem srcFS, FileSystem dstFS, Timer t) throws IOException {
        t.start();
        char strand = reverseStrand ? (char)'r' : 'f';
        FSDataOutputStream outs = dstFS.create(new Path(out, this.getFinalSummaryName(lvl, reverseStrand)));
        Utils.mergeInto((OutputStream)outs, this.sorted ? this.getSortOutputDir(lvl, strand) : this.wrkDir, "", "-" + Summarize.getSummaryName(lvl, reverseStrand), this.getConf(), null);
        outs.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        outs.close();
        System.out.printf("summarize :: Merged %s%c in %d.%03d s.\n", lvl, Character.valueOf(strand), t.stopS(), t.fms());
    }

    private boolean doSorting(Path inputDir) throws ClassNotFoundException, InterruptedException {
        int i;
        Configuration conf = this.getConf();
        Job[] jobs = new Job[2 * this.levels.length];
        boolean errors = false;
        for (i = 0; i < this.levels.length; ++i) {
            String lvl = this.levels[i];
            try {
                jobs[2 * i] = SummarySort.sortOne(conf, new Path(inputDir, this.getFinalSummaryName(lvl, false)), this.getSortOutputDir(lvl, 'f'), "summarize", " for sorting " + lvl + 'f');
                jobs[2 * i + 1] = SummarySort.sortOne(conf, new Path(inputDir, this.getFinalSummaryName(lvl, true)), this.getSortOutputDir(lvl, 'r'), "summarize", " for sorting " + lvl + 'r');
                continue;
            }
            catch (IOException e) {
                System.err.printf("summarize :: Submitting sorting job %s failed: %s\n", lvl, e);
                if (i == 0) {
                    return false;
                }
                errors = true;
            }
        }
        System.out.println("summarize :: Waiting for sorting jobs' completion...");
        this.t.start();
        for (i = 0; i < jobs.length; ++i) {
            char s;
            boolean success;
            try {
                success = jobs[i].waitForCompletion(this.verbose);
            }
            catch (IOException e) {
                success = false;
            }
            String l = this.levels[i / 2];
            char c = s = i % 2 == 0 ? (char)'f' : 'r';
            if (!success) {
                System.err.printf("summarize :: Sorting job for %s%c failed.\n", l, Character.valueOf(s));
                errors = true;
                continue;
            }
            System.out.printf("summarize :: Sorting job for %s%c complete.\n", l, Character.valueOf(s));
        }
        if (errors) {
            return false;
        }
        System.out.printf("summarize :: Jobs complete in %d.%03d s.\n", this.t.stopS(), this.t.fms());
        return true;
    }

    private String getFinalSummaryName(String lvl, boolean reverseStrand) {
        return this.wrkFile + "-" + Summarize.getSummaryName(lvl, reverseStrand);
    }

    static String getSummaryName(String lvl, boolean reverseStrand) {
        return "summary" + lvl + (reverseStrand ? (char)'r' : 'f');
    }

    private Path getSortOutputDir(String level, char strand) {
        return new Path(this.mainSortOutputDir, level + strand);
    }

    private void tryDelete(Path path) {
        try {
            path.getFileSystem(this.getConf()).delete(path, true);
        }
        catch (IOException e) {
            System.err.printf("summarize :: Warning: couldn't delete '%s': %s\n", path, e);
        }
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(outputPathOpt, "output complete summary files to the directory PATH, removing the parts from WORKDIR"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(sortOpt, "sort created summaries by position"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(noTrustExtsOpt, "detect SAM/BAM files only by contents, never by file extension"));
    }
}

