/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;

public class SeekableArrayStream
extends SeekableStream {
    private final byte[] arr;
    private int pos;

    public SeekableArrayStream(byte[] a) {
        this.arr = a;
        this.pos = 0;
    }

    public void close() {
    }

    public long length() {
        return this.arr.length;
    }

    public long position() {
        return this.pos;
    }

    public boolean eof() {
        return (long)this.pos == this.length();
    }

    public void seek(long lp) throws IOException {
        int p = (int)lp;
        if (p < 0 || p > this.arr.length) {
            throw new IOException("position " + p + " is out of bounds");
        }
        this.pos = p;
    }

    public int read(byte[] b, int off, int len) {
        if (this.eof()) {
            return -1;
        }
        len = Math.min(len, this.arr.length - this.pos);
        System.arraycopy(this.arr, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public int read() {
        return this.eof() ? -1 : this.arr[this.pos++];
    }

    public String getSource() {
        return null;
    }
}

