/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.cannoli.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class CommandBuilder
implements Serializable {
    private String executable;
    private String image;
    private Integer flankSize;
    private boolean sudo = false;
    private Long timeout;
    private final List<String> arguments = new ArrayList<String>();
    private final Map<String, String> environment = new HashMap<String, String>();
    private final List<String> files = new ArrayList<String>();
    private Map<String, String> mounts = new HashMap<String, String>();

    protected CommandBuilder() {
    }

    protected CommandBuilder(String executable) {
        this();
        this.setExecutable(executable);
    }

    public final CommandBuilder setExecutable(String executable) {
        Preconditions.checkNotNull((Object)executable);
        this.executable = executable;
        return this;
    }

    public final CommandBuilder setFlankSize(@Nullable Integer flankSize) {
        this.flankSize = flankSize;
        return this;
    }

    public final CommandBuilder setImage(String image) {
        Preconditions.checkNotNull((Object)image);
        this.image = image;
        return this;
    }

    public final CommandBuilder setSudo(boolean sudo) {
        this.sudo = sudo;
        return this;
    }

    public final CommandBuilder setTimeout(@Nullable Long timeout) {
        this.timeout = timeout;
        return this;
    }

    public final CommandBuilder setTimeout(long duration, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit));
        this.timeout = timeUnit.toSeconds(duration);
        return this;
    }

    public final CommandBuilder add(String ... arguments) {
        return this.addArguments(arguments);
    }

    public final CommandBuilder add(Iterable<String> arguments) {
        return this.addArguments(arguments);
    }

    public final CommandBuilder addArgument(String argument) {
        Preconditions.checkNotNull((Object)argument);
        this.arguments.add(argument);
        return this;
    }

    public final CommandBuilder addArguments(String ... arguments) {
        Preconditions.checkNotNull((Object)arguments);
        for (String argument : arguments) {
            this.arguments.add(argument);
        }
        return this;
    }

    public final CommandBuilder addArguments(Iterable<String> arguments) {
        Preconditions.checkNotNull(arguments);
        for (String argument : arguments) {
            this.arguments.add(argument);
        }
        return this;
    }

    public final CommandBuilder addEnvironment(String variable, String value) {
        Preconditions.checkNotNull((Object)variable);
        Preconditions.checkNotNull((Object)value);
        this.environment.put(variable, value);
        return this;
    }

    public final CommandBuilder addEnvironment(Map<String, String> environment) {
        Preconditions.checkNotNull(environment);
        this.environment.putAll(environment);
        return this;
    }

    public final CommandBuilder addFile(String file) {
        Preconditions.checkNotNull((Object)file);
        this.files.add(file);
        return this;
    }

    public final CommandBuilder addFiles(String ... files) {
        Preconditions.checkNotNull((Object)files);
        for (String file : files) {
            this.files.add(file);
        }
        return this;
    }

    public final CommandBuilder addFiles(Iterable<String> files) {
        Preconditions.checkNotNull(files);
        for (String file : files) {
            this.files.add(file);
        }
        return this;
    }

    public final CommandBuilder addMount(String mount) {
        return this.addMount(mount, mount);
    }

    public final CommandBuilder addMount(String source, String target) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        this.mounts.put(source, target);
        return this;
    }

    public final CommandBuilder addMounts(Map<String, String> mounts) {
        Preconditions.checkNotNull(mounts);
        this.mounts.putAll(mounts);
        return this;
    }

    public final String getExecutable() {
        return this.executable;
    }

    public final Integer getFlankSize() {
        return this.flankSize;
    }

    public final Optional<Integer> getOptFlankSize() {
        return Optional.ofNullable(this.flankSize);
    }

    public final String getImage() {
        return this.image;
    }

    public final Long getTimeout() {
        return this.timeout;
    }

    public final Optional<Long> getOptTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public final boolean getSudo() {
        return this.isSudo();
    }

    public final boolean isSudo() {
        return this.sudo;
    }

    public final List<String> getArguments() {
        return ImmutableList.copyOf(this.arguments);
    }

    public final Map<String, String> getEnvironment() {
        return ImmutableMap.copyOf(this.environment);
    }

    public final List<String> getFiles() {
        return ImmutableList.copyOf(this.files);
    }

    public final Map<String, String> getMounts() {
        return ImmutableMap.copyOf(this.mounts);
    }

    public final CommandBuilder reset() {
        this.executable = null;
        this.flankSize = null;
        this.image = null;
        this.sudo = false;
        this.timeout = null;
        this.arguments.clear();
        this.environment.clear();
        this.files.clear();
        this.mounts.clear();
        return this;
    }

    public abstract List<String> build();
}

