/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.cannoli.builder;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.bdgenomics.cannoli.builder.ContainerBuilder;

public final class DockerBuilder
extends ContainerBuilder {
    public DockerBuilder() {
    }

    public DockerBuilder(String executable) {
        super(executable);
    }

    public DockerBuilder(String executable, String image) {
        super(executable, image);
    }

    @Override
    protected List<String> getContainerCommands() {
        return ImmutableList.of((Object)"docker", (Object)"run", (Object)"-i");
    }

    @Override
    protected List<String> getRemoveArgument() {
        return ImmutableList.of((Object)"--rm");
    }

    @Override
    protected List<String> formatImage(String image) {
        return ImmutableList.of((Object)image);
    }

    @Override
    protected List<String> formatEnvironmentVariable(String variable, String value) {
        return Collections.emptyList();
    }

    @Override
    protected List<String> formatEnvironmentArgument(String variable, String value) {
        return ImmutableList.of((Object)"--env", (Object)(variable + "=" + value));
    }

    @Override
    protected List<String> formatMount(String source, String target) {
        return ImmutableList.of((Object)"-v", (Object)(source + ":" + target));
    }
}

