/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.cannoli.builder;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bdgenomics.cannoli.builder.ContainerBuilder;

public final class SingularityBuilder
extends ContainerBuilder {
    private static final Pattern SCHEME = Pattern.compile("^[^/:\\. ]+://(.*)");

    public SingularityBuilder() {
    }

    public SingularityBuilder(String executable) {
        super(executable);
    }

    public SingularityBuilder(String executable, String image) {
        super(executable);
        this.setImage(image);
    }

    @Override
    protected List<String> getContainerCommands() {
        return ImmutableList.of((Object)"singularity", (Object)"exec");
    }

    @Override
    protected List<String> getRemoveArgument() {
        return Collections.emptyList();
    }

    @Override
    protected List<String> formatEnvironmentVariable(String variable, String value) {
        return ImmutableList.of((Object)("SINGULARITYENV_" + variable + "=" + value));
    }

    @Override
    protected List<String> formatEnvironmentArgument(String variable, String value) {
        return Collections.emptyList();
    }

    @Override
    protected List<String> formatImage(String image) {
        if (image.startsWith("/")) {
            return ImmutableList.of((Object)image);
        }
        Matcher m = SCHEME.matcher(image);
        if (m.matches()) {
            return ImmutableList.of((Object)image);
        }
        return ImmutableList.of((Object)("docker://" + image));
    }

    @Override
    protected List<String> formatMount(String source, String target) {
        return ImmutableList.of((Object)"--bind", (Object)(source.equals(target) ? source : source + ":" + target));
    }
}

