/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.cannoli.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bdgenomics.cannoli.builder.CommandBuilder;

abstract class ContainerBuilder
extends CommandBuilder {
    protected ContainerBuilder() {
    }

    protected ContainerBuilder(String executable) {
        super(executable);
    }

    protected ContainerBuilder(String executable, String image) {
        super(executable);
        this.setImage(image);
    }

    protected abstract List<String> getContainerCommands();

    protected abstract List<String> getRemoveArgument();

    protected abstract List<String> formatEnvironmentVariable(String var1, String var2);

    protected abstract List<String> formatEnvironmentArgument(String var1, String var2);

    protected abstract List<String> formatImage(String var1);

    protected abstract List<String> formatMount(String var1, String var2);

    @Override
    public final List<String> build() {
        if (this.getExecutable() == null) {
            throw new IllegalStateException("executable must not be null");
        }
        if (this.getImage() == null) {
            throw new IllegalStateException("image must not be null");
        }
        ArrayList<String> command = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.getEnvironment().entrySet()) {
            command.addAll(this.formatEnvironmentVariable(e.getKey(), e.getValue()));
        }
        if (this.isSudo()) {
            command.add("sudo");
        }
        command.addAll(this.getContainerCommands());
        for (Map.Entry<String, String> e : this.getEnvironment().entrySet()) {
            command.addAll(this.formatEnvironmentArgument(e.getKey(), e.getValue()));
        }
        for (Map.Entry<String, String> e : this.getMounts().entrySet()) {
            command.addAll(this.formatMount(e.getKey(), e.getValue()));
        }
        command.addAll(this.getRemoveArgument());
        command.addAll(this.formatImage(this.getImage()));
        command.add(this.getExecutable());
        command.addAll(this.getArguments());
        return command;
    }
}

