/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.cannoli.cli;

import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.CollectionAccumulator;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.InFormatterCompanion;
import org.bdgenomics.adam.rdd.OutFormatter;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDD;
import org.bdgenomics.adam.rdd.read.BAMInFormatter$;
import org.bdgenomics.adam.rdd.variant.VCFOutFormatter;
import org.bdgenomics.adam.rdd.variant.VariantContextRDD;
import org.bdgenomics.cannoli.builder.CommandBuilder;
import org.bdgenomics.cannoli.builder.CommandBuilders;
import org.bdgenomics.cannoli.cli.CannoliFn;
import org.bdgenomics.cannoli.cli.FreebayesFnArgs;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.utils.misc.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u0017\tYaI]3fE\u0006LXm\u001d$o\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\u000f\r\fgN\\8mS*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\u0001\u0005\u0005\u0003\u000e\u001dAQR\"\u0001\u0002\n\u0005=\u0011!!C\"b]:|G.\u001b$o!\t\t\u0002$D\u0001\u0013\u0015\t\u0019B#\u0001\u0003sK\u0006$'BA\u000b\u0017\u0003\r\u0011H\r\u001a\u0006\u0003/\u0019\tA!\u00193b[&\u0011\u0011D\u0005\u0002\u0013\u00032LwM\\7f]R\u0014VmY8sIJ#E\t\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e)\u00059a/\u0019:jC:$\u0018BA\u0010\u001d\u0005E1\u0016M]5b]R\u001cuN\u001c;fqR\u0014F\t\u0012\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA!\\5tG*\u0011QEB\u0001\u0006kRLGn]\u0005\u0003O\t\u0012q\u0001T8hO&tw\r\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0001+\u0003\u0011\t'oZ:\u0016\u0003-\u0002\"!\u0004\u0017\n\u00055\u0012!a\u0004$sK\u0016\u0014\u0017-_3t\r:\f%oZ:\t\u0011=\u0002!\u0011!Q\u0001\n-\nQ!\u0019:hg\u0002B\u0011\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u001e\u0002\u0005M\u001c\u0007CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0004\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003sQ\u0012Ab\u00159be.\u001cuN\u001c;fqRL!!\r\b\t\u000bq\u0002A\u0011A\u001f\u0002\rqJg.\u001b;?)\rqt\b\u0011\t\u0003\u001b\u0001AQ!K\u001eA\u0002-BQ!M\u001eA\u0002IBQA\u0011\u0001\u0005B\r\u000bQ!\u00199qYf$\"A\u0007#\t\u000b\u0015\u000b\u0005\u0019\u0001\t\u0002\u0015\u0005d\u0017n\u001a8nK:$8\u000f")
public class FreebayesFn
extends CannoliFn<AlignmentRecordRDD, VariantContextRDD>
implements Logging {
    private final FreebayesFnArgs args;
    private transient Logger org$bdgenomics$utils$misc$Logging$$log_;

    public Logger org$bdgenomics$utils$misc$Logging$$log_() {
        return this.org$bdgenomics$utils$misc$Logging$$log_;
    }

    public void org$bdgenomics$utils$misc$Logging$$log__$eq(Logger x$1) {
        this.org$bdgenomics$utils$misc$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public FreebayesFnArgs args() {
        return this.args;
    }

    public VariantContextRDD apply(AlignmentRecordRDD alignments) {
        BoxedUnit boxedUnit;
        ObjectRef builder = ObjectRef.create((Object)CommandBuilders.create((boolean)this.args().useDocker(), (boolean)this.args().useSingularity()).setExecutable(this.args().executable()).add(new String[]{"--fasta-reference"}).add(new String[]{this.args().addFiles() ? "$0" : this.absolute(this.args().referencePath())}).add(new String[]{"--stdin"}).add(new String[]{"--strict-vcf"}));
        if (this.args().gvcf()) {
            ((CommandBuilder)builder.elem).add(new String[]{"--gvcf"});
            Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.args().gvcfChunk())).foreach((Function1)new Serializable(this, builder){
                public static final long serialVersionUID = 0L;
                private final ObjectRef builder$1;

                public final CommandBuilder apply(int i) {
                    return ((CommandBuilder)this.builder$1.elem).add(new String[]{"--gvcf-chunk"}).add(new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()});
                }
                {
                    this.builder$1 = builder$1;
                }
            });
        }
        if (this.args().addFiles()) {
            ((CommandBuilder)builder.elem).addFile(this.args().referencePath());
            boxedUnit = ((CommandBuilder)builder.elem).addFile(new StringBuilder().append((Object)this.args().referencePath()).append((Object)".fai").toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = this.args().useDocker() || this.args().useSingularity() ? ((CommandBuilder)builder.elem).setImage(this.args().image()).setSudo(this.args().sudo()).addMount(this.args().addFiles() ? "$root" : this.root(this.args().referencePath())) : BoxedUnit.UNIT;
        this.log().info("Piping {} to freebayes with command: {} files: {}", new Object[]{alignments, ((CommandBuilder)builder.elem).build(), ((CommandBuilder)builder.elem).getFiles()});
        CollectionAccumulator accumulator = super.sc().collectionAccumulator("headerLines");
        BAMInFormatter$ tFormatter = BAMInFormatter$.MODULE$;
        VCFOutFormatter uFormatter = new VCFOutFormatter(super.sc().hadoopConfiguration(), (Option)new Some((Object)accumulator));
        VariantContextRDD variantContexts = (VariantContextRDD)alignments.pipe((Seq)JavaConversions$.MODULE$.asScalaBuffer(((CommandBuilder)builder.elem).build()), (Seq)JavaConversions$.MODULE$.asScalaBuffer(((CommandBuilder)builder.elem).getFiles()), alignments.pipe$default$3(), alignments.pipe$default$4(), alignments.pipe$default$5(), (InFormatterCompanion)tFormatter, (OutFormatter)uFormatter, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VariantContextRDD apply(AlignmentRecordRDD gRdd, RDD<VariantContext> rdd) {
                return ADAMContext$.MODULE$.alignmentRecordsToVariantContextConversionFn(gRdd, rdd);
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class), ClassTag$.MODULE$.apply(VariantContext.class));
        Buffer headerLines = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(accumulator.value()).distinct();
        return variantContexts.replaceHeaderLines((Seq)headerLines);
    }

    public FreebayesFn(FreebayesFnArgs args, SparkContext sc) {
        this.args = args;
        super(sc);
        Logging.class.$init$((Logging)this);
    }
}

