/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.cannoli.cli;

import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.InFormatterCompanion;
import org.bdgenomics.adam.rdd.OutFormatter;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDD;
import org.bdgenomics.adam.rdd.read.BAMInFormatter$;
import org.bdgenomics.adam.rdd.variant.VCFOutFormatter;
import org.bdgenomics.adam.rdd.variant.VariantContextRDD;
import org.bdgenomics.cannoli.builder.CommandBuilder;
import org.bdgenomics.cannoli.builder.CommandBuilders;
import org.bdgenomics.cannoli.cli.CannoliFn;
import org.bdgenomics.cannoli.cli.SamtoolsMpileupFnArgs;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.utils.misc.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u0017\t\t2+Y7u_>d7/\u00149jY\u0016,\bO\u00128\u000b\u0005\r!\u0011aA2mS*\u0011QAB\u0001\bG\u0006tgn\u001c7j\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0001\u0003\u0003B\u0007\u000f!ii\u0011AA\u0005\u0003\u001f\t\u0011\u0011bQ1o]>d\u0017N\u00128\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012\u0001\u0002:fC\u0012T!!\u0006\f\u0002\u0007I$GM\u0003\u0002\u0018\r\u0005!\u0011\rZ1n\u0013\tI\"C\u0001\nBY&<g.\\3oiJ+7m\u001c:e%\u0012#\u0005CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0015\u0003\u001d1\u0018M]5b]RL!a\b\u000f\u0003#Y\u000b'/[1oi\u000e{g\u000e^3yiJ#E\t\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!Q.[:d\u0015\t)c!A\u0003vi&d7/\u0003\u0002(E\t9Aj\\4hS:<\u0007\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\t\u0005\u0014xm]\u000b\u0002WA\u0011Q\u0002L\u0005\u0003[\t\u0011QcU1ni>|Gn]'qS2,W\u000f\u001d$o\u0003J<7\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003,\u0003\u0015\t'oZ:!\u0011%\t\u0004A!A!\u0002\u0013\u0011$(\u0001\u0002tGB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0006gB\f'o\u001b\u0006\u0003o!\ta!\u00199bG\",\u0017BA\u001d5\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0013\t\td\u0002C\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0004}}\u0002\u0005CA\u0007\u0001\u0011\u0015I3\b1\u0001,\u0011\u0015\t4\b1\u00013\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0003\u0015\t\u0007\u000f\u001d7z)\tQB\tC\u0003F\u0003\u0002\u0007\u0001#\u0001\u0006bY&<g.\\3oiN\u0004")
public class SamtoolsMpileupFn
extends CannoliFn<AlignmentRecordRDD, VariantContextRDD>
implements Logging {
    private final SamtoolsMpileupFnArgs args;
    private transient Logger org$bdgenomics$utils$misc$Logging$$log_;

    public Logger org$bdgenomics$utils$misc$Logging$$log_() {
        return this.org$bdgenomics$utils$misc$Logging$$log_;
    }

    public void org$bdgenomics$utils$misc$Logging$$log__$eq(Logger x$1) {
        this.org$bdgenomics$utils$misc$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SamtoolsMpileupFnArgs args() {
        return this.args;
    }

    public VariantContextRDD apply(AlignmentRecordRDD alignments) {
        BoxedUnit boxedUnit;
        CommandBuilder builder = CommandBuilders.create((boolean)this.args().useDocker(), (boolean)this.args().useSingularity()).setExecutable(this.args().executable()).add(new String[]{"mpileup"}).add(new String[]{"-"}).add(new String[]{"--reference"}).add(new String[]{this.args().addFiles() ? "$0" : this.absolute(this.args().referencePath())}).add(new String[]{"-v"}).add(new String[]{"-u"});
        if (this.args().addFiles()) {
            builder.addFile(this.args().referencePath());
            boxedUnit = builder.addFile(new StringBuilder().append((Object)this.args().referencePath()).append((Object)".fai").toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = this.args().useDocker() || this.args().useSingularity() ? builder.setImage(this.args().image()).setSudo(this.args().sudo()).addMount(this.args().addFiles() ? "$root" : this.root(this.args().referencePath())) : BoxedUnit.UNIT;
        this.log().info("Piping {} to samtools with command: {} files: {}", new Object[]{alignments, builder.build(), builder.getFiles()});
        BAMInFormatter$ tFormatter = BAMInFormatter$.MODULE$;
        VCFOutFormatter uFormatter = new VCFOutFormatter(super.sc().hadoopConfiguration());
        return (VariantContextRDD)alignments.pipe((Seq)JavaConversions$.MODULE$.asScalaBuffer(builder.build()), (Seq)JavaConversions$.MODULE$.asScalaBuffer(builder.getFiles()), alignments.pipe$default$3(), alignments.pipe$default$4(), alignments.pipe$default$5(), (InFormatterCompanion)tFormatter, (OutFormatter)uFormatter, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VariantContextRDD apply(AlignmentRecordRDD gRdd, RDD<VariantContext> rdd) {
                return ADAMContext$.MODULE$.alignmentRecordsToVariantContextConversionFn(gRdd, rdd);
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class), ClassTag$.MODULE$.apply(VariantContext.class));
    }

    public SamtoolsMpileupFn(SamtoolsMpileupFnArgs args, SparkContext sc) {
        this.args = args;
        super(sc);
        Logging.class.$init$((Logging)this);
    }
}

