/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.Reads;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.TextCigarCodec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Alignment;
import org.slf4j.Logger;

@Immutable
final class AlignmentToReadAlignment
extends AbstractConverter<Alignment, Reads.ReadAlignment> {
    private final Converter<Cigar, List<Reads.CigarUnit>> cigarConverter;

    AlignmentToReadAlignment(Converter<Cigar, List<Reads.CigarUnit>> cigarConverter) {
        super(Alignment.class, Reads.ReadAlignment.class);
        this.checkNotNull(cigarConverter);
        this.cigarConverter = cigarConverter;
    }

    public Reads.ReadAlignment convert(Alignment alignment, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (alignment == null) {
            this.warnOrThrow(alignment, "must not be null", null, stringency, logger);
            return null;
        }
        Reads.ReadAlignment.Builder builder = Reads.ReadAlignment.newBuilder().setAlignedSequence(alignment.getSequence()).setDuplicateFragment(alignment.getDuplicateRead().booleanValue()).setFailedVendorQualityChecks(alignment.getFailedVendorQualityChecks().booleanValue()).setFragmentName(alignment.getReadName()).setImproperPlacement(alignment.getProperPair() == false).setNumberReads(alignment.getReadPaired() != false ? 2 : 1).setReadGroupId(StringUtils.isNotEmpty((CharSequence)alignment.getReadGroupId()) ? alignment.getReadGroupId() : "1").setReadNumber(alignment.getReadInFragment().intValue()).setSecondaryAlignment(alignment.getSecondaryAlignment().booleanValue()).setSupplementaryAlignment(alignment.getSupplementaryAlignment().booleanValue());
        if (alignment.getInsertSize() != null) {
            builder.setFragmentLength(alignment.getInsertSize().intValue());
        }
        if (alignment.getMateReferenceName() != null) {
            Common.Position matePosition = Common.Position.newBuilder().setReferenceName(alignment.getMateReferenceName()).setPosition(alignment.getMateAlignmentStart().longValue()).setStrand(alignment.getMateNegativeStrand() != false ? Common.Strand.NEG_STRAND : Common.Strand.POS_STRAND).build();
            builder.setNextMatePosition(matePosition);
        }
        if (StringUtils.isNotEmpty((CharSequence)alignment.getQualityScores())) {
            ArrayList<Integer> alignedQuality = new ArrayList<Integer>(alignment.getQualityScores().length());
            for (char c : alignment.getQualityScores().toCharArray()) {
                alignedQuality.add(c - 33);
            }
            builder.addAllAlignedQuality(alignedQuality);
        }
        if (alignment.getReadMapped().booleanValue()) {
            Common.Position position = Common.Position.newBuilder().setReferenceName(alignment.getReferenceName()).setPosition(alignment.getStart().longValue()).setStrand(alignment.getReadNegativeStrand() != false ? Common.Strand.NEG_STRAND : Common.Strand.POS_STRAND).build();
            Reads.LinearAlignment.Builder alignmentBuilder = Reads.LinearAlignment.newBuilder().setPosition(position);
            if (alignment.getMappingQuality() != null) {
                alignmentBuilder.setMappingQuality(alignment.getMappingQuality().intValue());
            }
            Cigar cigar = null;
            try {
                cigar = TextCigarCodec.decode((String)alignment.getCigar());
            }
            catch (RuntimeException e) {
                this.warnOrThrow(alignment, "could not decode cigar, caught " + e.getMessage(), e, stringency, logger);
            }
            if (cigar != null) {
                alignmentBuilder.addAllCigar((Iterable)this.cigarConverter.convert((Object)cigar, stringency, logger));
            }
            builder.setAlignment(alignmentBuilder.build());
        }
        return builder.build();
    }
}

