/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import ga4gh.Variants;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.slf4j.Logger;

@Immutable
public class BdgenomicsGenotypeToGa4ghCall
extends AbstractConverter<Genotype, Variants.Call> {
    private final Converter<GenotypeAllele, String> genotypeAlleleConverter;

    BdgenomicsGenotypeToGa4ghCall(Converter<GenotypeAllele, String> genotypeAlleleConverter) {
        super(Genotype.class, Variants.Call.class);
        this.checkNotNull(genotypeAlleleConverter);
        this.genotypeAlleleConverter = genotypeAlleleConverter;
    }

    public Variants.Call convert(Genotype genotype, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (genotype == null) {
            this.warnOrThrow(genotype, "must not be null", null, stringency, logger);
            return null;
        }
        List inputAlleles = genotype.getAlleles();
        String alleleFirst = (String)this.genotypeAlleleConverter.convert((Object)((GenotypeAllele)inputAlleles.get(0)), stringency, logger);
        String alleleSecond = ".";
        if (inputAlleles.size() == 2) {
            alleleSecond = (String)this.genotypeAlleleConverter.convert((Object)((GenotypeAllele)inputAlleles.get(1)), stringency, logger);
        }
        Value alleleFirstValue = Value.newBuilder().setStringValue(alleleFirst).build();
        Value alleleSecondValue = Value.newBuilder().setStringValue(alleleSecond).build();
        ListValue calls = ListValue.newBuilder().addValues(alleleFirstValue).addValues(alleleSecondValue).build();
        List gl = genotype.getGenotypeLikelihoods();
        Variants.Call.Builder builder = Variants.Call.newBuilder();
        if (genotype.getSampleId() != null) {
            builder.setCallSetName(genotype.getSampleId());
        }
        builder.setGenotype(calls);
        if (genotype.getPhased().booleanValue() && genotype.getPhaseSetId() != null) {
            builder = builder.setPhaseset(genotype.getPhaseSetId().toString());
        }
        if (!gl.isEmpty()) {
            builder = builder.addAllGenotypeLikelihood((Iterable)gl);
        }
        builder.setCallSetId(genotype.getSampleId());
        return builder.build();
    }
}

