/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.Reads;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.formats.avro.ReadGroup;
import org.slf4j.Logger;

@Immutable
final class BdgenomicsReadGroupToGa4ghReadGroup
extends AbstractConverter<ReadGroup, Reads.ReadGroup> {
    private final Converter<ProcessingStep, Common.Program> processingStepConverter;

    BdgenomicsReadGroupToGa4ghReadGroup(Converter<ProcessingStep, Common.Program> processingStepConverter) {
        super(ReadGroup.class, Reads.ReadGroup.class);
        this.checkNotNull(processingStepConverter);
        this.processingStepConverter = processingStepConverter;
    }

    public Reads.ReadGroup convert(ReadGroup readGroup, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (readGroup == null) {
            this.warnOrThrow(readGroup, "must not be null", null, stringency, logger);
            return null;
        }
        Reads.ReadGroup.Builder builder = Reads.ReadGroup.newBuilder().setId(StringUtils.isNotEmpty((CharSequence)readGroup.getId()) ? readGroup.getId() : "1").setName(StringUtils.isNotEmpty((CharSequence)readGroup.getId()) ? readGroup.getId() : "1");
        if (StringUtils.isNotEmpty((CharSequence)readGroup.getSampleId())) {
            builder.setSampleName(readGroup.getSampleId());
        }
        if (StringUtils.isNotEmpty((CharSequence)readGroup.getDescription())) {
            builder.setDescription(readGroup.getDescription());
        }
        if (readGroup.getPredictedMedianInsertSize() != null) {
            builder.setPredictedInsertSize(readGroup.getPredictedMedianInsertSize().intValue());
        }
        if (!readGroup.getProcessingSteps().isEmpty()) {
            for (ProcessingStep processingStep : readGroup.getProcessingSteps()) {
                builder.addPrograms((Common.Program)this.processingStepConverter.convert((Object)processingStep, stringency, logger));
            }
        }
        return builder.build();
    }
}

