/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Reads;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.slf4j.Logger;

@Immutable
final class CigarToCigarUnits
extends AbstractConverter<Cigar, List<Reads.CigarUnit>> {
    private final Converter<CigarOperator, Reads.CigarUnit.Operation> operatorConverter;

    CigarToCigarUnits(Converter<CigarOperator, Reads.CigarUnit.Operation> operatorConverter) {
        super(Cigar.class, List.class);
        this.checkNotNull(operatorConverter);
        this.operatorConverter = operatorConverter;
    }

    public List<Reads.CigarUnit> convert(Cigar cigar, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (cigar == null) {
            this.warnOrThrow(cigar, "must not be null", null, stringency, logger);
            return null;
        }
        if (cigar.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Reads.CigarUnit> cigarUnits = new ArrayList<Reads.CigarUnit>(cigar.numCigarElements());
        for (CigarElement cigarElement : cigar) {
            cigarUnits.add(Reads.CigarUnit.newBuilder().setOperationLength((long)cigarElement.getLength()).setOperation((Reads.CigarUnit.Operation)this.operatorConverter.convert((Object)cigarElement.getOperator(), stringency, logger)).build());
        }
        return cigarUnits;
    }
}

