/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.Reads;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.formats.avro.ReadGroup;
import org.slf4j.Logger;

@Immutable
final class Ga4ghReadGroupToBdgenomicsReadGroup
extends AbstractConverter<Reads.ReadGroup, ReadGroup> {
    private final Converter<Common.Program, ProcessingStep> programConverter;

    Ga4ghReadGroupToBdgenomicsReadGroup(Converter<Common.Program, ProcessingStep> programConverter) {
        super(Reads.ReadGroup.class, ReadGroup.class);
        this.checkNotNull(programConverter);
        this.programConverter = programConverter;
    }

    public ReadGroup convert(Reads.ReadGroup readGroup, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (readGroup == null) {
            this.warnOrThrow(readGroup, "must not be null", null, stringency, logger);
            return null;
        }
        ReadGroup.Builder builder = ReadGroup.newBuilder().setId(readGroup.getId()).setSampleId(readGroup.getSampleName()).setDescription(readGroup.getDescription()).setPredictedMedianInsertSize(Integer.valueOf(readGroup.getPredictedInsertSize()));
        List programs = readGroup.getProgramsList();
        if (!programs.isEmpty()) {
            ArrayList<ProcessingStep> processingSteps = new ArrayList<ProcessingStep>(programs.size());
            for (Common.Program program : programs) {
                processingSteps.add((ProcessingStep)this.programConverter.convert((Object)program, stringency, logger));
            }
            builder.setProcessingSteps(processingSteps);
        }
        return builder.build();
    }
}

