/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.SequenceAnnotations;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Feature;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

@Immutable
final class BdgenomicsFeatureToGa4ghFeature
extends AbstractConverter<Feature, SequenceAnnotations.Feature> {
    private final Converter<String, Common.OntologyTerm> featureTypeConverter;
    private final Converter<Strand, Common.Strand> strandConverter;
    private final Converter<Map<String, String>, Common.Attributes> attributeConverter;

    BdgenomicsFeatureToGa4ghFeature(Converter<String, Common.OntologyTerm> featureTypeConverter, Converter<Strand, Common.Strand> strandConverter, Converter<Map<String, String>, Common.Attributes> attributeConverter) {
        super(Feature.class, SequenceAnnotations.Feature.class);
        this.checkNotNull(featureTypeConverter);
        this.checkNotNull(strandConverter);
        this.checkNotNull(attributeConverter);
        this.featureTypeConverter = featureTypeConverter;
        this.strandConverter = strandConverter;
        this.attributeConverter = attributeConverter;
    }

    public SequenceAnnotations.Feature convert(Feature feature, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (feature == null) {
            this.warnOrThrow(feature, "must not be null", null, stringency, logger);
            return null;
        }
        SequenceAnnotations.Feature.Builder builder = SequenceAnnotations.Feature.newBuilder();
        if (feature.getStart() != null) {
            builder.setStart(feature.getStart().longValue());
        }
        if (feature.getEnd() != null) {
            builder.setEnd(feature.getEnd().longValue());
        }
        if (feature.getName() != null) {
            builder.setName(feature.getName());
        }
        if (feature.getStrand() != null) {
            builder.setStrand((Common.Strand)this.strandConverter.convert((Object)feature.getStrand(), stringency, logger));
        }
        if (feature.getReferenceName() != null) {
            builder.setReferenceName(feature.getReferenceName());
        }
        if (feature.getFeatureId() != null) {
            builder.setId(feature.getFeatureId());
        }
        if (feature.getGeneId() != null) {
            builder.setGeneSymbol(feature.getGeneId());
        }
        if (feature.getFeatureType() != null) {
            builder.setFeatureType(Common.OntologyTerm.newBuilder().setTermId(feature.getFeatureType()));
        }
        if (feature.getAttributes() != null) {
            builder.setAttributes((Common.Attributes)this.attributeConverter.convert((Object)feature.getAttributes(), stringency, logger));
        }
        return builder.build();
    }
}

